<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Archiver_Req StructType
 * @subpackage Structs
 */
class Archiver_Req extends AbstractStructBase
{
    /**
     * The IDDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDDemarche;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The Fichiers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeFichiersUpload
     */
    public $Fichiers;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The AutoInclusion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoInclusion;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for Archiver_Req
     * @uses Archiver_Req::setIDDemarche()
     * @uses Archiver_Req::setTypeDemarche()
     * @uses Archiver_Req::setFichiers()
     * @uses Archiver_Req::setIdentification()
     * @uses Archiver_Req::setAutoInclusion()
     * @uses Archiver_Req::setOrigine()
     * @param int $iDDemarche
     * @param string $typeDemarche
     * @param \StructType\TypeFichiersUpload $fichiers
     * @param \StructType\TypeIdentification $identification
     * @param bool $autoInclusion
     * @param string $origine
     */
    public function __construct($iDDemarche = null, $typeDemarche = null, \StructType\TypeFichiersUpload $fichiers = null, \StructType\TypeIdentification $identification = null, $autoInclusion = null, $origine = null)
    {
        $this
            ->setIDDemarche($iDDemarche)
            ->setTypeDemarche($typeDemarche)
            ->setFichiers($fichiers)
            ->setIdentification($identification)
            ->setAutoInclusion($autoInclusion)
            ->setOrigine($origine);
    }
    /**
     * Get IDDemarche value
     * @return int
     */
    public function getIDDemarche()
    {
        return $this->IDDemarche;
    }
    /**
     * Set IDDemarche value
     * @param int $iDDemarche
     * @return \StructType\Archiver_Req
     */
    public function setIDDemarche($iDDemarche = null)
    {
        // validation for constraint: int
        if (!is_null($iDDemarche) && !(is_int($iDDemarche) || ctype_digit($iDDemarche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDemarche, true), gettype($iDDemarche)), __LINE__);
        }
        $this->IDDemarche = $iDDemarche;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\Archiver_Req
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get Fichiers value
     * @return \StructType\TypeFichiersUpload
     */
    public function getFichiers()
    {
        return $this->Fichiers;
    }
    /**
     * Set Fichiers value
     * @param \StructType\TypeFichiersUpload $fichiers
     * @return \StructType\Archiver_Req
     */
    public function setFichiers(\StructType\TypeFichiersUpload $fichiers = null)
    {
        $this->Fichiers = $fichiers;
        return $this;
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification|null
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\Archiver_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get AutoInclusion value
     * @return bool|null
     */
    public function getAutoInclusion()
    {
        return $this->AutoInclusion;
    }
    /**
     * Set AutoInclusion value
     * @param bool $autoInclusion
     * @return \StructType\Archiver_Req
     */
    public function setAutoInclusion($autoInclusion = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoInclusion) && !is_bool($autoInclusion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoInclusion, true), gettype($autoInclusion)), __LINE__);
        }
        $this->AutoInclusion = $autoInclusion;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\Archiver_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
}
