<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Chercher ServiceType
 * @subpackage Services
 */
class Chercher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Chercher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Chercher_Req $chercherRepMsg
     * @return \StructType\Chercher_Rep|bool
     */
    public function Chercher(\StructType\Chercher_Req $chercherRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Chercher($chercherRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Chercher_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
