<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifTechnique StructType
 * @subpackage Structs
 */
class ModifTechnique extends AbstractStructBase
{
    /**
     * The TypeReception
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeReception;
    /**
     * The K_NumRecepCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $K_NumRecepCE;
    /**
     * The BrideeDebridee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $BrideeDebridee;
    /**
     * The D21_CNIT
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $D21_CNIT;
    /**
     * The F1_MMaxTechAdm
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $F1_MMaxTechAdm;
    /**
     * The F2_MMaxAdmServ
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $F2_MMaxAdmServ;
    /**
     * The S1_NbPlaceAssise
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var int
     */
    public $S1_NbPlaceAssise;
    /**
     * Constructor method for ModifTechnique
     * @uses ModifTechnique::setTypeReception()
     * @uses ModifTechnique::setK_NumRecepCE()
     * @uses ModifTechnique::setBrideeDebridee()
     * @uses ModifTechnique::setD21_CNIT()
     * @uses ModifTechnique::setF1_MMaxTechAdm()
     * @uses ModifTechnique::setF2_MMaxAdmServ()
     * @uses ModifTechnique::setS1_NbPlaceAssise()
     * @param string $typeReception
     * @param string $k_NumRecepCE
     * @param bool $brideeDebridee
     * @param string $d21_CNIT
     * @param int $f1_MMaxTechAdm
     * @param int $f2_MMaxAdmServ
     * @param int $s1_NbPlaceAssise
     */
    public function __construct($typeReception = null, $k_NumRecepCE = null, $brideeDebridee = null, $d21_CNIT = null, $f1_MMaxTechAdm = null, $f2_MMaxAdmServ = null, $s1_NbPlaceAssise = null)
    {
        $this
            ->setTypeReception($typeReception)
            ->setK_NumRecepCE($k_NumRecepCE)
            ->setBrideeDebridee($brideeDebridee)
            ->setD21_CNIT($d21_CNIT)
            ->setF1_MMaxTechAdm($f1_MMaxTechAdm)
            ->setF2_MMaxAdmServ($f2_MMaxAdmServ)
            ->setS1_NbPlaceAssise($s1_NbPlaceAssise);
    }
    /**
     * Get TypeReception value
     * @return string
     */
    public function getTypeReception()
    {
        return $this->TypeReception;
    }
    /**
     * Set TypeReception value
     * @uses \EnumType\TypeReception::valueIsValid()
     * @uses \EnumType\TypeReception::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeReception
     * @return \StructType\ModifTechnique
     */
    public function setTypeReception($typeReception = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeReception::valueIsValid($typeReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeReception', is_array($typeReception) ? implode(', ', $typeReception) : var_export($typeReception, true), implode(', ', \EnumType\TypeReception::getValidValues())), __LINE__);
        }
        $this->TypeReception = $typeReception;
        return $this;
    }
    /**
     * Get K_NumRecepCE value
     * @return string|null
     */
    public function getK_NumRecepCE()
    {
        return $this->K_NumRecepCE;
    }
    /**
     * Set K_NumRecepCE value
     * @param string $k_NumRecepCE
     * @return \StructType\ModifTechnique
     */
    public function setK_NumRecepCE($k_NumRecepCE = null)
    {
        // validation for constraint: string
        if (!is_null($k_NumRecepCE) && !is_string($k_NumRecepCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($k_NumRecepCE, true), gettype($k_NumRecepCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($k_NumRecepCE) && mb_strlen($k_NumRecepCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($k_NumRecepCE)), __LINE__);
        }
        $this->K_NumRecepCE = $k_NumRecepCE;
        return $this;
    }
    /**
     * Get BrideeDebridee value
     * @return bool|null
     */
    public function getBrideeDebridee()
    {
        return $this->BrideeDebridee;
    }
    /**
     * Set BrideeDebridee value
     * @param bool $brideeDebridee
     * @return \StructType\ModifTechnique
     */
    public function setBrideeDebridee($brideeDebridee = null)
    {
        // validation for constraint: boolean
        if (!is_null($brideeDebridee) && !is_bool($brideeDebridee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($brideeDebridee, true), gettype($brideeDebridee)), __LINE__);
        }
        $this->BrideeDebridee = $brideeDebridee;
        return $this;
    }
    /**
     * Get D21_CNIT value
     * @return string|null
     */
    public function getD21_CNIT()
    {
        return $this->D21_CNIT;
    }
    /**
     * Set D21_CNIT value
     * @param string $d21_CNIT
     * @return \StructType\ModifTechnique
     */
    public function setD21_CNIT($d21_CNIT = null)
    {
        // validation for constraint: string
        if (!is_null($d21_CNIT) && !is_string($d21_CNIT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d21_CNIT, true), gettype($d21_CNIT)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($d21_CNIT) && mb_strlen($d21_CNIT) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($d21_CNIT)), __LINE__);
        }
        $this->D21_CNIT = $d21_CNIT;
        return $this;
    }
    /**
     * Get F1_MMaxTechAdm value
     * @return int|null
     */
    public function getF1_MMaxTechAdm()
    {
        return $this->F1_MMaxTechAdm;
    }
    /**
     * Set F1_MMaxTechAdm value
     * @param int $f1_MMaxTechAdm
     * @return \StructType\ModifTechnique
     */
    public function setF1_MMaxTechAdm($f1_MMaxTechAdm = null)
    {
        // validation for constraint: int
        if (!is_null($f1_MMaxTechAdm) && !(is_int($f1_MMaxTechAdm) || ctype_digit($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f1_MMaxTechAdm, true), gettype($f1_MMaxTechAdm)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f1_MMaxTechAdm) && mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f1_MMaxTechAdm, true), mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm))), __LINE__);
        }
        $this->F1_MMaxTechAdm = $f1_MMaxTechAdm;
        return $this;
    }
    /**
     * Get F2_MMaxAdmServ value
     * @return int|null
     */
    public function getF2_MMaxAdmServ()
    {
        return $this->F2_MMaxAdmServ;
    }
    /**
     * Set F2_MMaxAdmServ value
     * @param int $f2_MMaxAdmServ
     * @return \StructType\ModifTechnique
     */
    public function setF2_MMaxAdmServ($f2_MMaxAdmServ = null)
    {
        // validation for constraint: int
        if (!is_null($f2_MMaxAdmServ) && !(is_int($f2_MMaxAdmServ) || ctype_digit($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f2_MMaxAdmServ, true), gettype($f2_MMaxAdmServ)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f2_MMaxAdmServ) && mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f2_MMaxAdmServ, true), mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ))), __LINE__);
        }
        $this->F2_MMaxAdmServ = $f2_MMaxAdmServ;
        return $this;
    }
    /**
     * Get S1_NbPlaceAssise value
     * @return int|null
     */
    public function getS1_NbPlaceAssise()
    {
        return $this->S1_NbPlaceAssise;
    }
    /**
     * Set S1_NbPlaceAssise value
     * @param int $s1_NbPlaceAssise
     * @return \StructType\ModifTechnique
     */
    public function setS1_NbPlaceAssise($s1_NbPlaceAssise = null)
    {
        // validation for constraint: int
        if (!is_null($s1_NbPlaceAssise) && !(is_int($s1_NbPlaceAssise) || ctype_digit($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s1_NbPlaceAssise, true), gettype($s1_NbPlaceAssise)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s1_NbPlaceAssise) && mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s1_NbPlaceAssise, true), mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise))), __LINE__);
        }
        $this->S1_NbPlaceAssise = $s1_NbPlaceAssise;
        return $this;
    }
}
