<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ControleSIV_Req StructType
 * @subpackage Structs
 */
class ControleSIV_Req extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The IDDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDDemarche;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The PrefectureDepartement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrefectureDepartement;
    /**
     * The ControleurMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 1
     * @var string[]
     */
    public $ControleurMail;
    /**
     * The PartageDocumentExterne
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PartageDocumentExterne;
    /**
     * The Fichiers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeFichiersControle
     */
    public $Fichiers;
    /**
     * The Commentaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Commentaire;
    /**
     * The CopieMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var string[]
     */
    public $CopieMail;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for ControleSIV_Req
     * @uses ControleSIV_Req::setIdentification()
     * @uses ControleSIV_Req::setIDDemarche()
     * @uses ControleSIV_Req::setTypeDemarche()
     * @uses ControleSIV_Req::setPrefectureDepartement()
     * @uses ControleSIV_Req::setControleurMail()
     * @uses ControleSIV_Req::setPartageDocumentExterne()
     * @uses ControleSIV_Req::setFichiers()
     * @uses ControleSIV_Req::setCommentaire()
     * @uses ControleSIV_Req::setCopieMail()
     * @uses ControleSIV_Req::setOrigine()
     * @param \StructType\TypeIdentification $identification
     * @param int $iDDemarche
     * @param string $typeDemarche
     * @param string $prefectureDepartement
     * @param string[] $controleurMail
     * @param bool $partageDocumentExterne
     * @param \StructType\TypeFichiersControle $fichiers
     * @param string $commentaire
     * @param string[] $copieMail
     * @param string $origine
     */
    public function __construct(\StructType\TypeIdentification $identification = null, $iDDemarche = null, $typeDemarche = null, $prefectureDepartement = null, array $controleurMail = array(), $partageDocumentExterne = null, \StructType\TypeFichiersControle $fichiers = null, $commentaire = null, array $copieMail = array(), $origine = null)
    {
        $this
            ->setIdentification($identification)
            ->setIDDemarche($iDDemarche)
            ->setTypeDemarche($typeDemarche)
            ->setPrefectureDepartement($prefectureDepartement)
            ->setControleurMail($controleurMail)
            ->setPartageDocumentExterne($partageDocumentExterne)
            ->setFichiers($fichiers)
            ->setCommentaire($commentaire)
            ->setCopieMail($copieMail)
            ->setOrigine($origine);
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\ControleSIV_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get IDDemarche value
     * @return int
     */
    public function getIDDemarche()
    {
        return $this->IDDemarche;
    }
    /**
     * Set IDDemarche value
     * @param int $iDDemarche
     * @return \StructType\ControleSIV_Req
     */
    public function setIDDemarche($iDDemarche = null)
    {
        // validation for constraint: int
        if (!is_null($iDDemarche) && !(is_int($iDDemarche) || ctype_digit($iDDemarche))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDemarche, true), gettype($iDDemarche)), __LINE__);
        }
        $this->IDDemarche = $iDDemarche;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\ControleSIV_Req
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get PrefectureDepartement value
     * @return string
     */
    public function getPrefectureDepartement()
    {
        return $this->PrefectureDepartement;
    }
    /**
     * Set PrefectureDepartement value
     * @param string $prefectureDepartement
     * @return \StructType\ControleSIV_Req
     */
    public function setPrefectureDepartement($prefectureDepartement = null)
    {
        // validation for constraint: string
        if (!is_null($prefectureDepartement) && !is_string($prefectureDepartement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefectureDepartement, true), gettype($prefectureDepartement)), __LINE__);
        }
        $this->PrefectureDepartement = $prefectureDepartement;
        return $this;
    }
    /**
     * Get ControleurMail value
     * @return string[]
     */
    public function getControleurMail()
    {
        return $this->ControleurMail;
    }
    /**
     * This method is responsible for validating the values passed to the setControleurMail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setControleurMail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateControleurMailForArrayConstraintsFromSetControleurMail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $controleSIV_ReqControleurMailItem) {
            // validation for constraint: itemType
            if (!is_string($controleSIV_ReqControleurMailItem)) {
                $invalidValues[] = is_object($controleSIV_ReqControleurMailItem) ? get_class($controleSIV_ReqControleurMailItem) : sprintf('%s(%s)', gettype($controleSIV_ReqControleurMailItem), var_export($controleSIV_ReqControleurMailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ControleurMail property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ControleurMail value
     * @throws \InvalidArgumentException
     * @param string[] $controleurMail
     * @return \StructType\ControleSIV_Req
     */
    public function setControleurMail(array $controleurMail = array())
    {
        // validation for constraint: array
        if ('' !== ($controleurMailArrayErrorMessage = self::validateControleurMailForArrayConstraintsFromSetControleurMail($controleurMail))) {
            throw new \InvalidArgumentException($controleurMailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($controleurMail) && count($controleurMail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($controleurMail)), __LINE__);
        }
        $this->ControleurMail = $controleurMail;
        return $this;
    }
    /**
     * Add item to ControleurMail value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ControleSIV_Req
     */
    public function addToControleurMail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ControleurMail property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->ControleurMail) && count($this->ControleurMail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->ControleurMail)), __LINE__);
        }
        $this->ControleurMail[] = $item;
        return $this;
    }
    /**
     * Get PartageDocumentExterne value
     * @return bool|null
     */
    public function getPartageDocumentExterne()
    {
        return $this->PartageDocumentExterne;
    }
    /**
     * Set PartageDocumentExterne value
     * @param bool $partageDocumentExterne
     * @return \StructType\ControleSIV_Req
     */
    public function setPartageDocumentExterne($partageDocumentExterne = null)
    {
        // validation for constraint: boolean
        if (!is_null($partageDocumentExterne) && !is_bool($partageDocumentExterne)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($partageDocumentExterne, true), gettype($partageDocumentExterne)), __LINE__);
        }
        $this->PartageDocumentExterne = $partageDocumentExterne;
        return $this;
    }
    /**
     * Get Fichiers value
     * @return \StructType\TypeFichiersControle|null
     */
    public function getFichiers()
    {
        return $this->Fichiers;
    }
    /**
     * Set Fichiers value
     * @param \StructType\TypeFichiersControle $fichiers
     * @return \StructType\ControleSIV_Req
     */
    public function setFichiers(\StructType\TypeFichiersControle $fichiers = null)
    {
        $this->Fichiers = $fichiers;
        return $this;
    }
    /**
     * Get Commentaire value
     * @return string|null
     */
    public function getCommentaire()
    {
        return $this->Commentaire;
    }
    /**
     * Set Commentaire value
     * @param string $commentaire
     * @return \StructType\ControleSIV_Req
     */
    public function setCommentaire($commentaire = null)
    {
        // validation for constraint: string
        if (!is_null($commentaire) && !is_string($commentaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commentaire, true), gettype($commentaire)), __LINE__);
        }
        $this->Commentaire = $commentaire;
        return $this;
    }
    /**
     * Get CopieMail value
     * @return string[]|null
     */
    public function getCopieMail()
    {
        return $this->CopieMail;
    }
    /**
     * This method is responsible for validating the values passed to the setCopieMail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCopieMail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCopieMailForArrayConstraintsFromSetCopieMail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $controleSIV_ReqCopieMailItem) {
            // validation for constraint: itemType
            if (!is_string($controleSIV_ReqCopieMailItem)) {
                $invalidValues[] = is_object($controleSIV_ReqCopieMailItem) ? get_class($controleSIV_ReqCopieMailItem) : sprintf('%s(%s)', gettype($controleSIV_ReqCopieMailItem), var_export($controleSIV_ReqCopieMailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CopieMail property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CopieMail value
     * @throws \InvalidArgumentException
     * @param string[] $copieMail
     * @return \StructType\ControleSIV_Req
     */
    public function setCopieMail(array $copieMail = array())
    {
        // validation for constraint: array
        if ('' !== ($copieMailArrayErrorMessage = self::validateCopieMailForArrayConstraintsFromSetCopieMail($copieMail))) {
            throw new \InvalidArgumentException($copieMailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($copieMail) && count($copieMail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($copieMail)), __LINE__);
        }
        $this->CopieMail = $copieMail;
        return $this;
    }
    /**
     * Add item to CopieMail value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ControleSIV_Req
     */
    public function addToCopieMail($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CopieMail property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->CopieMail) && count($this->CopieMail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->CopieMail)), __LINE__);
        }
        $this->CopieMail[] = $item;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\ControleSIV_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
}
