<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeECG StructType
 * @subpackage Structs
 */
class TypeECG extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: ECG
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The TypeECG
     * Meta information extracted from the WSDL
     * - choice: TypeECG | Vehicule
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeDemarcheECG
     */
    public $TypeECG;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - choice: TypeECG | Vehicule
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeECG
     * @uses TypeECG::setID()
     * @uses TypeECG::setTypeDemarche()
     * @uses TypeECG::setTypeECG()
     * @uses TypeECG::setVehicule()
     * @uses TypeECG::setReponse()
     * @param int $iD
     * @param string $typeDemarche
     * @param \StructType\TypeDemarcheECG $typeECG
     * @param \StructType\Vehicule $vehicule
     * @param \StructType\Reponse $reponse
     */
    public function __construct($iD = null, $typeDemarche = null, \StructType\TypeDemarcheECG $typeECG = null, \StructType\Vehicule $vehicule = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setID($iD)
            ->setTypeDemarche($typeDemarche)
            ->setTypeECG($typeECG)
            ->setVehicule($vehicule)
            ->setReponse($reponse);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeECG
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeECG
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get TypeECG value
     * @return \StructType\TypeDemarcheECG|null
     */
    public function getTypeECG()
    {
        return isset($this->TypeECG) ? $this->TypeECG : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTypeECG method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeECG method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTypeECGForChoiceConstraintsFromSetTypeECG($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Vehicule',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TypeECG can\'t be set as the property %s is already set. Only one property must be set among these properties: TypeECG, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TypeECG value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDemarcheECG $typeECG
     * @return \StructType\TypeECG
     */
    public function setTypeECG(\StructType\TypeDemarcheECG $typeECG = null)
    {
        // validation for constraint: choice(TypeECG, Vehicule)
        if ('' !== ($typeECGChoiceErrorMessage = self::validateTypeECGForChoiceConstraintsFromSetTypeECG($typeECG))) {
            throw new \InvalidArgumentException($typeECGChoiceErrorMessage, __LINE__);
        }
        if (is_null($typeECG) || (is_array($typeECG) && empty($typeECG))) {
            unset($this->TypeECG);
        } else {
            $this->TypeECG = $typeECG;
        }
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule|null
     */
    public function getVehicule()
    {
        return isset($this->Vehicule) ? $this->Vehicule : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVehicule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicule method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVehiculeForChoiceConstraintsFromSetVehicule($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TypeECG',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Vehicule can\'t be set as the property %s is already set. Only one property must be set among these properties: Vehicule, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Vehicule value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeECG
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        // validation for constraint: choice(TypeECG, Vehicule)
        if ('' !== ($vehiculeChoiceErrorMessage = self::validateVehiculeForChoiceConstraintsFromSetVehicule($vehicule))) {
            throw new \InvalidArgumentException($vehiculeChoiceErrorMessage, __LINE__);
        }
        if (is_null($vehicule) || (is_array($vehicule) && empty($vehicule))) {
            unset($this->Vehicule);
        } else {
            $this->Vehicule = $vehicule;
        }
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeECG
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
}
