<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoVIN_Req StructType
 * @subpackage Structs
 */
class InfoVIN_Req extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The ModeString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModeString;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for InfoVIN_Req
     * @uses InfoVIN_Req::setIdentification()
     * @uses InfoVIN_Req::setVIN()
     * @uses InfoVIN_Req::setModeString()
     * @uses InfoVIN_Req::setOrigine()
     * @param \StructType\TypeIdentification $identification
     * @param string $vIN
     * @param bool $modeString
     * @param string $origine
     */
    public function __construct(\StructType\TypeIdentification $identification = null, $vIN = null, $modeString = null, $origine = null)
    {
        $this
            ->setIdentification($identification)
            ->setVIN($vIN)
            ->setModeString($modeString)
            ->setOrigine($origine);
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\InfoVIN_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\InfoVIN_Req
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get ModeString value
     * @return bool|null
     */
    public function getModeString()
    {
        return $this->ModeString;
    }
    /**
     * Set ModeString value
     * @param bool $modeString
     * @return \StructType\InfoVIN_Req
     */
    public function setModeString($modeString = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeString) && !is_bool($modeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeString, true), gettype($modeString)), __LINE__);
        }
        $this->ModeString = $modeString;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\InfoVIN_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
}
