<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoImmat_Rep StructType
 * @subpackage Structs
 */
class InfoImmat_Rep extends AbstractStructBase
{
    /**
     * The InfoVehicule
     * Meta information extracted from the WSDL
     * - choice: InfoVehicule | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InfoImmat
     */
    public $InfoVehicule;
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - choice: InfoVehicule | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - choice: InfoVehicule | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * Constructor method for InfoImmat_Rep
     * @uses InfoImmat_Rep::setInfoVehicule()
     * @uses InfoImmat_Rep::setErreur()
     * @uses InfoImmat_Rep::setCode()
     * @param \StructType\InfoImmat $infoVehicule
     * @param string $erreur
     * @param int $code
     */
    public function __construct(\StructType\InfoImmat $infoVehicule = null, $erreur = null, $code = null)
    {
        $this
            ->setInfoVehicule($infoVehicule)
            ->setErreur($erreur)
            ->setCode($code);
    }
    /**
     * Get InfoVehicule value
     * @return \StructType\InfoImmat
     */
    public function getInfoVehicule()
    {
        return isset($this->InfoVehicule) ? $this->InfoVehicule : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInfoVehicule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoVehicule method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInfoVehiculeForChoiceConstraintsFromSetInfoVehicule($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InfoVehicule can\'t be set as the property %s is already set. Only one property must be set among these properties: InfoVehicule, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InfoVehicule value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InfoImmat $infoVehicule
     * @return \StructType\InfoImmat_Rep
     */
    public function setInfoVehicule(\StructType\InfoImmat $infoVehicule = null)
    {
        // validation for constraint: choice(InfoVehicule, Erreur, Code)
        if ('' !== ($infoVehiculeChoiceErrorMessage = self::validateInfoVehiculeForChoiceConstraintsFromSetInfoVehicule($infoVehicule))) {
            throw new \InvalidArgumentException($infoVehiculeChoiceErrorMessage, __LINE__);
        }
        if (is_null($infoVehicule) || (is_array($infoVehicule) && empty($infoVehicule))) {
            unset($this->InfoVehicule);
        } else {
            $this->InfoVehicule = $infoVehicule;
        }
        return $this;
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return isset($this->Erreur) ? $this->Erreur : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErreur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreur method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErreurForChoiceConstraintsFromSetErreur($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'InfoVehicule',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Erreur can\'t be set as the property %s is already set. Only one property must be set among these properties: Erreur, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Erreur value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $erreur
     * @return \StructType\InfoImmat_Rep
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        // validation for constraint: choice(InfoVehicule, Erreur, Code)
        if ('' !== ($erreurChoiceErrorMessage = self::validateErreurForChoiceConstraintsFromSetErreur($erreur))) {
            throw new \InvalidArgumentException($erreurChoiceErrorMessage, __LINE__);
        }
        if (is_null($erreur) || (is_array($erreur) && empty($erreur))) {
            unset($this->Erreur);
        } else {
            $this->Erreur = $erreur;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'InfoVehicule',
            'Erreur',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Code can\'t be set as the property %s is already set. Only one property must be set among these properties: Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $code
     * @return \StructType\InfoImmat_Rep
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: choice(InfoVehicule, Erreur, Code)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
}
