<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Locataire StructType
 * @subpackage Structs
 */
class Locataire extends AbstractStructBase
{
    /**
     * The PersonneMorale
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | NomPrenom | PersonneMorale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonneMorale
     */
    public $PersonneMorale;
    /**
     * The PersonnePhysique
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonnePhysique
     */
    public $PersonnePhysique;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $Adresse;
    /**
     * The DroitOpposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DroitOpposition;
    /**
     * The NomPrenom
     * Meta information extracted from the WSDL
     * - choice: NomPrenom | PersonneMorale
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomPrenom;
    /**
     * Constructor method for Locataire
     * @uses Locataire::setPersonneMorale()
     * @uses Locataire::setPersonnePhysique()
     * @uses Locataire::setAdresse()
     * @uses Locataire::setDroitOpposition()
     * @uses Locataire::setNomPrenom()
     * @param \StructType\PersonneMorale $personneMorale
     * @param \StructType\PersonnePhysique $personnePhysique
     * @param \StructType\TypeAdresse $adresse
     * @param bool $droitOpposition
     * @param string $nomPrenom
     */
    public function __construct(\StructType\PersonneMorale $personneMorale = null, \StructType\PersonnePhysique $personnePhysique = null, \StructType\TypeAdresse $adresse = null, $droitOpposition = null, $nomPrenom = null)
    {
        $this
            ->setPersonneMorale($personneMorale)
            ->setPersonnePhysique($personnePhysique)
            ->setAdresse($adresse)
            ->setDroitOpposition($droitOpposition)
            ->setNomPrenom($nomPrenom);
    }
    /**
     * Get PersonneMorale value
     * @return \StructType\PersonneMorale
     */
    public function getPersonneMorale()
    {
        return isset($this->PersonneMorale) ? $this->PersonneMorale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonneMorale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonneMorale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'NomPrenom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonneMorale can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonneMorale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonneMorale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonneMorale $personneMorale
     * @return \StructType\Locataire
     */
    public function setPersonneMorale(\StructType\PersonneMorale $personneMorale = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, NomPrenom, PersonneMorale)
        if ('' !== ($personneMoraleChoiceErrorMessage = self::validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($personneMorale))) {
            throw new \InvalidArgumentException($personneMoraleChoiceErrorMessage, __LINE__);
        }
        if (is_null($personneMorale) || (is_array($personneMorale) && empty($personneMorale))) {
            unset($this->PersonneMorale);
        } else {
            $this->PersonneMorale = $personneMorale;
        }
        return $this;
    }
    /**
     * Get PersonnePhysique value
     * @return \StructType\PersonnePhysique
     */
    public function getPersonnePhysique()
    {
        return isset($this->PersonnePhysique) ? $this->PersonnePhysique : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonnePhysique method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonnePhysique method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonnePhysique can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonnePhysique, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonnePhysique value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonnePhysique $personnePhysique
     * @return \StructType\Locataire
     */
    public function setPersonnePhysique(\StructType\PersonnePhysique $personnePhysique = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique)
        if ('' !== ($personnePhysiqueChoiceErrorMessage = self::validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($personnePhysique))) {
            throw new \InvalidArgumentException($personnePhysiqueChoiceErrorMessage, __LINE__);
        }
        if (is_null($personnePhysique) || (is_array($personnePhysique) && empty($personnePhysique))) {
            unset($this->PersonnePhysique);
        } else {
            $this->PersonnePhysique = $personnePhysique;
        }
        return $this;
    }
    /**
     * Get Adresse value
     * @return \StructType\TypeAdresse
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param \StructType\TypeAdresse $adresse
     * @return \StructType\Locataire
     */
    public function setAdresse(\StructType\TypeAdresse $adresse = null)
    {
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get DroitOpposition value
     * @return bool
     */
    public function getDroitOpposition()
    {
        return $this->DroitOpposition;
    }
    /**
     * Set DroitOpposition value
     * @param bool $droitOpposition
     * @return \StructType\Locataire
     */
    public function setDroitOpposition($droitOpposition = null)
    {
        // validation for constraint: boolean
        if (!is_null($droitOpposition) && !is_bool($droitOpposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($droitOpposition, true), gettype($droitOpposition)), __LINE__);
        }
        $this->DroitOpposition = $droitOpposition;
        return $this;
    }
    /**
     * Get NomPrenom value
     * @return string
     */
    public function getNomPrenom()
    {
        return isset($this->NomPrenom) ? $this->NomPrenom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNomPrenom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNomPrenom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNomPrenomForChoiceConstraintsFromSetNomPrenom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NomPrenom can\'t be set as the property %s is already set. Only one property must be set among these properties: NomPrenom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NomPrenom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nomPrenom
     * @return \StructType\Locataire
     */
    public function setNomPrenom($nomPrenom = null)
    {
        // validation for constraint: string
        if (!is_null($nomPrenom) && !is_string($nomPrenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomPrenom, true), gettype($nomPrenom)), __LINE__);
        }
        // validation for constraint: choice(NomPrenom, PersonneMorale)
        if ('' !== ($nomPrenomChoiceErrorMessage = self::validateNomPrenomForChoiceConstraintsFromSetNomPrenom($nomPrenom))) {
            throw new \InvalidArgumentException($nomPrenomChoiceErrorMessage, __LINE__);
        }
        if (is_null($nomPrenom) || (is_array($nomPrenom) && empty($nomPrenom))) {
            unset($this->NomPrenom);
        } else {
            $this->NomPrenom = $nomPrenom;
        }
        return $this;
    }
}
