<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archiver ServiceType
 * @subpackage Services
 */
class Archiver extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Archiver
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Archiver_Req $archiverRepMsg
     * @return \StructType\Archiver_Rep|bool
     */
    public function Archiver(\StructType\Archiver_Req $archiverRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Archiver($archiverRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Archiver_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
