<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeDAD StructType
 * @subpackage Structs
 */
class TypeDAD extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: DAD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateAchat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateAchat;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The CertifDest
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CertifDest;
    /**
     * The Titulaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Titulaire
     */
    public $Titulaire;
    /**
     * The Acquereur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Acquereur
     */
    public $Acquereur;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeDAD
     * @uses TypeDAD::setID()
     * @uses TypeDAD::setTypeDemarche()
     * @uses TypeDAD::setDateAchat()
     * @uses TypeDAD::setDateDemarche()
     * @uses TypeDAD::setCertifDest()
     * @uses TypeDAD::setTitulaire()
     * @uses TypeDAD::setAcquereur()
     * @uses TypeDAD::setVehicule()
     * @uses TypeDAD::setReponse()
     * @param int $iD
     * @param string $typeDemarche
     * @param string $dateAchat
     * @param string $dateDemarche
     * @param bool $certifDest
     * @param \StructType\Titulaire $titulaire
     * @param \StructType\Acquereur $acquereur
     * @param \StructType\Vehicule $vehicule
     * @param \StructType\Reponse $reponse
     */
    public function __construct($iD = null, $typeDemarche = null, $dateAchat = null, $dateDemarche = null, $certifDest = null, \StructType\Titulaire $titulaire = null, \StructType\Acquereur $acquereur = null, \StructType\Vehicule $vehicule = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setID($iD)
            ->setTypeDemarche($typeDemarche)
            ->setDateAchat($dateAchat)
            ->setDateDemarche($dateDemarche)
            ->setCertifDest($certifDest)
            ->setTitulaire($titulaire)
            ->setAcquereur($acquereur)
            ->setVehicule($vehicule)
            ->setReponse($reponse);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeDAD
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeDAD
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateAchat value
     * @return string
     */
    public function getDateAchat()
    {
        return $this->DateAchat;
    }
    /**
     * Set DateAchat value
     * @param string $dateAchat
     * @return \StructType\TypeDAD
     */
    public function setDateAchat($dateAchat = null)
    {
        // validation for constraint: string
        if (!is_null($dateAchat) && !is_string($dateAchat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateAchat, true), gettype($dateAchat)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateAchat) && mb_strlen($dateAchat) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateAchat)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateAchat) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateAchat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateAchat, true)), __LINE__);
        }
        $this->DateAchat = $dateAchat;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypeDAD
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get CertifDest value
     * @return bool
     */
    public function getCertifDest()
    {
        return $this->CertifDest;
    }
    /**
     * Set CertifDest value
     * @param bool $certifDest
     * @return \StructType\TypeDAD
     */
    public function setCertifDest($certifDest = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifDest) && !is_bool($certifDest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifDest, true), gettype($certifDest)), __LINE__);
        }
        $this->CertifDest = $certifDest;
        return $this;
    }
    /**
     * Get Titulaire value
     * @return \StructType\Titulaire
     */
    public function getTitulaire()
    {
        return $this->Titulaire;
    }
    /**
     * Set Titulaire value
     * @param \StructType\Titulaire $titulaire
     * @return \StructType\TypeDAD
     */
    public function setTitulaire(\StructType\Titulaire $titulaire = null)
    {
        $this->Titulaire = $titulaire;
        return $this;
    }
    /**
     * Get Acquereur value
     * @return \StructType\Acquereur
     */
    public function getAcquereur()
    {
        return $this->Acquereur;
    }
    /**
     * Set Acquereur value
     * @param \StructType\Acquereur $acquereur
     * @return \StructType\TypeDAD
     */
    public function setAcquereur(\StructType\Acquereur $acquereur = null)
    {
        $this->Acquereur = $acquereur;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeDAD
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeDAD
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
}
