<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RechercherArchive_Req StructType
 * @subpackage Structs
 */
class RechercherArchive_Req extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - choice: Immatriculation | Titulaire | TypeDemarche | TypeDocument | DateCreation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Immatriculation;
    /**
     * The Titulaire
     * Meta information extracted from the WSDL
     * - choice: Immatriculation | Titulaire | TypeDemarche | TypeDocument | DateCreation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Titulaire;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - choice: Immatriculation | Titulaire | TypeDemarche | TypeDocument | DateCreation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDemarche;
    /**
     * The TypeDocument
     * Meta information extracted from the WSDL
     * - choice: Immatriculation | Titulaire | TypeDemarche | TypeDocument | DateCreation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeDocument;
    /**
     * The DateCreation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: Immatriculation | Titulaire | TypeDemarche | TypeDocument | DateCreation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCreation;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for RechercherArchive_Req
     * @uses RechercherArchive_Req::setIdentification()
     * @uses RechercherArchive_Req::setImmatriculation()
     * @uses RechercherArchive_Req::setTitulaire()
     * @uses RechercherArchive_Req::setTypeDemarche()
     * @uses RechercherArchive_Req::setTypeDocument()
     * @uses RechercherArchive_Req::setDateCreation()
     * @uses RechercherArchive_Req::setOrigine()
     * @param \StructType\TypeIdentification $identification
     * @param string $immatriculation
     * @param string $titulaire
     * @param string $typeDemarche
     * @param string $typeDocument
     * @param string $dateCreation
     * @param string $origine
     */
    public function __construct(\StructType\TypeIdentification $identification = null, $immatriculation = null, $titulaire = null, $typeDemarche = null, $typeDocument = null, $dateCreation = null, $origine = null)
    {
        $this
            ->setIdentification($identification)
            ->setImmatriculation($immatriculation)
            ->setTitulaire($titulaire)
            ->setTypeDemarche($typeDemarche)
            ->setTypeDocument($typeDocument)
            ->setDateCreation($dateCreation)
            ->setOrigine($origine);
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\RechercherArchive_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string|null
     */
    public function getImmatriculation()
    {
        return isset($this->Immatriculation) ? $this->Immatriculation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImmatriculation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImmatriculation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImmatriculationForChoiceConstraintsFromSetImmatriculation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Titulaire',
            'TypeDemarche',
            'TypeDocument',
            'DateCreation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Immatriculation can\'t be set as the property %s is already set. Only one property must be set among these properties: Immatriculation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Immatriculation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $immatriculation
     * @return \StructType\RechercherArchive_Req
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: choice(Immatriculation, Titulaire, TypeDemarche, TypeDocument, DateCreation)
        if ('' !== ($immatriculationChoiceErrorMessage = self::validateImmatriculationForChoiceConstraintsFromSetImmatriculation($immatriculation))) {
            throw new \InvalidArgumentException($immatriculationChoiceErrorMessage, __LINE__);
        }
        if (is_null($immatriculation) || (is_array($immatriculation) && empty($immatriculation))) {
            unset($this->Immatriculation);
        } else {
            $this->Immatriculation = $immatriculation;
        }
        return $this;
    }
    /**
     * Get Titulaire value
     * @return string|null
     */
    public function getTitulaire()
    {
        return isset($this->Titulaire) ? $this->Titulaire : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTitulaire method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitulaire method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTitulaireForChoiceConstraintsFromSetTitulaire($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Immatriculation',
            'TypeDemarche',
            'TypeDocument',
            'DateCreation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Titulaire can\'t be set as the property %s is already set. Only one property must be set among these properties: Titulaire, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Titulaire value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $titulaire
     * @return \StructType\RechercherArchive_Req
     */
    public function setTitulaire($titulaire = null)
    {
        // validation for constraint: string
        if (!is_null($titulaire) && !is_string($titulaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titulaire, true), gettype($titulaire)), __LINE__);
        }
        // validation for constraint: choice(Immatriculation, Titulaire, TypeDemarche, TypeDocument, DateCreation)
        if ('' !== ($titulaireChoiceErrorMessage = self::validateTitulaireForChoiceConstraintsFromSetTitulaire($titulaire))) {
            throw new \InvalidArgumentException($titulaireChoiceErrorMessage, __LINE__);
        }
        if (is_null($titulaire) || (is_array($titulaire) && empty($titulaire))) {
            unset($this->Titulaire);
        } else {
            $this->Titulaire = $titulaire;
        }
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string|null
     */
    public function getTypeDemarche()
    {
        return isset($this->TypeDemarche) ? $this->TypeDemarche : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTypeDemarche method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeDemarche method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTypeDemarcheForChoiceConstraintsFromSetTypeDemarche($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Immatriculation',
            'Titulaire',
            'TypeDocument',
            'DateCreation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TypeDemarche can\'t be set as the property %s is already set. Only one property must be set among these properties: TypeDemarche, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TypeDemarche value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $typeDemarche
     * @return \StructType\RechercherArchive_Req
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        // validation for constraint: choice(Immatriculation, Titulaire, TypeDemarche, TypeDocument, DateCreation)
        if ('' !== ($typeDemarcheChoiceErrorMessage = self::validateTypeDemarcheForChoiceConstraintsFromSetTypeDemarche($typeDemarche))) {
            throw new \InvalidArgumentException($typeDemarcheChoiceErrorMessage, __LINE__);
        }
        if (is_null($typeDemarche) || (is_array($typeDemarche) && empty($typeDemarche))) {
            unset($this->TypeDemarche);
        } else {
            $this->TypeDemarche = $typeDemarche;
        }
        return $this;
    }
    /**
     * Get TypeDocument value
     * @return string|null
     */
    public function getTypeDocument()
    {
        return isset($this->TypeDocument) ? $this->TypeDocument : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTypeDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeDocument method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTypeDocumentForChoiceConstraintsFromSetTypeDocument($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Immatriculation',
            'Titulaire',
            'TypeDemarche',
            'DateCreation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TypeDocument can\'t be set as the property %s is already set. Only one property must be set among these properties: TypeDocument, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TypeDocument value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $typeDocument
     * @return \StructType\RechercherArchive_Req
     */
    public function setTypeDocument($typeDocument = null)
    {
        // validation for constraint: string
        if (!is_null($typeDocument) && !is_string($typeDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDocument, true), gettype($typeDocument)), __LINE__);
        }
        // validation for constraint: choice(Immatriculation, Titulaire, TypeDemarche, TypeDocument, DateCreation)
        if ('' !== ($typeDocumentChoiceErrorMessage = self::validateTypeDocumentForChoiceConstraintsFromSetTypeDocument($typeDocument))) {
            throw new \InvalidArgumentException($typeDocumentChoiceErrorMessage, __LINE__);
        }
        if (is_null($typeDocument) || (is_array($typeDocument) && empty($typeDocument))) {
            unset($this->TypeDocument);
        } else {
            $this->TypeDocument = $typeDocument;
        }
        return $this;
    }
    /**
     * Get DateCreation value
     * @return string|null
     */
    public function getDateCreation()
    {
        return isset($this->DateCreation) ? $this->DateCreation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateCreation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateCreation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateCreationForChoiceConstraintsFromSetDateCreation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Immatriculation',
            'Titulaire',
            'TypeDemarche',
            'TypeDocument',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateCreation can\'t be set as the property %s is already set. Only one property must be set among these properties: DateCreation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateCreation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dateCreation
     * @return \StructType\RechercherArchive_Req
     */
    public function setDateCreation($dateCreation = null)
    {
        // validation for constraint: string
        if (!is_null($dateCreation) && !is_string($dateCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCreation, true), gettype($dateCreation)), __LINE__);
        }
        // validation for constraint: choice(Immatriculation, Titulaire, TypeDemarche, TypeDocument, DateCreation)
        if ('' !== ($dateCreationChoiceErrorMessage = self::validateDateCreationForChoiceConstraintsFromSetDateCreation($dateCreation))) {
            throw new \InvalidArgumentException($dateCreationChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCreation) && mb_strlen($dateCreation) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCreation)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCreation) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCreation, true)), __LINE__);
        }
        if (is_null($dateCreation) || (is_array($dateCreation) && empty($dateCreation))) {
            unset($this->DateCreation);
        } else {
            $this->DateCreation = $dateCreation;
        }
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\RechercherArchive_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
}
