<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Loueur StructType
 * @subpackage Structs
 */
class Loueur extends AbstractStructBase
{
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RaisonSociale;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $Adresse;
    /**
     * The SIREN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 14
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{14}
     * @var string
     */
    public $SIREN;
    /**
     * The SIRET
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 9
     * - minOccurs: 0
     * - pattern: [0-9]{9,14}
     * @var string
     */
    public $SIRET;
    /**
     * Constructor method for Loueur
     * @uses Loueur::setRaisonSociale()
     * @uses Loueur::setAdresse()
     * @uses Loueur::setSIREN()
     * @uses Loueur::setSIRET()
     * @param string $raisonSociale
     * @param \StructType\TypeAdresse $adresse
     * @param string $sIREN
     * @param string $sIRET
     */
    public function __construct($raisonSociale = null, \StructType\TypeAdresse $adresse = null, $sIREN = null, $sIRET = null)
    {
        $this
            ->setRaisonSociale($raisonSociale)
            ->setAdresse($adresse)
            ->setSIREN($sIREN)
            ->setSIRET($sIRET);
    }
    /**
     * Get RaisonSociale value
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->RaisonSociale;
    }
    /**
     * Set RaisonSociale value
     * @param string $raisonSociale
     * @return \StructType\Loueur
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        $this->RaisonSociale = $raisonSociale;
        return $this;
    }
    /**
     * Get Adresse value
     * @return \StructType\TypeAdresse
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param \StructType\TypeAdresse $adresse
     * @return \StructType\Loueur
     */
    public function setAdresse(\StructType\TypeAdresse $adresse = null)
    {
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get SIREN value
     * @return string|null
     */
    public function getSIREN()
    {
        return $this->SIREN;
    }
    /**
     * Set SIREN value
     * @param string $sIREN
     * @return \StructType\Loueur
     */
    public function setSIREN($sIREN = null)
    {
        // validation for constraint: string
        if (!is_null($sIREN) && !is_string($sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIREN, true), gettype($sIREN)), __LINE__);
        }
        // validation for constraint: length(14)
        if (!is_null($sIREN) && mb_strlen($sIREN) !== 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 14', mb_strlen($sIREN)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{14})
        if (!is_null($sIREN) && !preg_match('/[0-9]{14}/', $sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{14}', var_export($sIREN, true)), __LINE__);
        }
        $this->SIREN = $sIREN;
        return $this;
    }
    /**
     * Get SIRET value
     * @return string|null
     */
    public function getSIRET()
    {
        return $this->SIRET;
    }
    /**
     * Set SIRET value
     * @param string $sIRET
     * @return \StructType\Loueur
     */
    public function setSIRET($sIRET = null)
    {
        // validation for constraint: string
        if (!is_null($sIRET) && !is_string($sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIRET, true), gettype($sIRET)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($sIRET) && mb_strlen($sIRET) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: minLength(9)
        if (!is_null($sIRET) && mb_strlen($sIRET) < 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 9', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9,14})
        if (!is_null($sIRET) && !preg_match('/[0-9]{9,14}/', $sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9,14}', var_export($sIRET, true)), __LINE__);
        }
        $this->SIRET = $sIRET;
        return $this;
    }
}
