<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Acquereur StructType
 * @subpackage Structs
 */
class Acquereur extends AbstractStructBase
{
    /**
     * The PersonneMorale
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale |
     * PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonneMorale
     */
    public $PersonneMorale;
    /**
     * The PersonnePhysique
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale |
     * PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique | PersonneMorale | PersonnePhysique
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonnePhysique
     */
    public $PersonnePhysique;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeAdresse
     */
    public $Adresse;
    /**
     * The DroitOpposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DroitOpposition;
    /**
     * The AgrementVHU
     * Meta information extracted from the WSDL
     * - choice: AgrementVHU
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AgrementVHU;
    /**
     * The AdresseMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdresseMail;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * Constructor method for Acquereur
     * @uses Acquereur::setPersonneMorale()
     * @uses Acquereur::setPersonnePhysique()
     * @uses Acquereur::setAdresse()
     * @uses Acquereur::setDroitOpposition()
     * @uses Acquereur::setAgrementVHU()
     * @uses Acquereur::setAdresseMail()
     * @uses Acquereur::setTelephone()
     * @param \StructType\PersonneMorale $personneMorale
     * @param \StructType\PersonnePhysique $personnePhysique
     * @param \StructType\TypeAdresse $adresse
     * @param bool $droitOpposition
     * @param string $agrementVHU
     * @param string $adresseMail
     * @param string $telephone
     */
    public function __construct(\StructType\PersonneMorale $personneMorale = null, \StructType\PersonnePhysique $personnePhysique = null, \StructType\TypeAdresse $adresse = null, $droitOpposition = null, $agrementVHU = null, $adresseMail = null, $telephone = null)
    {
        $this
            ->setPersonneMorale($personneMorale)
            ->setPersonnePhysique($personnePhysique)
            ->setAdresse($adresse)
            ->setDroitOpposition($droitOpposition)
            ->setAgrementVHU($agrementVHU)
            ->setAdresseMail($adresseMail)
            ->setTelephone($telephone);
    }
    /**
     * Get PersonneMorale value
     * @return \StructType\PersonneMorale
     */
    public function getPersonneMorale()
    {
        return isset($this->PersonneMorale) ? $this->PersonneMorale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonneMorale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonneMorale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
            'PersonnePhysique',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonneMorale can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonneMorale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonneMorale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonneMorale $personneMorale
     * @return \StructType\Acquereur
     */
    public function setPersonneMorale(\StructType\PersonneMorale $personneMorale = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique)
        if ('' !== ($personneMoraleChoiceErrorMessage = self::validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($personneMorale))) {
            throw new \InvalidArgumentException($personneMoraleChoiceErrorMessage, __LINE__);
        }
        if (is_null($personneMorale) || (is_array($personneMorale) && empty($personneMorale))) {
            unset($this->PersonneMorale);
        } else {
            $this->PersonneMorale = $personneMorale;
        }
        return $this;
    }
    /**
     * Get PersonnePhysique value
     * @return \StructType\PersonnePhysique
     */
    public function getPersonnePhysique()
    {
        return isset($this->PersonnePhysique) ? $this->PersonnePhysique : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonnePhysique method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonnePhysique method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonnePhysique can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonnePhysique, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonnePhysique value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonnePhysique $personnePhysique
     * @return \StructType\Acquereur
     */
    public function setPersonnePhysique(\StructType\PersonnePhysique $personnePhysique = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique, PersonneMorale, PersonnePhysique)
        if ('' !== ($personnePhysiqueChoiceErrorMessage = self::validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($personnePhysique))) {
            throw new \InvalidArgumentException($personnePhysiqueChoiceErrorMessage, __LINE__);
        }
        if (is_null($personnePhysique) || (is_array($personnePhysique) && empty($personnePhysique))) {
            unset($this->PersonnePhysique);
        } else {
            $this->PersonnePhysique = $personnePhysique;
        }
        return $this;
    }
    /**
     * Get Adresse value
     * @return \StructType\TypeAdresse
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param \StructType\TypeAdresse $adresse
     * @return \StructType\Acquereur
     */
    public function setAdresse(\StructType\TypeAdresse $adresse = null)
    {
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get DroitOpposition value
     * @return bool
     */
    public function getDroitOpposition()
    {
        return $this->DroitOpposition;
    }
    /**
     * Set DroitOpposition value
     * @param bool $droitOpposition
     * @return \StructType\Acquereur
     */
    public function setDroitOpposition($droitOpposition = null)
    {
        // validation for constraint: boolean
        if (!is_null($droitOpposition) && !is_bool($droitOpposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($droitOpposition, true), gettype($droitOpposition)), __LINE__);
        }
        $this->DroitOpposition = $droitOpposition;
        return $this;
    }
    /**
     * Get AgrementVHU value
     * @return string
     */
    public function getAgrementVHU()
    {
        return isset($this->AgrementVHU) ? $this->AgrementVHU : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAgrementVHU method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgrementVHU method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAgrementVHUForChoiceConstraintsFromSetAgrementVHU($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AgrementVHU can\'t be set as the property %s is already set. Only one property must be set among these properties: AgrementVHU, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AgrementVHU value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $agrementVHU
     * @return \StructType\Acquereur
     */
    public function setAgrementVHU($agrementVHU = null)
    {
        // validation for constraint: string
        if (!is_null($agrementVHU) && !is_string($agrementVHU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agrementVHU, true), gettype($agrementVHU)), __LINE__);
        }
        // validation for constraint: choice(AgrementVHU)
        if ('' !== ($agrementVHUChoiceErrorMessage = self::validateAgrementVHUForChoiceConstraintsFromSetAgrementVHU($agrementVHU))) {
            throw new \InvalidArgumentException($agrementVHUChoiceErrorMessage, __LINE__);
        }
        if (is_null($agrementVHU) || (is_array($agrementVHU) && empty($agrementVHU))) {
            unset($this->AgrementVHU);
        } else {
            $this->AgrementVHU = $agrementVHU;
        }
        return $this;
    }
    /**
     * Get AdresseMail value
     * @return string|null
     */
    public function getAdresseMail()
    {
        return $this->AdresseMail;
    }
    /**
     * Set AdresseMail value
     * @param string $adresseMail
     * @return \StructType\Acquereur
     */
    public function setAdresseMail($adresseMail = null)
    {
        // validation for constraint: string
        if (!is_null($adresseMail) && !is_string($adresseMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresseMail, true), gettype($adresseMail)), __LINE__);
        }
        $this->AdresseMail = $adresseMail;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\Acquereur
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
}
