<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LireArchive_Rep StructType
 * @subpackage Structs
 */
class LireArchive_Rep extends AbstractStructBase
{
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - choice: FichierArchive | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The FichierArchive
     * Meta information extracted from the WSDL
     * - choice: FichierArchive | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FichierArchive[]
     */
    public $FichierArchive;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - choice: FichierArchive | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * Constructor method for LireArchive_Rep
     * @uses LireArchive_Rep::setErreur()
     * @uses LireArchive_Rep::setFichierArchive()
     * @uses LireArchive_Rep::setCode()
     * @param string $erreur
     * @param \StructType\FichierArchive[] $fichierArchive
     * @param int $code
     */
    public function __construct($erreur = null, array $fichierArchive = array(), $code = null)
    {
        $this
            ->setErreur($erreur)
            ->setFichierArchive($fichierArchive)
            ->setCode($code);
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return isset($this->Erreur) ? $this->Erreur : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErreur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreur method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErreurForChoiceConstraintsFromSetErreur($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FichierArchive',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Erreur can\'t be set as the property %s is already set. Only one property must be set among these properties: Erreur, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Erreur value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $erreur
     * @return \StructType\LireArchive_Rep
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        // validation for constraint: choice(FichierArchive, Erreur, Code)
        if ('' !== ($erreurChoiceErrorMessage = self::validateErreurForChoiceConstraintsFromSetErreur($erreur))) {
            throw new \InvalidArgumentException($erreurChoiceErrorMessage, __LINE__);
        }
        if (is_null($erreur) || (is_array($erreur) && empty($erreur))) {
            unset($this->Erreur);
        } else {
            $this->Erreur = $erreur;
        }
        return $this;
    }
    /**
     * Get FichierArchive value
     * @return \StructType\FichierArchive[]|null
     */
    public function getFichierArchive()
    {
        return isset($this->FichierArchive) ? $this->FichierArchive : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFichierArchive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFichierArchive method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFichierArchiveForArrayConstraintsFromSetFichierArchive(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $lireArchive_RepFichierArchiveItem) {
            // validation for constraint: itemType
            if (!$lireArchive_RepFichierArchiveItem instanceof \StructType\FichierArchive) {
                $invalidValues[] = is_object($lireArchive_RepFichierArchiveItem) ? get_class($lireArchive_RepFichierArchiveItem) : sprintf('%s(%s)', gettype($lireArchive_RepFichierArchiveItem), var_export($lireArchive_RepFichierArchiveItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FichierArchive property can only contain items of type \StructType\FichierArchive, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setFichierArchive method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFichierArchive method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFichierArchiveForChoiceConstraintsFromSetFichierArchive($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FichierArchive can\'t be set as the property %s is already set. Only one property must be set among these properties: FichierArchive, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set FichierArchive value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\FichierArchive[] $fichierArchive
     * @return \StructType\LireArchive_Rep
     */
    public function setFichierArchive(array $fichierArchive = array())
    {
        // validation for constraint: array
        if ('' !== ($fichierArchiveArrayErrorMessage = self::validateFichierArchiveForArrayConstraintsFromSetFichierArchive($fichierArchive))) {
            throw new \InvalidArgumentException($fichierArchiveArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(FichierArchive, Erreur, Code)
        if ('' !== ($fichierArchiveChoiceErrorMessage = self::validateFichierArchiveForChoiceConstraintsFromSetFichierArchive($fichierArchive))) {
            throw new \InvalidArgumentException($fichierArchiveChoiceErrorMessage, __LINE__);
        }
        if (is_null($fichierArchive) || (is_array($fichierArchive) && empty($fichierArchive))) {
            unset($this->FichierArchive);
        } else {
            $this->FichierArchive = $fichierArchive;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToFichierArchive method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToFichierArchive method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToFichierArchive($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property FichierArchive can\'t be set as the property %s is already set. Only one property must be set among these properties: FichierArchive, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to FichierArchive value
     * @throws \InvalidArgumentException
     * @param \StructType\FichierArchive $item
     * @return \StructType\LireArchive_Rep
     */
    public function addToFichierArchive(\StructType\FichierArchive $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FichierArchive) {
            throw new \InvalidArgumentException(sprintf('The FichierArchive property can only contain items of type \StructType\FichierArchive, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(FichierArchive, Erreur, Code)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToFichierArchive($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->FichierArchive[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'FichierArchive',
            'Erreur',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Code can\'t be set as the property %s is already set. Only one property must be set among these properties: Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $code
     * @return \StructType\LireArchive_Rep
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: choice(FichierArchive, Erreur, Code)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
}
