<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Editer ServiceType
 * @subpackage Services
 */
class Editer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Editer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Editer_Req $editerRepMsg
     * @return \StructType\Editer_Rep|bool
     */
    public function Editer(\StructType\Editer_Req $editerRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Editer($editerRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Editer_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
