<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mention StructType
 * @subpackage Structs
 */
class Mention extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Code;
    /**
     * The Valeur1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Valeur1;
    /**
     * The Valeur2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Valeur2;
    /**
     * Constructor method for Mention
     * @uses Mention::setCode()
     * @uses Mention::setValeur1()
     * @uses Mention::setValeur2()
     * @param string $code
     * @param string $valeur1
     * @param string $valeur2
     */
    public function __construct($code = null, $valeur1 = null, $valeur2 = null)
    {
        $this
            ->setCode($code)
            ->setValeur1($valeur1)
            ->setValeur2($valeur2);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Mention
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($code) && mb_strlen($code) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Valeur1 value
     * @return string|null
     */
    public function getValeur1()
    {
        return $this->Valeur1;
    }
    /**
     * Set Valeur1 value
     * @param string $valeur1
     * @return \StructType\Mention
     */
    public function setValeur1($valeur1 = null)
    {
        // validation for constraint: string
        if (!is_null($valeur1) && !is_string($valeur1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valeur1, true), gettype($valeur1)), __LINE__);
        }
        $this->Valeur1 = $valeur1;
        return $this;
    }
    /**
     * Get Valeur2 value
     * @return string|null
     */
    public function getValeur2()
    {
        return $this->Valeur2;
    }
    /**
     * Set Valeur2 value
     * @param string $valeur2
     * @return \StructType\Mention
     */
    public function setValeur2($valeur2 = null)
    {
        // validation for constraint: string
        if (!is_null($valeur2) && !is_string($valeur2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valeur2, true), gettype($valeur2)), __LINE__);
        }
        $this->Valeur2 = $valeur2;
        return $this;
    }
}
