<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonnePhysique StructType
 * @subpackage Structs
 */
class PersonnePhysique extends AbstractStructBase
{
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nom;
    /**
     * The Prenom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Prenom;
    /**
     * The Sexe
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Sexe;
    /**
     * The DateNaissance
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateNaissance;
    /**
     * The LieuNaissance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LieuNaissance;
    /**
     * The DepNaissance
     * Meta information extracted from the WSDL
     * - choice: DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance |
     * PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DepNaissance;
    /**
     * The PaysNaissance
     * Meta information extracted from the WSDL
     * - choice: DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance |
     * PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance | DepNaissance | PaysNaissance
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaysNaissance;
    /**
     * The NomPrenom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomPrenom;
    /**
     * The NomNaissance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomNaissance;
    /**
     * The DroitOpposition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DroitOpposition;
    /**
     * The NomUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NomUsage;
    /**
     * Constructor method for PersonnePhysique
     * @uses PersonnePhysique::setNom()
     * @uses PersonnePhysique::setPrenom()
     * @uses PersonnePhysique::setSexe()
     * @uses PersonnePhysique::setDateNaissance()
     * @uses PersonnePhysique::setLieuNaissance()
     * @uses PersonnePhysique::setDepNaissance()
     * @uses PersonnePhysique::setPaysNaissance()
     * @uses PersonnePhysique::setNomPrenom()
     * @uses PersonnePhysique::setNomNaissance()
     * @uses PersonnePhysique::setDroitOpposition()
     * @uses PersonnePhysique::setNomUsage()
     * @param string $nom
     * @param string $prenom
     * @param string $sexe
     * @param string $dateNaissance
     * @param string $lieuNaissance
     * @param string $depNaissance
     * @param string $paysNaissance
     * @param string $nomPrenom
     * @param string $nomNaissance
     * @param bool $droitOpposition
     * @param string $nomUsage
     */
    public function __construct($nom = null, $prenom = null, $sexe = null, $dateNaissance = null, $lieuNaissance = null, $depNaissance = null, $paysNaissance = null, $nomPrenom = null, $nomNaissance = null, $droitOpposition = null, $nomUsage = null)
    {
        $this
            ->setNom($nom)
            ->setPrenom($prenom)
            ->setSexe($sexe)
            ->setDateNaissance($dateNaissance)
            ->setLieuNaissance($lieuNaissance)
            ->setDepNaissance($depNaissance)
            ->setPaysNaissance($paysNaissance)
            ->setNomPrenom($nomPrenom)
            ->setNomNaissance($nomNaissance)
            ->setDroitOpposition($droitOpposition)
            ->setNomUsage($nomUsage);
    }
    /**
     * Get Nom value
     * @return string
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \StructType\PersonnePhysique
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get Prenom value
     * @return string
     */
    public function getPrenom()
    {
        return $this->Prenom;
    }
    /**
     * Set Prenom value
     * @param string $prenom
     * @return \StructType\PersonnePhysique
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prenom, true), gettype($prenom)), __LINE__);
        }
        $this->Prenom = $prenom;
        return $this;
    }
    /**
     * Get Sexe value
     * @return string
     */
    public function getSexe()
    {
        return $this->Sexe;
    }
    /**
     * Set Sexe value
     * @uses \EnumType\Sexe::valueIsValid()
     * @uses \EnumType\Sexe::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sexe
     * @return \StructType\PersonnePhysique
     */
    public function setSexe($sexe = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Sexe::valueIsValid($sexe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Sexe', is_array($sexe) ? implode(', ', $sexe) : var_export($sexe, true), implode(', ', \EnumType\Sexe::getValidValues())), __LINE__);
        }
        $this->Sexe = $sexe;
        return $this;
    }
    /**
     * Get DateNaissance value
     * @return string
     */
    public function getDateNaissance()
    {
        return $this->DateNaissance;
    }
    /**
     * Set DateNaissance value
     * @param string $dateNaissance
     * @return \StructType\PersonnePhysique
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateNaissance, true), gettype($dateNaissance)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateNaissance) && mb_strlen($dateNaissance) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateNaissance)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateNaissance) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateNaissance, true)), __LINE__);
        }
        $this->DateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get LieuNaissance value
     * @return string
     */
    public function getLieuNaissance()
    {
        return $this->LieuNaissance;
    }
    /**
     * Set LieuNaissance value
     * @param string $lieuNaissance
     * @return \StructType\PersonnePhysique
     */
    public function setLieuNaissance($lieuNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($lieuNaissance) && !is_string($lieuNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lieuNaissance, true), gettype($lieuNaissance)), __LINE__);
        }
        $this->LieuNaissance = $lieuNaissance;
        return $this;
    }
    /**
     * Get DepNaissance value
     * @return string
     */
    public function getDepNaissance()
    {
        return isset($this->DepNaissance) ? $this->DepNaissance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDepNaissance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepNaissance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDepNaissanceForChoiceConstraintsFromSetDepNaissance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
            'PaysNaissance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DepNaissance can\'t be set as the property %s is already set. Only one property must be set among these properties: DepNaissance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DepNaissance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $depNaissance
     * @return \StructType\PersonnePhysique
     */
    public function setDepNaissance($depNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($depNaissance) && !is_string($depNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depNaissance, true), gettype($depNaissance)), __LINE__);
        }
        // validation for constraint: choice(DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance)
        if ('' !== ($depNaissanceChoiceErrorMessage = self::validateDepNaissanceForChoiceConstraintsFromSetDepNaissance($depNaissance))) {
            throw new \InvalidArgumentException($depNaissanceChoiceErrorMessage, __LINE__);
        }
        if (is_null($depNaissance) || (is_array($depNaissance) && empty($depNaissance))) {
            unset($this->DepNaissance);
        } else {
            $this->DepNaissance = $depNaissance;
        }
        return $this;
    }
    /**
     * Get PaysNaissance value
     * @return string
     */
    public function getPaysNaissance()
    {
        return isset($this->PaysNaissance) ? $this->PaysNaissance : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPaysNaissance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaysNaissance method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePaysNaissanceForChoiceConstraintsFromSetPaysNaissance($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
            'DepNaissance',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PaysNaissance can\'t be set as the property %s is already set. Only one property must be set among these properties: PaysNaissance, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PaysNaissance value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $paysNaissance
     * @return \StructType\PersonnePhysique
     */
    public function setPaysNaissance($paysNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($paysNaissance) && !is_string($paysNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paysNaissance, true), gettype($paysNaissance)), __LINE__);
        }
        // validation for constraint: choice(DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance, DepNaissance, PaysNaissance)
        if ('' !== ($paysNaissanceChoiceErrorMessage = self::validatePaysNaissanceForChoiceConstraintsFromSetPaysNaissance($paysNaissance))) {
            throw new \InvalidArgumentException($paysNaissanceChoiceErrorMessage, __LINE__);
        }
        if (is_null($paysNaissance) || (is_array($paysNaissance) && empty($paysNaissance))) {
            unset($this->PaysNaissance);
        } else {
            $this->PaysNaissance = $paysNaissance;
        }
        return $this;
    }
    /**
     * Get NomPrenom value
     * @return string
     */
    public function getNomPrenom()
    {
        return $this->NomPrenom;
    }
    /**
     * Set NomPrenom value
     * @param string $nomPrenom
     * @return \StructType\PersonnePhysique
     */
    public function setNomPrenom($nomPrenom = null)
    {
        // validation for constraint: string
        if (!is_null($nomPrenom) && !is_string($nomPrenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomPrenom, true), gettype($nomPrenom)), __LINE__);
        }
        $this->NomPrenom = $nomPrenom;
        return $this;
    }
    /**
     * Get NomNaissance value
     * @return string
     */
    public function getNomNaissance()
    {
        return $this->NomNaissance;
    }
    /**
     * Set NomNaissance value
     * @param string $nomNaissance
     * @return \StructType\PersonnePhysique
     */
    public function setNomNaissance($nomNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($nomNaissance) && !is_string($nomNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomNaissance, true), gettype($nomNaissance)), __LINE__);
        }
        $this->NomNaissance = $nomNaissance;
        return $this;
    }
    /**
     * Get DroitOpposition value
     * @return bool
     */
    public function getDroitOpposition()
    {
        return $this->DroitOpposition;
    }
    /**
     * Set DroitOpposition value
     * @param bool $droitOpposition
     * @return \StructType\PersonnePhysique
     */
    public function setDroitOpposition($droitOpposition = null)
    {
        // validation for constraint: boolean
        if (!is_null($droitOpposition) && !is_bool($droitOpposition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($droitOpposition, true), gettype($droitOpposition)), __LINE__);
        }
        $this->DroitOpposition = $droitOpposition;
        return $this;
    }
    /**
     * Get NomUsage value
     * @return string|null
     */
    public function getNomUsage()
    {
        return $this->NomUsage;
    }
    /**
     * Set NomUsage value
     * @param string $nomUsage
     * @return \StructType\PersonnePhysique
     */
    public function setNomUsage($nomUsage = null)
    {
        // validation for constraint: string
        if (!is_null($nomUsage) && !is_string($nomUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomUsage, true), gettype($nomUsage)), __LINE__);
        }
        $this->NomUsage = $nomUsage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonnePhysique
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
