<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssistantImport_Req StructType
 * @subpackage Structs
 */
class AssistantImport_Req extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The D2_Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D2_Version;
    /**
     * The K_NumRecepCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $K_NumRecepCE;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TypeDemarche
     */
    public $TypeDemarche;
    /**
     * Constructor method for AssistantImport_Req
     * @uses AssistantImport_Req::setIdentification()
     * @uses AssistantImport_Req::setVIN()
     * @uses AssistantImport_Req::setD2_Version()
     * @uses AssistantImport_Req::setK_NumRecepCE()
     * @uses AssistantImport_Req::setTypeDemarche()
     * @param \StructType\TypeIdentification $identification
     * @param string $vIN
     * @param string $d2_Version
     * @param string $k_NumRecepCE
     * @param \StructType\TypeDemarche $typeDemarche
     */
    public function __construct(\StructType\TypeIdentification $identification = null, $vIN = null, $d2_Version = null, $k_NumRecepCE = null, \StructType\TypeDemarche $typeDemarche = null)
    {
        $this
            ->setIdentification($identification)
            ->setVIN($vIN)
            ->setD2_Version($d2_Version)
            ->setK_NumRecepCE($k_NumRecepCE)
            ->setTypeDemarche($typeDemarche);
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\AssistantImport_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\AssistantImport_Req
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get D2_Version value
     * @return string
     */
    public function getD2_Version()
    {
        return $this->D2_Version;
    }
    /**
     * Set D2_Version value
     * @param string $d2_Version
     * @return \StructType\AssistantImport_Req
     */
    public function setD2_Version($d2_Version = null)
    {
        // validation for constraint: string
        if (!is_null($d2_Version) && !is_string($d2_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d2_Version, true), gettype($d2_Version)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($d2_Version) && mb_strlen($d2_Version) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($d2_Version)), __LINE__);
        }
        $this->D2_Version = $d2_Version;
        return $this;
    }
    /**
     * Get K_NumRecepCE value
     * @return string
     */
    public function getK_NumRecepCE()
    {
        return $this->K_NumRecepCE;
    }
    /**
     * Set K_NumRecepCE value
     * @param string $k_NumRecepCE
     * @return \StructType\AssistantImport_Req
     */
    public function setK_NumRecepCE($k_NumRecepCE = null)
    {
        // validation for constraint: string
        if (!is_null($k_NumRecepCE) && !is_string($k_NumRecepCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($k_NumRecepCE, true), gettype($k_NumRecepCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($k_NumRecepCE) && mb_strlen($k_NumRecepCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($k_NumRecepCE)), __LINE__);
        }
        $this->K_NumRecepCE = $k_NumRecepCE;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return \StructType\TypeDemarche|null
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param \StructType\TypeDemarche $typeDemarche
     * @return \StructType\AssistantImport_Req
     */
    public function setTypeDemarche(\StructType\TypeDemarche $typeDemarche = null)
    {
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssistantImport_Req
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
