<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mentions StructType
 * @subpackage Structs
 */
class Mentions extends AbstractStructBase
{
    /**
     * The Mention
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mention[]
     */
    public $Mention;
    /**
     * Constructor method for Mentions
     * @uses Mentions::setMention()
     * @param \StructType\Mention[] $mention
     */
    public function __construct(array $mention = array())
    {
        $this
            ->setMention($mention);
    }
    /**
     * Get Mention value
     * @return \StructType\Mention[]|null
     */
    public function getMention()
    {
        return $this->Mention;
    }
    /**
     * This method is responsible for validating the values passed to the setMention method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMention method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMentionForArrayConstraintsFromSetMention(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mentionsMentionItem) {
            // validation for constraint: itemType
            if (!$mentionsMentionItem instanceof \StructType\Mention) {
                $invalidValues[] = is_object($mentionsMentionItem) ? get_class($mentionsMentionItem) : sprintf('%s(%s)', gettype($mentionsMentionItem), var_export($mentionsMentionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mention property can only contain items of type \StructType\Mention, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mention value
     * @throws \InvalidArgumentException
     * @param \StructType\Mention[] $mention
     * @return \StructType\Mentions
     */
    public function setMention(array $mention = array())
    {
        // validation for constraint: array
        if ('' !== ($mentionArrayErrorMessage = self::validateMentionForArrayConstraintsFromSetMention($mention))) {
            throw new \InvalidArgumentException($mentionArrayErrorMessage, __LINE__);
        }
        $this->Mention = $mention;
        return $this;
    }
    /**
     * Add item to Mention value
     * @throws \InvalidArgumentException
     * @param \StructType\Mention $item
     * @return \StructType\Mentions
     */
    public function addToMention(\StructType\Mention $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mention) {
            throw new \InvalidArgumentException(sprintf('The Mention property can only contain items of type \StructType\Mention, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mention[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mentions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
