<?php

namespace EnumType;

/**
 * This class stands for TypeDocument EnumType
 * @subpackage Enumerations
 */
class TypeDocument
{
    /**
     * Constant for value 'Mandat'
     * @return string 'Mandat'
     */
    const VALUE_MANDAT = 'Mandat';
    /**
     * Constant for value 'Cerfa'
     * @return string 'Cerfa'
     */
    const VALUE_CERFA = 'Cerfa';
    /**
     * Constant for value 'DeclarationPerteVol'
     * @return string 'DeclarationPerteVol'
     */
    const VALUE_DECLARATION_PERTE_VOL = 'DeclarationPerteVol';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MANDAT
     * @uses self::VALUE_CERFA
     * @uses self::VALUE_DECLARATION_PERTE_VOL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANDAT,
            self::VALUE_CERFA,
            self::VALUE_DECLARATION_PERTE_VOL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
