<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeDemarcheEdition StructType
 * @subpackage Structs
 */
class TypeDemarcheEdition extends AbstractStructBase
{
    /**
     * The CTVO
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeCTVO
     */
    public $CTVO;
    /**
     * The CTVLO
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeCTVLO
     */
    public $CTVLO;
    /**
     * The DA
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDA
     */
    public $DA;
    /**
     * The DC
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDC
     */
    public $DC;
    /**
     * The DCA
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDCA
     */
    public $DCA;
    /**
     * The DCAL
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDCAL
     */
    public $DCAL;
    /**
     * The DIVN
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDIVN
     */
    public $DIVN;
    /**
     * The DIVLN
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDIVLN
     */
    public $DIVLN;
    /**
     * The DUP
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDUP
     */
    public $DUP;
    /**
     * The DUPVL
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeDUPVL
     */
    public $DUPVL;
    /**
     * The PIVO
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypePIVO
     */
    public $PIVO;
    /**
     * The PIVOL
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypePIVOL
     */
    public $PIVOL;
    /**
     * The MCT
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeMCT
     */
    public $MCT;
    /**
     * The MBD
     * Meta information extracted from the WSDL
     * - choice: CTVO | CTVLO | DA | DC | DCA | DCAL | DIVN | DIVLN | DUP | DUPVL | PIVO | PIVOL | MCT | MBD
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeMBD
     */
    public $MBD;
    /**
     * Constructor method for TypeDemarcheEdition
     * @uses TypeDemarcheEdition::setCTVO()
     * @uses TypeDemarcheEdition::setCTVLO()
     * @uses TypeDemarcheEdition::setDA()
     * @uses TypeDemarcheEdition::setDC()
     * @uses TypeDemarcheEdition::setDCA()
     * @uses TypeDemarcheEdition::setDCAL()
     * @uses TypeDemarcheEdition::setDIVN()
     * @uses TypeDemarcheEdition::setDIVLN()
     * @uses TypeDemarcheEdition::setDUP()
     * @uses TypeDemarcheEdition::setDUPVL()
     * @uses TypeDemarcheEdition::setPIVO()
     * @uses TypeDemarcheEdition::setPIVOL()
     * @uses TypeDemarcheEdition::setMCT()
     * @uses TypeDemarcheEdition::setMBD()
     * @param \StructType\TypeCTVO $cTVO
     * @param \StructType\TypeCTVLO $cTVLO
     * @param \StructType\TypeDA $dA
     * @param \StructType\TypeDC $dC
     * @param \StructType\TypeDCA $dCA
     * @param \StructType\TypeDCAL $dCAL
     * @param \StructType\TypeDIVN $dIVN
     * @param \StructType\TypeDIVLN $dIVLN
     * @param \StructType\TypeDUP $dUP
     * @param \StructType\TypeDUPVL $dUPVL
     * @param \StructType\TypePIVO $pIVO
     * @param \StructType\TypePIVOL $pIVOL
     * @param \StructType\TypeMCT $mCT
     * @param \StructType\TypeMBD $mBD
     */
    public function __construct(\StructType\TypeCTVO $cTVO = null, \StructType\TypeCTVLO $cTVLO = null, \StructType\TypeDA $dA = null, \StructType\TypeDC $dC = null, \StructType\TypeDCA $dCA = null, \StructType\TypeDCAL $dCAL = null, \StructType\TypeDIVN $dIVN = null, \StructType\TypeDIVLN $dIVLN = null, \StructType\TypeDUP $dUP = null, \StructType\TypeDUPVL $dUPVL = null, \StructType\TypePIVO $pIVO = null, \StructType\TypePIVOL $pIVOL = null, \StructType\TypeMCT $mCT = null, \StructType\TypeMBD $mBD = null)
    {
        $this
            ->setCTVO($cTVO)
            ->setCTVLO($cTVLO)
            ->setDA($dA)
            ->setDC($dC)
            ->setDCA($dCA)
            ->setDCAL($dCAL)
            ->setDIVN($dIVN)
            ->setDIVLN($dIVLN)
            ->setDUP($dUP)
            ->setDUPVL($dUPVL)
            ->setPIVO($pIVO)
            ->setPIVOL($pIVOL)
            ->setMCT($mCT)
            ->setMBD($mBD);
    }
    /**
     * Get CTVO value
     * @return \StructType\TypeCTVO
     */
    public function getCTVO()
    {
        return isset($this->CTVO) ? $this->CTVO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCTVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCTVO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCTVOForChoiceConstraintsFromSetCTVO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CTVO can\'t be set as the property %s is already set. Only one property must be set among these properties: CTVO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CTVO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeCTVO $cTVO
     * @return \StructType\TypeDemarcheEdition
     */
    public function setCTVO(\StructType\TypeCTVO $cTVO = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($cTVOChoiceErrorMessage = self::validateCTVOForChoiceConstraintsFromSetCTVO($cTVO))) {
            throw new \InvalidArgumentException($cTVOChoiceErrorMessage, __LINE__);
        }
        if (is_null($cTVO) || (is_array($cTVO) && empty($cTVO))) {
            unset($this->CTVO);
        } else {
            $this->CTVO = $cTVO;
        }
        return $this;
    }
    /**
     * Get CTVLO value
     * @return \StructType\TypeCTVLO
     */
    public function getCTVLO()
    {
        return isset($this->CTVLO) ? $this->CTVLO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCTVLO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCTVLO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCTVLOForChoiceConstraintsFromSetCTVLO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CTVLO can\'t be set as the property %s is already set. Only one property must be set among these properties: CTVLO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CTVLO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeCTVLO $cTVLO
     * @return \StructType\TypeDemarcheEdition
     */
    public function setCTVLO(\StructType\TypeCTVLO $cTVLO = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($cTVLOChoiceErrorMessage = self::validateCTVLOForChoiceConstraintsFromSetCTVLO($cTVLO))) {
            throw new \InvalidArgumentException($cTVLOChoiceErrorMessage, __LINE__);
        }
        if (is_null($cTVLO) || (is_array($cTVLO) && empty($cTVLO))) {
            unset($this->CTVLO);
        } else {
            $this->CTVLO = $cTVLO;
        }
        return $this;
    }
    /**
     * Get DA value
     * @return \StructType\TypeDA
     */
    public function getDA()
    {
        return isset($this->DA) ? $this->DA : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDA method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDAForChoiceConstraintsFromSetDA($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DA can\'t be set as the property %s is already set. Only one property must be set among these properties: DA, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DA value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDA $dA
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDA(\StructType\TypeDA $dA = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dAChoiceErrorMessage = self::validateDAForChoiceConstraintsFromSetDA($dA))) {
            throw new \InvalidArgumentException($dAChoiceErrorMessage, __LINE__);
        }
        if (is_null($dA) || (is_array($dA) && empty($dA))) {
            unset($this->DA);
        } else {
            $this->DA = $dA;
        }
        return $this;
    }
    /**
     * Get DC value
     * @return \StructType\TypeDC
     */
    public function getDC()
    {
        return isset($this->DC) ? $this->DC : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDC method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDCForChoiceConstraintsFromSetDC($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DC can\'t be set as the property %s is already set. Only one property must be set among these properties: DC, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DC value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDC $dC
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDC(\StructType\TypeDC $dC = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dCChoiceErrorMessage = self::validateDCForChoiceConstraintsFromSetDC($dC))) {
            throw new \InvalidArgumentException($dCChoiceErrorMessage, __LINE__);
        }
        if (is_null($dC) || (is_array($dC) && empty($dC))) {
            unset($this->DC);
        } else {
            $this->DC = $dC;
        }
        return $this;
    }
    /**
     * Get DCA value
     * @return \StructType\TypeDCA
     */
    public function getDCA()
    {
        return isset($this->DCA) ? $this->DCA : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDCA method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDCA method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDCAForChoiceConstraintsFromSetDCA($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DCA can\'t be set as the property %s is already set. Only one property must be set among these properties: DCA, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DCA value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDCA $dCA
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDCA(\StructType\TypeDCA $dCA = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dCAChoiceErrorMessage = self::validateDCAForChoiceConstraintsFromSetDCA($dCA))) {
            throw new \InvalidArgumentException($dCAChoiceErrorMessage, __LINE__);
        }
        if (is_null($dCA) || (is_array($dCA) && empty($dCA))) {
            unset($this->DCA);
        } else {
            $this->DCA = $dCA;
        }
        return $this;
    }
    /**
     * Get DCAL value
     * @return \StructType\TypeDCAL
     */
    public function getDCAL()
    {
        return isset($this->DCAL) ? $this->DCAL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDCAL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDCAL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDCALForChoiceConstraintsFromSetDCAL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DCAL can\'t be set as the property %s is already set. Only one property must be set among these properties: DCAL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DCAL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDCAL $dCAL
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDCAL(\StructType\TypeDCAL $dCAL = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dCALChoiceErrorMessage = self::validateDCALForChoiceConstraintsFromSetDCAL($dCAL))) {
            throw new \InvalidArgumentException($dCALChoiceErrorMessage, __LINE__);
        }
        if (is_null($dCAL) || (is_array($dCAL) && empty($dCAL))) {
            unset($this->DCAL);
        } else {
            $this->DCAL = $dCAL;
        }
        return $this;
    }
    /**
     * Get DIVN value
     * @return \StructType\TypeDIVN
     */
    public function getDIVN()
    {
        return isset($this->DIVN) ? $this->DIVN : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDIVN method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDIVN method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDIVNForChoiceConstraintsFromSetDIVN($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DIVN can\'t be set as the property %s is already set. Only one property must be set among these properties: DIVN, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DIVN value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDIVN $dIVN
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDIVN(\StructType\TypeDIVN $dIVN = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dIVNChoiceErrorMessage = self::validateDIVNForChoiceConstraintsFromSetDIVN($dIVN))) {
            throw new \InvalidArgumentException($dIVNChoiceErrorMessage, __LINE__);
        }
        if (is_null($dIVN) || (is_array($dIVN) && empty($dIVN))) {
            unset($this->DIVN);
        } else {
            $this->DIVN = $dIVN;
        }
        return $this;
    }
    /**
     * Get DIVLN value
     * @return \StructType\TypeDIVLN
     */
    public function getDIVLN()
    {
        return isset($this->DIVLN) ? $this->DIVLN : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDIVLN method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDIVLN method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDIVLNForChoiceConstraintsFromSetDIVLN($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DIVLN can\'t be set as the property %s is already set. Only one property must be set among these properties: DIVLN, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DIVLN value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDIVLN $dIVLN
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDIVLN(\StructType\TypeDIVLN $dIVLN = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dIVLNChoiceErrorMessage = self::validateDIVLNForChoiceConstraintsFromSetDIVLN($dIVLN))) {
            throw new \InvalidArgumentException($dIVLNChoiceErrorMessage, __LINE__);
        }
        if (is_null($dIVLN) || (is_array($dIVLN) && empty($dIVLN))) {
            unset($this->DIVLN);
        } else {
            $this->DIVLN = $dIVLN;
        }
        return $this;
    }
    /**
     * Get DUP value
     * @return \StructType\TypeDUP
     */
    public function getDUP()
    {
        return isset($this->DUP) ? $this->DUP : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDUP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDUP method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDUPForChoiceConstraintsFromSetDUP($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DUP can\'t be set as the property %s is already set. Only one property must be set among these properties: DUP, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DUP value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDUP $dUP
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDUP(\StructType\TypeDUP $dUP = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dUPChoiceErrorMessage = self::validateDUPForChoiceConstraintsFromSetDUP($dUP))) {
            throw new \InvalidArgumentException($dUPChoiceErrorMessage, __LINE__);
        }
        if (is_null($dUP) || (is_array($dUP) && empty($dUP))) {
            unset($this->DUP);
        } else {
            $this->DUP = $dUP;
        }
        return $this;
    }
    /**
     * Get DUPVL value
     * @return \StructType\TypeDUPVL
     */
    public function getDUPVL()
    {
        return isset($this->DUPVL) ? $this->DUPVL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDUPVL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDUPVL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDUPVLForChoiceConstraintsFromSetDUPVL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'PIVO',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DUPVL can\'t be set as the property %s is already set. Only one property must be set among these properties: DUPVL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DUPVL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeDUPVL $dUPVL
     * @return \StructType\TypeDemarcheEdition
     */
    public function setDUPVL(\StructType\TypeDUPVL $dUPVL = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($dUPVLChoiceErrorMessage = self::validateDUPVLForChoiceConstraintsFromSetDUPVL($dUPVL))) {
            throw new \InvalidArgumentException($dUPVLChoiceErrorMessage, __LINE__);
        }
        if (is_null($dUPVL) || (is_array($dUPVL) && empty($dUPVL))) {
            unset($this->DUPVL);
        } else {
            $this->DUPVL = $dUPVL;
        }
        return $this;
    }
    /**
     * Get PIVO value
     * @return \StructType\TypePIVO
     */
    public function getPIVO()
    {
        return isset($this->PIVO) ? $this->PIVO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPIVO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPIVO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePIVOForChoiceConstraintsFromSetPIVO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVOL',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PIVO can\'t be set as the property %s is already set. Only one property must be set among these properties: PIVO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PIVO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypePIVO $pIVO
     * @return \StructType\TypeDemarcheEdition
     */
    public function setPIVO(\StructType\TypePIVO $pIVO = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($pIVOChoiceErrorMessage = self::validatePIVOForChoiceConstraintsFromSetPIVO($pIVO))) {
            throw new \InvalidArgumentException($pIVOChoiceErrorMessage, __LINE__);
        }
        if (is_null($pIVO) || (is_array($pIVO) && empty($pIVO))) {
            unset($this->PIVO);
        } else {
            $this->PIVO = $pIVO;
        }
        return $this;
    }
    /**
     * Get PIVOL value
     * @return \StructType\TypePIVOL
     */
    public function getPIVOL()
    {
        return isset($this->PIVOL) ? $this->PIVOL : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPIVOL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPIVOL method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePIVOLForChoiceConstraintsFromSetPIVOL($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'MCT',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PIVOL can\'t be set as the property %s is already set. Only one property must be set among these properties: PIVOL, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PIVOL value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypePIVOL $pIVOL
     * @return \StructType\TypeDemarcheEdition
     */
    public function setPIVOL(\StructType\TypePIVOL $pIVOL = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($pIVOLChoiceErrorMessage = self::validatePIVOLForChoiceConstraintsFromSetPIVOL($pIVOL))) {
            throw new \InvalidArgumentException($pIVOLChoiceErrorMessage, __LINE__);
        }
        if (is_null($pIVOL) || (is_array($pIVOL) && empty($pIVOL))) {
            unset($this->PIVOL);
        } else {
            $this->PIVOL = $pIVOL;
        }
        return $this;
    }
    /**
     * Get MCT value
     * @return \StructType\TypeMCT
     */
    public function getMCT()
    {
        return isset($this->MCT) ? $this->MCT : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMCT method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMCT method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMCTForChoiceConstraintsFromSetMCT($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MBD',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MCT can\'t be set as the property %s is already set. Only one property must be set among these properties: MCT, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MCT value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeMCT $mCT
     * @return \StructType\TypeDemarcheEdition
     */
    public function setMCT(\StructType\TypeMCT $mCT = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($mCTChoiceErrorMessage = self::validateMCTForChoiceConstraintsFromSetMCT($mCT))) {
            throw new \InvalidArgumentException($mCTChoiceErrorMessage, __LINE__);
        }
        if (is_null($mCT) || (is_array($mCT) && empty($mCT))) {
            unset($this->MCT);
        } else {
            $this->MCT = $mCT;
        }
        return $this;
    }
    /**
     * Get MBD value
     * @return \StructType\TypeMBD
     */
    public function getMBD()
    {
        return isset($this->MBD) ? $this->MBD : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMBD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMBD method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMBDForChoiceConstraintsFromSetMBD($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'CTVO',
            'CTVLO',
            'DA',
            'DC',
            'DCA',
            'DCAL',
            'DIVN',
            'DIVLN',
            'DUP',
            'DUPVL',
            'PIVO',
            'PIVOL',
            'MCT',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MBD can\'t be set as the property %s is already set. Only one property must be set among these properties: MBD, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MBD value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeMBD $mBD
     * @return \StructType\TypeDemarcheEdition
     */
    public function setMBD(\StructType\TypeMBD $mBD = null)
    {
        // validation for constraint: choice(CTVO, CTVLO, DA, DC, DCA, DCAL, DIVN, DIVLN, DUP, DUPVL, PIVO, PIVOL, MCT, MBD)
        if ('' !== ($mBDChoiceErrorMessage = self::validateMBDForChoiceConstraintsFromSetMBD($mBD))) {
            throw new \InvalidArgumentException($mBDChoiceErrorMessage, __LINE__);
        }
        if (is_null($mBD) || (is_array($mBD) && empty($mBD))) {
            unset($this->MBD);
        } else {
            $this->MBD = $mBD;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeDemarcheEdition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
