<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fichier StructType
 * @subpackage Structs
 */
class Fichier extends AbstractStructBase
{
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nom;
    /**
     * The Contenu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Contenu;
    /**
     * The TypePiece
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypePiece;
    /**
     * The Archivage
     * Meta information extracted from the WSDL
     * - default: CFN
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Archivage;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $Date;
    /**
     * The TypePieceDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TypePieceDetail;
    /**
     * Constructor method for Fichier
     * @uses Fichier::setNom()
     * @uses Fichier::setContenu()
     * @uses Fichier::setTypePiece()
     * @uses Fichier::setArchivage()
     * @uses Fichier::setDate()
     * @uses Fichier::setTypePieceDetail()
     * @param string $nom
     * @param string $contenu
     * @param string $typePiece
     * @param string $archivage
     * @param string $date
     * @param string[] $typePieceDetail
     */
    public function __construct($nom = null, $contenu = null, $typePiece = null, $archivage = 'CFN', $date = null, array $typePieceDetail = array())
    {
        $this
            ->setNom($nom)
            ->setContenu($contenu)
            ->setTypePiece($typePiece)
            ->setArchivage($archivage)
            ->setDate($date)
            ->setTypePieceDetail($typePieceDetail);
    }
    /**
     * Get Nom value
     * @return string
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \StructType\Fichier
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get Contenu value
     * @return string
     */
    public function getContenu()
    {
        return $this->Contenu;
    }
    /**
     * Set Contenu value
     * @param string $contenu
     * @return \StructType\Fichier
     */
    public function setContenu($contenu = null)
    {
        // validation for constraint: string
        if (!is_null($contenu) && !is_string($contenu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contenu, true), gettype($contenu)), __LINE__);
        }
        $this->Contenu = $contenu;
        return $this;
    }
    /**
     * Get TypePiece value
     * @return string
     */
    public function getTypePiece()
    {
        return $this->TypePiece;
    }
    /**
     * Set TypePiece value
     * @uses \EnumType\TypePiece::valueIsValid()
     * @uses \EnumType\TypePiece::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typePiece
     * @return \StructType\Fichier
     */
    public function setTypePiece($typePiece = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypePiece::valueIsValid($typePiece)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypePiece', is_array($typePiece) ? implode(', ', $typePiece) : var_export($typePiece, true), implode(', ', \EnumType\TypePiece::getValidValues())), __LINE__);
        }
        $this->TypePiece = $typePiece;
        return $this;
    }
    /**
     * Get Archivage value
     * @return string
     */
    public function getArchivage()
    {
        return $this->Archivage;
    }
    /**
     * Set Archivage value
     * @uses \EnumType\TypeArchivage::valueIsValid()
     * @uses \EnumType\TypeArchivage::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $archivage
     * @return \StructType\Fichier
     */
    public function setArchivage($archivage = 'CFN')
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeArchivage::valueIsValid($archivage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeArchivage', is_array($archivage) ? implode(', ', $archivage) : var_export($archivage, true), implode(', ', \EnumType\TypeArchivage::getValidValues())), __LINE__);
        }
        $this->Archivage = $archivage;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Fichier
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($date) && mb_strlen($date) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($date)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($date) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($date, true)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TypePieceDetail value
     * @return string[]|null
     */
    public function getTypePieceDetail()
    {
        return $this->TypePieceDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setTypePieceDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypePieceDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypePieceDetailForArrayConstraintsFromSetTypePieceDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fichierTypePieceDetailItem) {
            // validation for constraint: enumeration
            if (!\EnumType\TypePieceDetail::valueIsValid($fichierTypePieceDetailItem)) {
                $invalidValues[] = is_object($fichierTypePieceDetailItem) ? get_class($fichierTypePieceDetailItem) : sprintf('%s(%s)', gettype($fichierTypePieceDetailItem), var_export($fichierTypePieceDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypePieceDetail', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\TypePieceDetail::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypePieceDetail value
     * @uses \EnumType\TypePieceDetail::valueIsValid()
     * @uses \EnumType\TypePieceDetail::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typePieceDetail
     * @return \StructType\Fichier
     */
    public function setTypePieceDetail(array $typePieceDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($typePieceDetailArrayErrorMessage = self::validateTypePieceDetailForArrayConstraintsFromSetTypePieceDetail($typePieceDetail))) {
            throw new \InvalidArgumentException($typePieceDetailArrayErrorMessage, __LINE__);
        }
        $this->TypePieceDetail = $typePieceDetail;
        return $this;
    }
    /**
     * Add item to TypePieceDetail value
     * @uses \EnumType\TypePieceDetail::valueIsValid()
     * @uses \EnumType\TypePieceDetail::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Fichier
     */
    public function addToTypePieceDetail($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypePieceDetail::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypePieceDetail', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypePieceDetail::getValidValues())), __LINE__);
        }
        $this->TypePieceDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Fichier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
