<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Info ServiceType
 * @subpackage Services
 */
class Info extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InfoImmat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InfoImmat_Req $infoImmatRepMsg
     * @return \StructType\InfoImmat_Rep|bool
     */
    public function InfoImmat(\StructType\InfoImmat_Req $infoImmatRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->InfoImmat($infoImmatRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InfoVIN
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InfoVIN_Req $infoVINRepMsg
     * @return \StructType\InfoVIN_Rep|bool
     */
    public function InfoVIN(\StructType\InfoVIN_Req $infoVINRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->InfoVIN($infoVINRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InfoCoC
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InfoCoC_Req $infoCoCRepMsg
     * @return \StructType\InfoCoC_Rep|bool
     */
    public function InfoCoC(\StructType\InfoCoC_Req $infoCoCRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->InfoCoC($infoCoCRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InfoCoC_Rep|\StructType\InfoImmat_Rep|\StructType\InfoVIN_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
