<?php

namespace EnumType;

/**
 * This class stands for Z1_Mention1 EnumType
 * @subpackage Enumerations
 */
class Z1_Mention1
{
    /**
     * Constant for value 'DEM'
     * @return string 'DEM'
     */
    const VALUE_DEM = 'DEM';
    /**
     * Constant for value 'TT'
     * @return string 'TT'
     */
    const VALUE_TT = 'TT';
    /**
     * Constant for value 'AGR'
     * @return string 'AGR'
     */
    const VALUE_AGR = 'AGR';
    /**
     * Constant for value 'ADM'
     * @return string 'ADM'
     */
    const VALUE_ADM = 'ADM';
    /**
     * Constant for value 'MIL'
     * @return string 'MIL'
     */
    const VALUE_MIL = 'MIL';
    /**
     * Constant for value 'IT'
     * @return string 'IT'
     */
    const VALUE_IT = 'IT';
    /**
     * Constant for value 'GEX'
     * @return string 'GEX'
     */
    const VALUE_GEX = 'GEX';
    /**
     * Constant for value 'SAV'
     * @return string 'SAV'
     */
    const VALUE_SAV = 'SAV';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEM
     * @uses self::VALUE_TT
     * @uses self::VALUE_AGR
     * @uses self::VALUE_ADM
     * @uses self::VALUE_MIL
     * @uses self::VALUE_IT
     * @uses self::VALUE_GEX
     * @uses self::VALUE_SAV
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEM,
            self::VALUE_TT,
            self::VALUE_AGR,
            self::VALUE_ADM,
            self::VALUE_MIL,
            self::VALUE_IT,
            self::VALUE_GEX,
            self::VALUE_SAV,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
