<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeDUPVL StructType
 * @subpackage Structs
 */
class TypeDUPVL extends AbstractStructBase
{
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: DUPVL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The ModeExpedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModeExpedition;
    /**
     * The MotifDuplicata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MotifDuplicata;
    /**
     * The Titulaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Titulaire
     */
    public $Titulaire;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The PaiementCBClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaiementCBClient;
    /**
     * The NumPortable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumPortable;
    /**
     * The CTVOouDC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $CTVOouDC;
    /**
     * The DatePerte
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DatePerte;
    /**
     * The Expedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expedition
     */
    public $Expedition;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeDUPVL
     * @uses TypeDUPVL::setTypeDemarche()
     * @uses TypeDUPVL::setDateDemarche()
     * @uses TypeDUPVL::setModeExpedition()
     * @uses TypeDUPVL::setMotifDuplicata()
     * @uses TypeDUPVL::setTitulaire()
     * @uses TypeDUPVL::setVehicule()
     * @uses TypeDUPVL::setID()
     * @uses TypeDUPVL::setPaiementCBClient()
     * @uses TypeDUPVL::setNumPortable()
     * @uses TypeDUPVL::setCTVOouDC()
     * @uses TypeDUPVL::setDatePerte()
     * @uses TypeDUPVL::setExpedition()
     * @uses TypeDUPVL::setReponse()
     * @param string $typeDemarche
     * @param string $dateDemarche
     * @param string $modeExpedition
     * @param string $motifDuplicata
     * @param \StructType\Titulaire $titulaire
     * @param \StructType\Vehicule $vehicule
     * @param int $iD
     * @param bool $paiementCBClient
     * @param string $numPortable
     * @param bool $cTVOouDC
     * @param string $datePerte
     * @param \StructType\Expedition $expedition
     * @param \StructType\Reponse $reponse
     */
    public function __construct($typeDemarche = null, $dateDemarche = null, $modeExpedition = null, $motifDuplicata = null, \StructType\Titulaire $titulaire = null, \StructType\Vehicule $vehicule = null, $iD = null, $paiementCBClient = null, $numPortable = null, $cTVOouDC = null, $datePerte = null, \StructType\Expedition $expedition = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setTypeDemarche($typeDemarche)
            ->setDateDemarche($dateDemarche)
            ->setModeExpedition($modeExpedition)
            ->setMotifDuplicata($motifDuplicata)
            ->setTitulaire($titulaire)
            ->setVehicule($vehicule)
            ->setID($iD)
            ->setPaiementCBClient($paiementCBClient)
            ->setNumPortable($numPortable)
            ->setCTVOouDC($cTVOouDC)
            ->setDatePerte($datePerte)
            ->setExpedition($expedition)
            ->setReponse($reponse);
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeDUPVL
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypeDUPVL
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get ModeExpedition value
     * @return string
     */
    public function getModeExpedition()
    {
        return $this->ModeExpedition;
    }
    /**
     * Set ModeExpedition value
     * @uses \EnumType\ModeExp::valueIsValid()
     * @uses \EnumType\ModeExp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modeExpedition
     * @return \StructType\TypeDUPVL
     */
    public function setModeExpedition($modeExpedition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModeExp::valueIsValid($modeExpedition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ModeExp', is_array($modeExpedition) ? implode(', ', $modeExpedition) : var_export($modeExpedition, true), implode(', ', \EnumType\ModeExp::getValidValues())), __LINE__);
        }
        $this->ModeExpedition = $modeExpedition;
        return $this;
    }
    /**
     * Get MotifDuplicata value
     * @return string
     */
    public function getMotifDuplicata()
    {
        return $this->MotifDuplicata;
    }
    /**
     * Set MotifDuplicata value
     * @uses \EnumType\MotifDUP::valueIsValid()
     * @uses \EnumType\MotifDUP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $motifDuplicata
     * @return \StructType\TypeDUPVL
     */
    public function setMotifDuplicata($motifDuplicata = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MotifDUP::valueIsValid($motifDuplicata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MotifDUP', is_array($motifDuplicata) ? implode(', ', $motifDuplicata) : var_export($motifDuplicata, true), implode(', ', \EnumType\MotifDUP::getValidValues())), __LINE__);
        }
        $this->MotifDuplicata = $motifDuplicata;
        return $this;
    }
    /**
     * Get Titulaire value
     * @return \StructType\Titulaire
     */
    public function getTitulaire()
    {
        return $this->Titulaire;
    }
    /**
     * Set Titulaire value
     * @param \StructType\Titulaire $titulaire
     * @return \StructType\TypeDUPVL
     */
    public function setTitulaire(\StructType\Titulaire $titulaire = null)
    {
        $this->Titulaire = $titulaire;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeDUPVL
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeDUPVL
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PaiementCBClient value
     * @return bool|null
     */
    public function getPaiementCBClient()
    {
        return $this->PaiementCBClient;
    }
    /**
     * Set PaiementCBClient value
     * @param bool $paiementCBClient
     * @return \StructType\TypeDUPVL
     */
    public function setPaiementCBClient($paiementCBClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($paiementCBClient) && !is_bool($paiementCBClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paiementCBClient, true), gettype($paiementCBClient)), __LINE__);
        }
        $this->PaiementCBClient = $paiementCBClient;
        return $this;
    }
    /**
     * Get NumPortable value
     * @return string|null
     */
    public function getNumPortable()
    {
        return $this->NumPortable;
    }
    /**
     * Set NumPortable value
     * @param string $numPortable
     * @return \StructType\TypeDUPVL
     */
    public function setNumPortable($numPortable = null)
    {
        // validation for constraint: string
        if (!is_null($numPortable) && !is_string($numPortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPortable, true), gettype($numPortable)), __LINE__);
        }
        $this->NumPortable = $numPortable;
        return $this;
    }
    /**
     * Get CTVOouDC value
     * @return bool|null
     */
    public function getCTVOouDC()
    {
        return $this->CTVOouDC;
    }
    /**
     * Set CTVOouDC value
     * @param bool $cTVOouDC
     * @return \StructType\TypeDUPVL
     */
    public function setCTVOouDC($cTVOouDC = null)
    {
        // validation for constraint: boolean
        if (!is_null($cTVOouDC) && !is_bool($cTVOouDC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cTVOouDC, true), gettype($cTVOouDC)), __LINE__);
        }
        $this->CTVOouDC = $cTVOouDC;
        return $this;
    }
    /**
     * Get DatePerte value
     * @return string|null
     */
    public function getDatePerte()
    {
        return $this->DatePerte;
    }
    /**
     * Set DatePerte value
     * @param string $datePerte
     * @return \StructType\TypeDUPVL
     */
    public function setDatePerte($datePerte = null)
    {
        // validation for constraint: string
        if (!is_null($datePerte) && !is_string($datePerte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePerte, true), gettype($datePerte)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($datePerte) && mb_strlen($datePerte) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($datePerte)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($datePerte) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $datePerte)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($datePerte, true)), __LINE__);
        }
        $this->DatePerte = $datePerte;
        return $this;
    }
    /**
     * Get Expedition value
     * @return \StructType\Expedition|null
     */
    public function getExpedition()
    {
        return $this->Expedition;
    }
    /**
     * Set Expedition value
     * @param \StructType\Expedition $expedition
     * @return \StructType\TypeDUPVL
     */
    public function setExpedition(\StructType\Expedition $expedition = null)
    {
        $this->Expedition = $expedition;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeDUPVL
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeDUPVL
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
