<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoImmat_Req StructType
 * @subpackage Structs
 */
class InfoImmat_Req extends AbstractStructBase
{
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeIdentification
     */
    public $Identification;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 7
     * - minOccurs: 1
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The ModeString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ModeString;
    /**
     * The Origine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origine;
    /**
     * Constructor method for InfoImmat_Req
     * @uses InfoImmat_Req::setIdentification()
     * @uses InfoImmat_Req::setImmatriculation()
     * @uses InfoImmat_Req::setModeString()
     * @uses InfoImmat_Req::setOrigine()
     * @param \StructType\TypeIdentification $identification
     * @param string $immatriculation
     * @param bool $modeString
     * @param string $origine
     */
    public function __construct(\StructType\TypeIdentification $identification = null, $immatriculation = null, $modeString = null, $origine = null)
    {
        $this
            ->setIdentification($identification)
            ->setImmatriculation($immatriculation)
            ->setModeString($modeString)
            ->setOrigine($origine);
    }
    /**
     * Get Identification value
     * @return \StructType\TypeIdentification
     */
    public function getIdentification()
    {
        return $this->Identification;
    }
    /**
     * Set Identification value
     * @param \StructType\TypeIdentification $identification
     * @return \StructType\InfoImmat_Req
     */
    public function setIdentification(\StructType\TypeIdentification $identification = null)
    {
        $this->Identification = $identification;
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string
     */
    public function getImmatriculation()
    {
        return $this->Immatriculation;
    }
    /**
     * Set Immatriculation value
     * @param string $immatriculation
     * @return \StructType\InfoImmat_Req
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        $this->Immatriculation = $immatriculation;
        return $this;
    }
    /**
     * Get ModeString value
     * @return bool|null
     */
    public function getModeString()
    {
        return $this->ModeString;
    }
    /**
     * Set ModeString value
     * @param bool $modeString
     * @return \StructType\InfoImmat_Req
     */
    public function setModeString($modeString = null)
    {
        // validation for constraint: boolean
        if (!is_null($modeString) && !is_bool($modeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($modeString, true), gettype($modeString)), __LINE__);
        }
        $this->ModeString = $modeString;
        return $this;
    }
    /**
     * Get Origine value
     * @return string|null
     */
    public function getOrigine()
    {
        return $this->Origine;
    }
    /**
     * Set Origine value
     * @param string $origine
     * @return \StructType\InfoImmat_Req
     */
    public function setOrigine($origine = null)
    {
        // validation for constraint: string
        if (!is_null($origine) && !is_string($origine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origine, true), gettype($origine)), __LINE__);
        }
        $this->Origine = $origine;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InfoImmat_Req
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
