<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehiculeCaracteristiquesNationale StructType
 * @subpackage Structs
 */
class VehiculeCaracteristiquesNationale extends AbstractStructBase
{
    /**
     * The J_CategorieCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $J_CategorieCE;
    /**
     * The P6_PuissFiscale
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $P6_PuissFiscale;
    /**
     * The D3_Denomination
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $D3_Denomination;
    /**
     * The F3_MMaxAdmEns
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $F3_MMaxAdmEns;
    /**
     * The J2_CarrosserieCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $J2_CarrosserieCE;
    /**
     * The P1_Cyl
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $P1_Cyl;
    /**
     * The P2_PuissKW
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $P2_PuissKW;
    /**
     * The P3_Energie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $P3_Energie;
    /**
     * The Q_RapportPuissMasse
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Q_RapportPuissMasse;
    /**
     * The S2_NbPlaceDebout
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var int
     */
    public $S2_NbPlaceDebout;
    /**
     * The U1_NiveauSonore
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var int
     */
    public $U1_NiveauSonore;
    /**
     * The U2_NbTours
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $U2_NbTours;
    /**
     * The V7_Co2
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 3
     * @var int
     */
    public $V7_Co2;
    /**
     * The V9_ClasseEnvCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $V9_ClasseEnvCE;
    /**
     * Constructor method for VehiculeCaracteristiquesNationale
     * @uses VehiculeCaracteristiquesNationale::setJ_CategorieCE()
     * @uses VehiculeCaracteristiquesNationale::setP6_PuissFiscale()
     * @uses VehiculeCaracteristiquesNationale::setD3_Denomination()
     * @uses VehiculeCaracteristiquesNationale::setF3_MMaxAdmEns()
     * @uses VehiculeCaracteristiquesNationale::setJ2_CarrosserieCE()
     * @uses VehiculeCaracteristiquesNationale::setP1_Cyl()
     * @uses VehiculeCaracteristiquesNationale::setP2_PuissKW()
     * @uses VehiculeCaracteristiquesNationale::setP3_Energie()
     * @uses VehiculeCaracteristiquesNationale::setQ_RapportPuissMasse()
     * @uses VehiculeCaracteristiquesNationale::setS2_NbPlaceDebout()
     * @uses VehiculeCaracteristiquesNationale::setU1_NiveauSonore()
     * @uses VehiculeCaracteristiquesNationale::setU2_NbTours()
     * @uses VehiculeCaracteristiquesNationale::setV7_Co2()
     * @uses VehiculeCaracteristiquesNationale::setV9_ClasseEnvCE()
     * @param string $j_CategorieCE
     * @param int $p6_PuissFiscale
     * @param string $d3_Denomination
     * @param int $f3_MMaxAdmEns
     * @param string $j2_CarrosserieCE
     * @param float $p1_Cyl
     * @param float $p2_PuissKW
     * @param string $p3_Energie
     * @param float $q_RapportPuissMasse
     * @param int $s2_NbPlaceDebout
     * @param int $u1_NiveauSonore
     * @param int $u2_NbTours
     * @param int $v7_Co2
     * @param string $v9_ClasseEnvCE
     */
    public function __construct($j_CategorieCE = null, $p6_PuissFiscale = null, $d3_Denomination = null, $f3_MMaxAdmEns = null, $j2_CarrosserieCE = null, $p1_Cyl = null, $p2_PuissKW = null, $p3_Energie = null, $q_RapportPuissMasse = null, $s2_NbPlaceDebout = null, $u1_NiveauSonore = null, $u2_NbTours = null, $v7_Co2 = null, $v9_ClasseEnvCE = null)
    {
        $this
            ->setJ_CategorieCE($j_CategorieCE)
            ->setP6_PuissFiscale($p6_PuissFiscale)
            ->setD3_Denomination($d3_Denomination)
            ->setF3_MMaxAdmEns($f3_MMaxAdmEns)
            ->setJ2_CarrosserieCE($j2_CarrosserieCE)
            ->setP1_Cyl($p1_Cyl)
            ->setP2_PuissKW($p2_PuissKW)
            ->setP3_Energie($p3_Energie)
            ->setQ_RapportPuissMasse($q_RapportPuissMasse)
            ->setS2_NbPlaceDebout($s2_NbPlaceDebout)
            ->setU1_NiveauSonore($u1_NiveauSonore)
            ->setU2_NbTours($u2_NbTours)
            ->setV7_Co2($v7_Co2)
            ->setV9_ClasseEnvCE($v9_ClasseEnvCE);
    }
    /**
     * Get J_CategorieCE value
     * @return string
     */
    public function getJ_CategorieCE()
    {
        return $this->J_CategorieCE;
    }
    /**
     * Set J_CategorieCE value
     * @param string $j_CategorieCE
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setJ_CategorieCE($j_CategorieCE = null)
    {
        // validation for constraint: string
        if (!is_null($j_CategorieCE) && !is_string($j_CategorieCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j_CategorieCE, true), gettype($j_CategorieCE)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($j_CategorieCE) && mb_strlen($j_CategorieCE) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($j_CategorieCE)), __LINE__);
        }
        $this->J_CategorieCE = $j_CategorieCE;
        return $this;
    }
    /**
     * Get P6_PuissFiscale value
     * @return int
     */
    public function getP6_PuissFiscale()
    {
        return $this->P6_PuissFiscale;
    }
    /**
     * Set P6_PuissFiscale value
     * @param int $p6_PuissFiscale
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setP6_PuissFiscale($p6_PuissFiscale = null)
    {
        // validation for constraint: int
        if (!is_null($p6_PuissFiscale) && !(is_int($p6_PuissFiscale) || ctype_digit($p6_PuissFiscale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($p6_PuissFiscale, true), gettype($p6_PuissFiscale)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($p6_PuissFiscale) && mb_strlen(preg_replace('/(\D)/', '', $p6_PuissFiscale)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($p6_PuissFiscale, true), mb_strlen(preg_replace('/(\D)/', '', $p6_PuissFiscale))), __LINE__);
        }
        $this->P6_PuissFiscale = $p6_PuissFiscale;
        return $this;
    }
    /**
     * Get D3_Denomination value
     * @return string|null
     */
    public function getD3_Denomination()
    {
        return $this->D3_Denomination;
    }
    /**
     * Set D3_Denomination value
     * @param string $d3_Denomination
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setD3_Denomination($d3_Denomination = null)
    {
        // validation for constraint: string
        if (!is_null($d3_Denomination) && !is_string($d3_Denomination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d3_Denomination, true), gettype($d3_Denomination)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($d3_Denomination) && mb_strlen($d3_Denomination) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($d3_Denomination)), __LINE__);
        }
        $this->D3_Denomination = $d3_Denomination;
        return $this;
    }
    /**
     * Get F3_MMaxAdmEns value
     * @return int|null
     */
    public function getF3_MMaxAdmEns()
    {
        return $this->F3_MMaxAdmEns;
    }
    /**
     * Set F3_MMaxAdmEns value
     * @param int $f3_MMaxAdmEns
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setF3_MMaxAdmEns($f3_MMaxAdmEns = null)
    {
        // validation for constraint: int
        if (!is_null($f3_MMaxAdmEns) && !(is_int($f3_MMaxAdmEns) || ctype_digit($f3_MMaxAdmEns))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f3_MMaxAdmEns, true), gettype($f3_MMaxAdmEns)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f3_MMaxAdmEns) && mb_strlen(preg_replace('/(\D)/', '', $f3_MMaxAdmEns)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f3_MMaxAdmEns, true), mb_strlen(preg_replace('/(\D)/', '', $f3_MMaxAdmEns))), __LINE__);
        }
        $this->F3_MMaxAdmEns = $f3_MMaxAdmEns;
        return $this;
    }
    /**
     * Get J2_CarrosserieCE value
     * @return string|null
     */
    public function getJ2_CarrosserieCE()
    {
        return $this->J2_CarrosserieCE;
    }
    /**
     * Set J2_CarrosserieCE value
     * @param string $j2_CarrosserieCE
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setJ2_CarrosserieCE($j2_CarrosserieCE = null)
    {
        // validation for constraint: string
        if (!is_null($j2_CarrosserieCE) && !is_string($j2_CarrosserieCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j2_CarrosserieCE, true), gettype($j2_CarrosserieCE)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($j2_CarrosserieCE) && mb_strlen($j2_CarrosserieCE) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($j2_CarrosserieCE)), __LINE__);
        }
        $this->J2_CarrosserieCE = $j2_CarrosserieCE;
        return $this;
    }
    /**
     * Get P1_Cyl value
     * @return float|null
     */
    public function getP1_Cyl()
    {
        return $this->P1_Cyl;
    }
    /**
     * Set P1_Cyl value
     * @param float $p1_Cyl
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setP1_Cyl($p1_Cyl = null)
    {
        // validation for constraint: float
        if (!is_null($p1_Cyl) && !(is_float($p1_Cyl) || is_numeric($p1_Cyl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($p1_Cyl, true), gettype($p1_Cyl)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($p1_Cyl) && mb_strlen(mb_substr($p1_Cyl, mb_strpos($p1_Cyl, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($p1_Cyl, true), mb_strlen(mb_substr($p1_Cyl, mb_strpos($p1_Cyl, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($p1_Cyl) && mb_strlen(preg_replace('/(\D)/', '', $p1_Cyl)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($p1_Cyl, true), mb_strlen(preg_replace('/(\D)/', '', $p1_Cyl))), __LINE__);
        }
        $this->P1_Cyl = $p1_Cyl;
        return $this;
    }
    /**
     * Get P2_PuissKW value
     * @return float|null
     */
    public function getP2_PuissKW()
    {
        return $this->P2_PuissKW;
    }
    /**
     * Set P2_PuissKW value
     * @param float $p2_PuissKW
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setP2_PuissKW($p2_PuissKW = null)
    {
        // validation for constraint: float
        if (!is_null($p2_PuissKW) && !(is_float($p2_PuissKW) || is_numeric($p2_PuissKW))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($p2_PuissKW, true), gettype($p2_PuissKW)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($p2_PuissKW) && mb_strlen(mb_substr($p2_PuissKW, mb_strpos($p2_PuissKW, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($p2_PuissKW, true), mb_strlen(mb_substr($p2_PuissKW, mb_strpos($p2_PuissKW, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($p2_PuissKW) && mb_strlen(preg_replace('/(\D)/', '', $p2_PuissKW)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($p2_PuissKW, true), mb_strlen(preg_replace('/(\D)/', '', $p2_PuissKW))), __LINE__);
        }
        $this->P2_PuissKW = $p2_PuissKW;
        return $this;
    }
    /**
     * Get P3_Energie value
     * @return string|null
     */
    public function getP3_Energie()
    {
        return $this->P3_Energie;
    }
    /**
     * Set P3_Energie value
     * @param string $p3_Energie
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setP3_Energie($p3_Energie = null)
    {
        // validation for constraint: string
        if (!is_null($p3_Energie) && !is_string($p3_Energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($p3_Energie, true), gettype($p3_Energie)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($p3_Energie) && mb_strlen($p3_Energie) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($p3_Energie)), __LINE__);
        }
        $this->P3_Energie = $p3_Energie;
        return $this;
    }
    /**
     * Get Q_RapportPuissMasse value
     * @return float|null
     */
    public function getQ_RapportPuissMasse()
    {
        return $this->Q_RapportPuissMasse;
    }
    /**
     * Set Q_RapportPuissMasse value
     * @param float $q_RapportPuissMasse
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setQ_RapportPuissMasse($q_RapportPuissMasse = null)
    {
        // validation for constraint: float
        if (!is_null($q_RapportPuissMasse) && !(is_float($q_RapportPuissMasse) || is_numeric($q_RapportPuissMasse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($q_RapportPuissMasse, true), gettype($q_RapportPuissMasse)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($q_RapportPuissMasse) && mb_strlen(mb_substr($q_RapportPuissMasse, mb_strpos($q_RapportPuissMasse, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($q_RapportPuissMasse, true), mb_strlen(mb_substr($q_RapportPuissMasse, mb_strpos($q_RapportPuissMasse, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($q_RapportPuissMasse) && mb_strlen(preg_replace('/(\D)/', '', $q_RapportPuissMasse)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($q_RapportPuissMasse, true), mb_strlen(preg_replace('/(\D)/', '', $q_RapportPuissMasse))), __LINE__);
        }
        $this->Q_RapportPuissMasse = $q_RapportPuissMasse;
        return $this;
    }
    /**
     * Get S2_NbPlaceDebout value
     * @return int|null
     */
    public function getS2_NbPlaceDebout()
    {
        return $this->S2_NbPlaceDebout;
    }
    /**
     * Set S2_NbPlaceDebout value
     * @param int $s2_NbPlaceDebout
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setS2_NbPlaceDebout($s2_NbPlaceDebout = null)
    {
        // validation for constraint: int
        if (!is_null($s2_NbPlaceDebout) && !(is_int($s2_NbPlaceDebout) || ctype_digit($s2_NbPlaceDebout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s2_NbPlaceDebout, true), gettype($s2_NbPlaceDebout)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s2_NbPlaceDebout) && mb_strlen(preg_replace('/(\D)/', '', $s2_NbPlaceDebout)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s2_NbPlaceDebout, true), mb_strlen(preg_replace('/(\D)/', '', $s2_NbPlaceDebout))), __LINE__);
        }
        $this->S2_NbPlaceDebout = $s2_NbPlaceDebout;
        return $this;
    }
    /**
     * Get U1_NiveauSonore value
     * @return int|null
     */
    public function getU1_NiveauSonore()
    {
        return $this->U1_NiveauSonore;
    }
    /**
     * Set U1_NiveauSonore value
     * @param int $u1_NiveauSonore
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setU1_NiveauSonore($u1_NiveauSonore = null)
    {
        // validation for constraint: int
        if (!is_null($u1_NiveauSonore) && !(is_int($u1_NiveauSonore) || ctype_digit($u1_NiveauSonore))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($u1_NiveauSonore, true), gettype($u1_NiveauSonore)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($u1_NiveauSonore) && mb_strlen(preg_replace('/(\D)/', '', $u1_NiveauSonore)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($u1_NiveauSonore, true), mb_strlen(preg_replace('/(\D)/', '', $u1_NiveauSonore))), __LINE__);
        }
        $this->U1_NiveauSonore = $u1_NiveauSonore;
        return $this;
    }
    /**
     * Get U2_NbTours value
     * @return int|null
     */
    public function getU2_NbTours()
    {
        return $this->U2_NbTours;
    }
    /**
     * Set U2_NbTours value
     * @param int $u2_NbTours
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setU2_NbTours($u2_NbTours = null)
    {
        // validation for constraint: int
        if (!is_null($u2_NbTours) && !(is_int($u2_NbTours) || ctype_digit($u2_NbTours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($u2_NbTours, true), gettype($u2_NbTours)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($u2_NbTours) && mb_strlen(preg_replace('/(\D)/', '', $u2_NbTours)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($u2_NbTours, true), mb_strlen(preg_replace('/(\D)/', '', $u2_NbTours))), __LINE__);
        }
        $this->U2_NbTours = $u2_NbTours;
        return $this;
    }
    /**
     * Get V7_Co2 value
     * @return int|null
     */
    public function getV7_Co2()
    {
        return $this->V7_Co2;
    }
    /**
     * Set V7_Co2 value
     * @param int $v7_Co2
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setV7_Co2($v7_Co2 = null)
    {
        // validation for constraint: int
        if (!is_null($v7_Co2) && !(is_int($v7_Co2) || ctype_digit($v7_Co2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($v7_Co2, true), gettype($v7_Co2)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($v7_Co2) && mb_strlen(preg_replace('/(\D)/', '', $v7_Co2)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($v7_Co2, true), mb_strlen(preg_replace('/(\D)/', '', $v7_Co2))), __LINE__);
        }
        $this->V7_Co2 = $v7_Co2;
        return $this;
    }
    /**
     * Get V9_ClasseEnvCE value
     * @return string|null
     */
    public function getV9_ClasseEnvCE()
    {
        return $this->V9_ClasseEnvCE;
    }
    /**
     * Set V9_ClasseEnvCE value
     * @param string $v9_ClasseEnvCE
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public function setV9_ClasseEnvCE($v9_ClasseEnvCE = null)
    {
        // validation for constraint: string
        if (!is_null($v9_ClasseEnvCE) && !is_string($v9_ClasseEnvCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($v9_ClasseEnvCE, true), gettype($v9_ClasseEnvCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($v9_ClasseEnvCE) && mb_strlen($v9_ClasseEnvCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($v9_ClasseEnvCE)), __LINE__);
        }
        $this->V9_ClasseEnvCE = $v9_ClasseEnvCE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehiculeCaracteristiquesNationale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
