<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeCTLLD StructType
 * @subpackage Structs
 */
class TypeCTLLD extends AbstractStructBase
{
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: CTLLD
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The TypeLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeLocation;
    /**
     * The ModeExpedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModeExpedition;
    /**
     * The Titulaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Titulaire
     */
    public $Titulaire;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Vehicule
     */
    public $Vehicule;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The PaiementCBClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaiementCBClient;
    /**
     * The NumPortable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumPortable;
    /**
     * The EmissionBO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $EmissionBO;
    /**
     * The Locataire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Locataire
     */
    public $Locataire;
    /**
     * The Loueur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Loueur
     */
    public $Loueur;
    /**
     * The Expedition
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Expedition
     */
    public $Expedition;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypeCTLLD
     * @uses TypeCTLLD::setTypeDemarche()
     * @uses TypeCTLLD::setDateDemarche()
     * @uses TypeCTLLD::setTypeLocation()
     * @uses TypeCTLLD::setModeExpedition()
     * @uses TypeCTLLD::setTitulaire()
     * @uses TypeCTLLD::setVehicule()
     * @uses TypeCTLLD::setID()
     * @uses TypeCTLLD::setPaiementCBClient()
     * @uses TypeCTLLD::setNumPortable()
     * @uses TypeCTLLD::setEmissionBO()
     * @uses TypeCTLLD::setLocataire()
     * @uses TypeCTLLD::setLoueur()
     * @uses TypeCTLLD::setExpedition()
     * @uses TypeCTLLD::setReponse()
     * @param string $typeDemarche
     * @param string $dateDemarche
     * @param string $typeLocation
     * @param string $modeExpedition
     * @param \StructType\Titulaire $titulaire
     * @param \StructType\Vehicule $vehicule
     * @param int $iD
     * @param bool $paiementCBClient
     * @param string $numPortable
     * @param bool $emissionBO
     * @param \StructType\Locataire $locataire
     * @param \StructType\Loueur $loueur
     * @param \StructType\Expedition $expedition
     * @param \StructType\Reponse $reponse
     */
    public function __construct($typeDemarche = null, $dateDemarche = null, $typeLocation = null, $modeExpedition = null, \StructType\Titulaire $titulaire = null, \StructType\Vehicule $vehicule = null, $iD = null, $paiementCBClient = null, $numPortable = null, $emissionBO = null, \StructType\Locataire $locataire = null, \StructType\Loueur $loueur = null, \StructType\Expedition $expedition = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setTypeDemarche($typeDemarche)
            ->setDateDemarche($dateDemarche)
            ->setTypeLocation($typeLocation)
            ->setModeExpedition($modeExpedition)
            ->setTitulaire($titulaire)
            ->setVehicule($vehicule)
            ->setID($iD)
            ->setPaiementCBClient($paiementCBClient)
            ->setNumPortable($numPortable)
            ->setEmissionBO($emissionBO)
            ->setLocataire($locataire)
            ->setLoueur($loueur)
            ->setExpedition($expedition)
            ->setReponse($reponse);
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypeCTLLD
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypeCTLLD
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get TypeLocation value
     * @return string
     */
    public function getTypeLocation()
    {
        return $this->TypeLocation;
    }
    /**
     * Set TypeLocation value
     * @uses \EnumType\TypeLoc::valueIsValid()
     * @uses \EnumType\TypeLoc::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeLocation
     * @return \StructType\TypeCTLLD
     */
    public function setTypeLocation($typeLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeLoc::valueIsValid($typeLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeLoc', is_array($typeLocation) ? implode(', ', $typeLocation) : var_export($typeLocation, true), implode(', ', \EnumType\TypeLoc::getValidValues())), __LINE__);
        }
        $this->TypeLocation = $typeLocation;
        return $this;
    }
    /**
     * Get ModeExpedition value
     * @return string
     */
    public function getModeExpedition()
    {
        return $this->ModeExpedition;
    }
    /**
     * Set ModeExpedition value
     * @uses \EnumType\ModeExp::valueIsValid()
     * @uses \EnumType\ModeExp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $modeExpedition
     * @return \StructType\TypeCTLLD
     */
    public function setModeExpedition($modeExpedition = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModeExp::valueIsValid($modeExpedition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ModeExp', is_array($modeExpedition) ? implode(', ', $modeExpedition) : var_export($modeExpedition, true), implode(', ', \EnumType\ModeExp::getValidValues())), __LINE__);
        }
        $this->ModeExpedition = $modeExpedition;
        return $this;
    }
    /**
     * Get Titulaire value
     * @return \StructType\Titulaire
     */
    public function getTitulaire()
    {
        return $this->Titulaire;
    }
    /**
     * Set Titulaire value
     * @param \StructType\Titulaire $titulaire
     * @return \StructType\TypeCTLLD
     */
    public function setTitulaire(\StructType\Titulaire $titulaire = null)
    {
        $this->Titulaire = $titulaire;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\Vehicule
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\Vehicule $vehicule
     * @return \StructType\TypeCTLLD
     */
    public function setVehicule(\StructType\Vehicule $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypeCTLLD
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PaiementCBClient value
     * @return bool|null
     */
    public function getPaiementCBClient()
    {
        return $this->PaiementCBClient;
    }
    /**
     * Set PaiementCBClient value
     * @param bool $paiementCBClient
     * @return \StructType\TypeCTLLD
     */
    public function setPaiementCBClient($paiementCBClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($paiementCBClient) && !is_bool($paiementCBClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paiementCBClient, true), gettype($paiementCBClient)), __LINE__);
        }
        $this->PaiementCBClient = $paiementCBClient;
        return $this;
    }
    /**
     * Get NumPortable value
     * @return string|null
     */
    public function getNumPortable()
    {
        return $this->NumPortable;
    }
    /**
     * Set NumPortable value
     * @param string $numPortable
     * @return \StructType\TypeCTLLD
     */
    public function setNumPortable($numPortable = null)
    {
        // validation for constraint: string
        if (!is_null($numPortable) && !is_string($numPortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPortable, true), gettype($numPortable)), __LINE__);
        }
        $this->NumPortable = $numPortable;
        return $this;
    }
    /**
     * Get EmissionBO value
     * @return bool|null
     */
    public function getEmissionBO()
    {
        return $this->EmissionBO;
    }
    /**
     * Set EmissionBO value
     * @param bool $emissionBO
     * @return \StructType\TypeCTLLD
     */
    public function setEmissionBO($emissionBO = null)
    {
        // validation for constraint: boolean
        if (!is_null($emissionBO) && !is_bool($emissionBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emissionBO, true), gettype($emissionBO)), __LINE__);
        }
        $this->EmissionBO = $emissionBO;
        return $this;
    }
    /**
     * Get Locataire value
     * @return \StructType\Locataire|null
     */
    public function getLocataire()
    {
        return $this->Locataire;
    }
    /**
     * Set Locataire value
     * @param \StructType\Locataire $locataire
     * @return \StructType\TypeCTLLD
     */
    public function setLocataire(\StructType\Locataire $locataire = null)
    {
        $this->Locataire = $locataire;
        return $this;
    }
    /**
     * Get Loueur value
     * @return \StructType\Loueur|null
     */
    public function getLoueur()
    {
        return $this->Loueur;
    }
    /**
     * Set Loueur value
     * @param \StructType\Loueur $loueur
     * @return \StructType\TypeCTLLD
     */
    public function setLoueur(\StructType\Loueur $loueur = null)
    {
        $this->Loueur = $loueur;
        return $this;
    }
    /**
     * Get Expedition value
     * @return \StructType\Expedition|null
     */
    public function getExpedition()
    {
        return $this->Expedition;
    }
    /**
     * Set Expedition value
     * @param \StructType\Expedition $expedition
     * @return \StructType\TypeCTLLD
     */
    public function setExpedition(\StructType\Expedition $expedition = null)
    {
        $this->Expedition = $expedition;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypeCTLLD
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeCTLLD
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
