<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonneMorale StructType
 * @subpackage Structs
 */
class PersonneMorale extends AbstractStructBase
{
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RaisonSociale;
    /**
     * The SocieteCommerciale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SocieteCommerciale;
    /**
     * The SIREN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 9
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{9}
     * @var string
     */
    public $SIREN;
    /**
     * The SIRET
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minLength: 9
     * - minOccurs: 0
     * - pattern: [0-9]{9,14}
     * @var string
     */
    public $SIRET;
    /**
     * Constructor method for PersonneMorale
     * @uses PersonneMorale::setRaisonSociale()
     * @uses PersonneMorale::setSocieteCommerciale()
     * @uses PersonneMorale::setSIREN()
     * @uses PersonneMorale::setSIRET()
     * @param string $raisonSociale
     * @param bool $societeCommerciale
     * @param string $sIREN
     * @param string $sIRET
     */
    public function __construct($raisonSociale = null, $societeCommerciale = null, $sIREN = null, $sIRET = null)
    {
        $this
            ->setRaisonSociale($raisonSociale)
            ->setSocieteCommerciale($societeCommerciale)
            ->setSIREN($sIREN)
            ->setSIRET($sIRET);
    }
    /**
     * Get RaisonSociale value
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->RaisonSociale;
    }
    /**
     * Set RaisonSociale value
     * @param string $raisonSociale
     * @return \StructType\PersonneMorale
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        $this->RaisonSociale = $raisonSociale;
        return $this;
    }
    /**
     * Get SocieteCommerciale value
     * @return bool|null
     */
    public function getSocieteCommerciale()
    {
        return $this->SocieteCommerciale;
    }
    /**
     * Set SocieteCommerciale value
     * @param bool $societeCommerciale
     * @return \StructType\PersonneMorale
     */
    public function setSocieteCommerciale($societeCommerciale = null)
    {
        // validation for constraint: boolean
        if (!is_null($societeCommerciale) && !is_bool($societeCommerciale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($societeCommerciale, true), gettype($societeCommerciale)), __LINE__);
        }
        $this->SocieteCommerciale = $societeCommerciale;
        return $this;
    }
    /**
     * Get SIREN value
     * @return string|null
     */
    public function getSIREN()
    {
        return $this->SIREN;
    }
    /**
     * Set SIREN value
     * @param string $sIREN
     * @return \StructType\PersonneMorale
     */
    public function setSIREN($sIREN = null)
    {
        // validation for constraint: string
        if (!is_null($sIREN) && !is_string($sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIREN, true), gettype($sIREN)), __LINE__);
        }
        // validation for constraint: length(9)
        if (!is_null($sIREN) && mb_strlen($sIREN) !== 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 9', mb_strlen($sIREN)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9})
        if (!is_null($sIREN) && !preg_match('/[0-9]{9}/', $sIREN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9}', var_export($sIREN, true)), __LINE__);
        }
        $this->SIREN = $sIREN;
        return $this;
    }
    /**
     * Get SIRET value
     * @return string|null
     */
    public function getSIRET()
    {
        return $this->SIRET;
    }
    /**
     * Set SIRET value
     * @param string $sIRET
     * @return \StructType\PersonneMorale
     */
    public function setSIRET($sIRET = null)
    {
        // validation for constraint: string
        if (!is_null($sIRET) && !is_string($sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIRET, true), gettype($sIRET)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($sIRET) && mb_strlen($sIRET) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: minLength(9)
        if (!is_null($sIRET) && mb_strlen($sIRET) < 9) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 9', mb_strlen($sIRET)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{9,14})
        if (!is_null($sIRET) && !preg_match('/[0-9]{9,14}/', $sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{9,14}', var_export($sIRET, true)), __LINE__);
        }
        $this->SIRET = $sIRET;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PersonneMorale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
