<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExonerationPickUp StructType
 * @subpackage Structs
 */
class ExonerationPickUp extends AbstractStructBase
{
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ExoPickUp;
    /**
     * The Marque
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Marque;
    /**
     * The TypeVariantVersion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeVariantVersion;
    /**
     * The TypeReception
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeReception;
    /**
     * The K_NumRecepCE
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $K_NumRecepCE;
    /**
     * Constructor method for ExonerationPickUp
     * @uses ExonerationPickUp::setExoPickUp()
     * @uses ExonerationPickUp::setMarque()
     * @uses ExonerationPickUp::setTypeVariantVersion()
     * @uses ExonerationPickUp::setTypeReception()
     * @uses ExonerationPickUp::setK_NumRecepCE()
     * @param bool $exoPickUp
     * @param string $marque
     * @param string $typeVariantVersion
     * @param string $typeReception
     * @param string $k_NumRecepCE
     */
    public function __construct($exoPickUp = null, $marque = null, $typeVariantVersion = null, $typeReception = null, $k_NumRecepCE = null)
    {
        $this
            ->setExoPickUp($exoPickUp)
            ->setMarque($marque)
            ->setTypeVariantVersion($typeVariantVersion)
            ->setTypeReception($typeReception)
            ->setK_NumRecepCE($k_NumRecepCE);
    }
    /**
     * Get ExoPickUp value
     * @return bool
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\ExonerationPickUp
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
    /**
     * Get Marque value
     * @return string
     */
    public function getMarque()
    {
        return $this->Marque;
    }
    /**
     * Set Marque value
     * @param string $marque
     * @return \StructType\ExonerationPickUp
     */
    public function setMarque($marque = null)
    {
        // validation for constraint: string
        if (!is_null($marque) && !is_string($marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marque, true), gettype($marque)), __LINE__);
        }
        $this->Marque = $marque;
        return $this;
    }
    /**
     * Get TypeVariantVersion value
     * @return string
     */
    public function getTypeVariantVersion()
    {
        return $this->TypeVariantVersion;
    }
    /**
     * Set TypeVariantVersion value
     * @param string $typeVariantVersion
     * @return \StructType\ExonerationPickUp
     */
    public function setTypeVariantVersion($typeVariantVersion = null)
    {
        // validation for constraint: string
        if (!is_null($typeVariantVersion) && !is_string($typeVariantVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeVariantVersion, true), gettype($typeVariantVersion)), __LINE__);
        }
        $this->TypeVariantVersion = $typeVariantVersion;
        return $this;
    }
    /**
     * Get TypeReception value
     * @return string
     */
    public function getTypeReception()
    {
        return $this->TypeReception;
    }
    /**
     * Set TypeReception value
     * @uses \EnumType\TypeReception::valueIsValid()
     * @uses \EnumType\TypeReception::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeReception
     * @return \StructType\ExonerationPickUp
     */
    public function setTypeReception($typeReception = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeReception::valueIsValid($typeReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeReception', is_array($typeReception) ? implode(', ', $typeReception) : var_export($typeReception, true), implode(', ', \EnumType\TypeReception::getValidValues())), __LINE__);
        }
        $this->TypeReception = $typeReception;
        return $this;
    }
    /**
     * Get K_NumRecepCE value
     * @return string
     */
    public function getK_NumRecepCE()
    {
        return $this->K_NumRecepCE;
    }
    /**
     * Set K_NumRecepCE value
     * @param string $k_NumRecepCE
     * @return \StructType\ExonerationPickUp
     */
    public function setK_NumRecepCE($k_NumRecepCE = null)
    {
        // validation for constraint: string
        if (!is_null($k_NumRecepCE) && !is_string($k_NumRecepCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($k_NumRecepCE, true), gettype($k_NumRecepCE)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($k_NumRecepCE) && mb_strlen($k_NumRecepCE) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($k_NumRecepCE)), __LINE__);
        }
        $this->K_NumRecepCE = $k_NumRecepCE;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExonerationPickUp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
