<?php

namespace EnumType;

/**
 * This class stands for MotifDUP EnumType
 * @subpackage Enumerations
 */
class MotifDUP
{
    /**
     * Constant for value 'VOL'
     * @return string 'VOL'
     */
    const VALUE_VOL = 'VOL';
    /**
     * Constant for value 'PERT'
     * @return string 'PERT'
     */
    const VALUE_PERT = 'PERT';
    /**
     * Constant for value 'DETE'
     * @return string 'DETE'
     */
    const VALUE_DETE = 'DETE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOL
     * @uses self::VALUE_PERT
     * @uses self::VALUE_DETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOL,
            self::VALUE_PERT,
            self::VALUE_DETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
