<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Archiver_Rep StructType
 * @subpackage Structs
 */
class Archiver_Rep extends AbstractStructBase
{
    /**
     * The Fichiers
     * Meta information extracted from the WSDL
     * - choice: Fichiers | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeFichiersList
     */
    public $Fichiers;
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - choice: Fichiers | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - choice: Fichiers | Erreur | Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * Constructor method for Archiver_Rep
     * @uses Archiver_Rep::setFichiers()
     * @uses Archiver_Rep::setErreur()
     * @uses Archiver_Rep::setCode()
     * @param \StructType\TypeFichiersList $fichiers
     * @param string $erreur
     * @param int $code
     */
    public function __construct(\StructType\TypeFichiersList $fichiers = null, $erreur = null, $code = null)
    {
        $this
            ->setFichiers($fichiers)
            ->setErreur($erreur)
            ->setCode($code);
    }
    /**
     * Get Fichiers value
     * @return \StructType\TypeFichiersList
     */
    public function getFichiers()
    {
        return isset($this->Fichiers) ? $this->Fichiers : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFichiers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFichiers method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFichiersForChoiceConstraintsFromSetFichiers($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Erreur',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Fichiers can\'t be set as the property %s is already set. Only one property must be set among these properties: Fichiers, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Fichiers value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TypeFichiersList $fichiers
     * @return \StructType\Archiver_Rep
     */
    public function setFichiers(\StructType\TypeFichiersList $fichiers = null)
    {
        // validation for constraint: choice(Fichiers, Erreur, Code)
        if ('' !== ($fichiersChoiceErrorMessage = self::validateFichiersForChoiceConstraintsFromSetFichiers($fichiers))) {
            throw new \InvalidArgumentException($fichiersChoiceErrorMessage, __LINE__);
        }
        if (is_null($fichiers) || (is_array($fichiers) && empty($fichiers))) {
            unset($this->Fichiers);
        } else {
            $this->Fichiers = $fichiers;
        }
        return $this;
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return isset($this->Erreur) ? $this->Erreur : null;
    }
    /**
     * This method is responsible for validating the value passed to the setErreur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreur method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateErreurForChoiceConstraintsFromSetErreur($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Fichiers',
            'Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Erreur can\'t be set as the property %s is already set. Only one property must be set among these properties: Erreur, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Erreur value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $erreur
     * @return \StructType\Archiver_Rep
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        // validation for constraint: choice(Fichiers, Erreur, Code)
        if ('' !== ($erreurChoiceErrorMessage = self::validateErreurForChoiceConstraintsFromSetErreur($erreur))) {
            throw new \InvalidArgumentException($erreurChoiceErrorMessage, __LINE__);
        }
        if (is_null($erreur) || (is_array($erreur) && empty($erreur))) {
            unset($this->Erreur);
        } else {
            $this->Erreur = $erreur;
        }
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Fichiers',
            'Erreur',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Code can\'t be set as the property %s is already set. Only one property must be set among these properties: Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $code
     * @return \StructType\Archiver_Rep
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: choice(Fichiers, Erreur, Code)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Archiver_Rep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
