<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Assistant ServiceType
 * @subpackage Services
 */
class Assistant extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AssistantImport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssistantImport_Req $assistantImportRepMsg
     * @return \StructType\AssistantImport_Rep|bool
     */
    public function AssistantImport(\StructType\AssistantImport_Req $assistantImportRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->AssistantImport($assistantImportRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AssistantImport_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
