<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeVI StructType
 * @subpackage Structs
 */
class TypeVI extends AbstractStructBase
{
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The D1_Marque
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D1_Marque;
    /**
     * The D2_Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $D2_Version;
    /**
     * The PaysOrigine
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaysOrigine;
    /**
     * The NumImmatOrigine
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NumImmatOrigine;
    /**
     * The DatePremiereImmat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DatePremiereImmat;
    /**
     * The CertifiePresencePJ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CertifiePresencePJ;
    /**
     * The CertifieValiditeCT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CertifieValiditeCT;
    /**
     * The CertifieAbsenceVol
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CertifieAbsenceVol;
    /**
     * The Communautaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Communautaire
     */
    public $Communautaire;
    /**
     * The F1_MMaxTechAdm
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F1_MMaxTechAdm;
    /**
     * The F2_MMaxAdmServ
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $F2_MMaxAdmServ;
    /**
     * The G_MMaxAvecAttelage
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $G_MMaxAvecAttelage;
    /**
     * The G1_PoidsVide
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $G1_PoidsVide;
    /**
     * The J1_Genre
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $J1_Genre;
    /**
     * The J3_Carrosserie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $J3_Carrosserie;
    /**
     * The S1_NbPlaceAssise
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $S1_NbPlaceAssise;
    /**
     * The DateDernierCT
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDernierCT;
    /**
     * The DateEcheanceCT
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateEcheanceCT;
    /**
     * The ResultatDernierCT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultatDernierCT;
    /**
     * The NumeroPVCT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroPVCT;
    /**
     * The AgrementCentreCT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgrementCentreCT;
    /**
     * The Z1_Mention1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Z1_Mention1;
    /**
     * The Z1_Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Z1_Value;
    /**
     * The NbMentions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NbMentions;
    /**
     * The Mentions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Mentions
     */
    public $Mentions;
    /**
     * Constructor method for TypeVI
     * @uses TypeVI::setVIN()
     * @uses TypeVI::setD1_Marque()
     * @uses TypeVI::setD2_Version()
     * @uses TypeVI::setPaysOrigine()
     * @uses TypeVI::setNumImmatOrigine()
     * @uses TypeVI::setDatePremiereImmat()
     * @uses TypeVI::setCertifiePresencePJ()
     * @uses TypeVI::setCertifieValiditeCT()
     * @uses TypeVI::setCertifieAbsenceVol()
     * @uses TypeVI::setCommunautaire()
     * @uses TypeVI::setF1_MMaxTechAdm()
     * @uses TypeVI::setF2_MMaxAdmServ()
     * @uses TypeVI::setG_MMaxAvecAttelage()
     * @uses TypeVI::setG1_PoidsVide()
     * @uses TypeVI::setJ1_Genre()
     * @uses TypeVI::setJ3_Carrosserie()
     * @uses TypeVI::setS1_NbPlaceAssise()
     * @uses TypeVI::setDateDernierCT()
     * @uses TypeVI::setDateEcheanceCT()
     * @uses TypeVI::setResultatDernierCT()
     * @uses TypeVI::setNumeroPVCT()
     * @uses TypeVI::setAgrementCentreCT()
     * @uses TypeVI::setZ1_Mention1()
     * @uses TypeVI::setZ1_Value()
     * @uses TypeVI::setNbMentions()
     * @uses TypeVI::setMentions()
     * @param string $vIN
     * @param string $d1_Marque
     * @param string $d2_Version
     * @param string $paysOrigine
     * @param string $numImmatOrigine
     * @param string $datePremiereImmat
     * @param bool $certifiePresencePJ
     * @param bool $certifieValiditeCT
     * @param bool $certifieAbsenceVol
     * @param \StructType\Communautaire $communautaire
     * @param int $f1_MMaxTechAdm
     * @param int $f2_MMaxAdmServ
     * @param int $g_MMaxAvecAttelage
     * @param int $g1_PoidsVide
     * @param string $j1_Genre
     * @param string $j3_Carrosserie
     * @param int $s1_NbPlaceAssise
     * @param string $dateDernierCT
     * @param string $dateEcheanceCT
     * @param string $resultatDernierCT
     * @param string $numeroPVCT
     * @param string $agrementCentreCT
     * @param string $z1_Mention1
     * @param string $z1_Value
     * @param int $nbMentions
     * @param \StructType\Mentions $mentions
     */
    public function __construct($vIN = null, $d1_Marque = null, $d2_Version = null, $paysOrigine = null, $numImmatOrigine = null, $datePremiereImmat = null, $certifiePresencePJ = null, $certifieValiditeCT = null, $certifieAbsenceVol = null, \StructType\Communautaire $communautaire = null, $f1_MMaxTechAdm = null, $f2_MMaxAdmServ = null, $g_MMaxAvecAttelage = null, $g1_PoidsVide = null, $j1_Genre = null, $j3_Carrosserie = null, $s1_NbPlaceAssise = null, $dateDernierCT = null, $dateEcheanceCT = null, $resultatDernierCT = null, $numeroPVCT = null, $agrementCentreCT = null, $z1_Mention1 = null, $z1_Value = null, $nbMentions = null, \StructType\Mentions $mentions = null)
    {
        $this
            ->setVIN($vIN)
            ->setD1_Marque($d1_Marque)
            ->setD2_Version($d2_Version)
            ->setPaysOrigine($paysOrigine)
            ->setNumImmatOrigine($numImmatOrigine)
            ->setDatePremiereImmat($datePremiereImmat)
            ->setCertifiePresencePJ($certifiePresencePJ)
            ->setCertifieValiditeCT($certifieValiditeCT)
            ->setCertifieAbsenceVol($certifieAbsenceVol)
            ->setCommunautaire($communautaire)
            ->setF1_MMaxTechAdm($f1_MMaxTechAdm)
            ->setF2_MMaxAdmServ($f2_MMaxAdmServ)
            ->setG_MMaxAvecAttelage($g_MMaxAvecAttelage)
            ->setG1_PoidsVide($g1_PoidsVide)
            ->setJ1_Genre($j1_Genre)
            ->setJ3_Carrosserie($j3_Carrosserie)
            ->setS1_NbPlaceAssise($s1_NbPlaceAssise)
            ->setDateDernierCT($dateDernierCT)
            ->setDateEcheanceCT($dateEcheanceCT)
            ->setResultatDernierCT($resultatDernierCT)
            ->setNumeroPVCT($numeroPVCT)
            ->setAgrementCentreCT($agrementCentreCT)
            ->setZ1_Mention1($z1_Mention1)
            ->setZ1_Value($z1_Value)
            ->setNbMentions($nbMentions)
            ->setMentions($mentions);
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\TypeVI
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get D1_Marque value
     * @return string
     */
    public function getD1_Marque()
    {
        return $this->D1_Marque;
    }
    /**
     * Set D1_Marque value
     * @param string $d1_Marque
     * @return \StructType\TypeVI
     */
    public function setD1_Marque($d1_Marque = null)
    {
        // validation for constraint: string
        if (!is_null($d1_Marque) && !is_string($d1_Marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d1_Marque, true), gettype($d1_Marque)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($d1_Marque) && mb_strlen($d1_Marque) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($d1_Marque)), __LINE__);
        }
        $this->D1_Marque = $d1_Marque;
        return $this;
    }
    /**
     * Get D2_Version value
     * @return string
     */
    public function getD2_Version()
    {
        return $this->D2_Version;
    }
    /**
     * Set D2_Version value
     * @param string $d2_Version
     * @return \StructType\TypeVI
     */
    public function setD2_Version($d2_Version = null)
    {
        // validation for constraint: string
        if (!is_null($d2_Version) && !is_string($d2_Version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($d2_Version, true), gettype($d2_Version)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($d2_Version) && mb_strlen($d2_Version) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($d2_Version)), __LINE__);
        }
        $this->D2_Version = $d2_Version;
        return $this;
    }
    /**
     * Get PaysOrigine value
     * @return string
     */
    public function getPaysOrigine()
    {
        return $this->PaysOrigine;
    }
    /**
     * Set PaysOrigine value
     * @param string $paysOrigine
     * @return \StructType\TypeVI
     */
    public function setPaysOrigine($paysOrigine = null)
    {
        // validation for constraint: string
        if (!is_null($paysOrigine) && !is_string($paysOrigine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paysOrigine, true), gettype($paysOrigine)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($paysOrigine) && mb_strlen($paysOrigine) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($paysOrigine)), __LINE__);
        }
        $this->PaysOrigine = $paysOrigine;
        return $this;
    }
    /**
     * Get NumImmatOrigine value
     * @return string
     */
    public function getNumImmatOrigine()
    {
        return $this->NumImmatOrigine;
    }
    /**
     * Set NumImmatOrigine value
     * @param string $numImmatOrigine
     * @return \StructType\TypeVI
     */
    public function setNumImmatOrigine($numImmatOrigine = null)
    {
        // validation for constraint: string
        if (!is_null($numImmatOrigine) && !is_string($numImmatOrigine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numImmatOrigine, true), gettype($numImmatOrigine)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($numImmatOrigine) && mb_strlen($numImmatOrigine) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($numImmatOrigine)), __LINE__);
        }
        $this->NumImmatOrigine = $numImmatOrigine;
        return $this;
    }
    /**
     * Get DatePremiereImmat value
     * @return string
     */
    public function getDatePremiereImmat()
    {
        return $this->DatePremiereImmat;
    }
    /**
     * Set DatePremiereImmat value
     * @param string $datePremiereImmat
     * @return \StructType\TypeVI
     */
    public function setDatePremiereImmat($datePremiereImmat = null)
    {
        // validation for constraint: string
        if (!is_null($datePremiereImmat) && !is_string($datePremiereImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datePremiereImmat, true), gettype($datePremiereImmat)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($datePremiereImmat) && mb_strlen($datePremiereImmat) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($datePremiereImmat)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($datePremiereImmat) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $datePremiereImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($datePremiereImmat, true)), __LINE__);
        }
        $this->DatePremiereImmat = $datePremiereImmat;
        return $this;
    }
    /**
     * Get CertifiePresencePJ value
     * @return bool
     */
    public function getCertifiePresencePJ()
    {
        return $this->CertifiePresencePJ;
    }
    /**
     * Set CertifiePresencePJ value
     * @param bool $certifiePresencePJ
     * @return \StructType\TypeVI
     */
    public function setCertifiePresencePJ($certifiePresencePJ = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifiePresencePJ) && !is_bool($certifiePresencePJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifiePresencePJ, true), gettype($certifiePresencePJ)), __LINE__);
        }
        $this->CertifiePresencePJ = $certifiePresencePJ;
        return $this;
    }
    /**
     * Get CertifieValiditeCT value
     * @return bool
     */
    public function getCertifieValiditeCT()
    {
        return $this->CertifieValiditeCT;
    }
    /**
     * Set CertifieValiditeCT value
     * @param bool $certifieValiditeCT
     * @return \StructType\TypeVI
     */
    public function setCertifieValiditeCT($certifieValiditeCT = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifieValiditeCT) && !is_bool($certifieValiditeCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifieValiditeCT, true), gettype($certifieValiditeCT)), __LINE__);
        }
        $this->CertifieValiditeCT = $certifieValiditeCT;
        return $this;
    }
    /**
     * Get CertifieAbsenceVol value
     * @return bool
     */
    public function getCertifieAbsenceVol()
    {
        return $this->CertifieAbsenceVol;
    }
    /**
     * Set CertifieAbsenceVol value
     * @param bool $certifieAbsenceVol
     * @return \StructType\TypeVI
     */
    public function setCertifieAbsenceVol($certifieAbsenceVol = null)
    {
        // validation for constraint: boolean
        if (!is_null($certifieAbsenceVol) && !is_bool($certifieAbsenceVol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($certifieAbsenceVol, true), gettype($certifieAbsenceVol)), __LINE__);
        }
        $this->CertifieAbsenceVol = $certifieAbsenceVol;
        return $this;
    }
    /**
     * Get Communautaire value
     * @return \StructType\Communautaire
     */
    public function getCommunautaire()
    {
        return $this->Communautaire;
    }
    /**
     * Set Communautaire value
     * @param \StructType\Communautaire $communautaire
     * @return \StructType\TypeVI
     */
    public function setCommunautaire(\StructType\Communautaire $communautaire = null)
    {
        $this->Communautaire = $communautaire;
        return $this;
    }
    /**
     * Get F1_MMaxTechAdm value
     * @return int
     */
    public function getF1_MMaxTechAdm()
    {
        return $this->F1_MMaxTechAdm;
    }
    /**
     * Set F1_MMaxTechAdm value
     * @param int $f1_MMaxTechAdm
     * @return \StructType\TypeVI
     */
    public function setF1_MMaxTechAdm($f1_MMaxTechAdm = null)
    {
        // validation for constraint: int
        if (!is_null($f1_MMaxTechAdm) && !(is_int($f1_MMaxTechAdm) || ctype_digit($f1_MMaxTechAdm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f1_MMaxTechAdm, true), gettype($f1_MMaxTechAdm)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f1_MMaxTechAdm) && mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f1_MMaxTechAdm, true), mb_strlen(preg_replace('/(\D)/', '', $f1_MMaxTechAdm))), __LINE__);
        }
        $this->F1_MMaxTechAdm = $f1_MMaxTechAdm;
        return $this;
    }
    /**
     * Get F2_MMaxAdmServ value
     * @return int
     */
    public function getF2_MMaxAdmServ()
    {
        return $this->F2_MMaxAdmServ;
    }
    /**
     * Set F2_MMaxAdmServ value
     * @param int $f2_MMaxAdmServ
     * @return \StructType\TypeVI
     */
    public function setF2_MMaxAdmServ($f2_MMaxAdmServ = null)
    {
        // validation for constraint: int
        if (!is_null($f2_MMaxAdmServ) && !(is_int($f2_MMaxAdmServ) || ctype_digit($f2_MMaxAdmServ))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($f2_MMaxAdmServ, true), gettype($f2_MMaxAdmServ)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($f2_MMaxAdmServ) && mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($f2_MMaxAdmServ, true), mb_strlen(preg_replace('/(\D)/', '', $f2_MMaxAdmServ))), __LINE__);
        }
        $this->F2_MMaxAdmServ = $f2_MMaxAdmServ;
        return $this;
    }
    /**
     * Get G_MMaxAvecAttelage value
     * @return int
     */
    public function getG_MMaxAvecAttelage()
    {
        return $this->G_MMaxAvecAttelage;
    }
    /**
     * Set G_MMaxAvecAttelage value
     * @param int $g_MMaxAvecAttelage
     * @return \StructType\TypeVI
     */
    public function setG_MMaxAvecAttelage($g_MMaxAvecAttelage = null)
    {
        // validation for constraint: int
        if (!is_null($g_MMaxAvecAttelage) && !(is_int($g_MMaxAvecAttelage) || ctype_digit($g_MMaxAvecAttelage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g_MMaxAvecAttelage, true), gettype($g_MMaxAvecAttelage)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($g_MMaxAvecAttelage) && mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($g_MMaxAvecAttelage, true), mb_strlen(preg_replace('/(\D)/', '', $g_MMaxAvecAttelage))), __LINE__);
        }
        $this->G_MMaxAvecAttelage = $g_MMaxAvecAttelage;
        return $this;
    }
    /**
     * Get G1_PoidsVide value
     * @return int
     */
    public function getG1_PoidsVide()
    {
        return $this->G1_PoidsVide;
    }
    /**
     * Set G1_PoidsVide value
     * @param int $g1_PoidsVide
     * @return \StructType\TypeVI
     */
    public function setG1_PoidsVide($g1_PoidsVide = null)
    {
        // validation for constraint: int
        if (!is_null($g1_PoidsVide) && !(is_int($g1_PoidsVide) || ctype_digit($g1_PoidsVide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($g1_PoidsVide, true), gettype($g1_PoidsVide)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($g1_PoidsVide) && mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($g1_PoidsVide, true), mb_strlen(preg_replace('/(\D)/', '', $g1_PoidsVide))), __LINE__);
        }
        $this->G1_PoidsVide = $g1_PoidsVide;
        return $this;
    }
    /**
     * Get J1_Genre value
     * @return string
     */
    public function getJ1_Genre()
    {
        return $this->J1_Genre;
    }
    /**
     * Set J1_Genre value
     * @param string $j1_Genre
     * @return \StructType\TypeVI
     */
    public function setJ1_Genre($j1_Genre = null)
    {
        // validation for constraint: string
        if (!is_null($j1_Genre) && !is_string($j1_Genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j1_Genre, true), gettype($j1_Genre)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($j1_Genre) && mb_strlen($j1_Genre) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($j1_Genre)), __LINE__);
        }
        $this->J1_Genre = $j1_Genre;
        return $this;
    }
    /**
     * Get J3_Carrosserie value
     * @return string
     */
    public function getJ3_Carrosserie()
    {
        return $this->J3_Carrosserie;
    }
    /**
     * Set J3_Carrosserie value
     * @param string $j3_Carrosserie
     * @return \StructType\TypeVI
     */
    public function setJ3_Carrosserie($j3_Carrosserie = null)
    {
        // validation for constraint: string
        if (!is_null($j3_Carrosserie) && !is_string($j3_Carrosserie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($j3_Carrosserie, true), gettype($j3_Carrosserie)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($j3_Carrosserie) && mb_strlen($j3_Carrosserie) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($j3_Carrosserie)), __LINE__);
        }
        $this->J3_Carrosserie = $j3_Carrosserie;
        return $this;
    }
    /**
     * Get S1_NbPlaceAssise value
     * @return int
     */
    public function getS1_NbPlaceAssise()
    {
        return $this->S1_NbPlaceAssise;
    }
    /**
     * Set S1_NbPlaceAssise value
     * @param int $s1_NbPlaceAssise
     * @return \StructType\TypeVI
     */
    public function setS1_NbPlaceAssise($s1_NbPlaceAssise = null)
    {
        // validation for constraint: int
        if (!is_null($s1_NbPlaceAssise) && !(is_int($s1_NbPlaceAssise) || ctype_digit($s1_NbPlaceAssise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($s1_NbPlaceAssise, true), gettype($s1_NbPlaceAssise)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($s1_NbPlaceAssise) && mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($s1_NbPlaceAssise, true), mb_strlen(preg_replace('/(\D)/', '', $s1_NbPlaceAssise))), __LINE__);
        }
        $this->S1_NbPlaceAssise = $s1_NbPlaceAssise;
        return $this;
    }
    /**
     * Get DateDernierCT value
     * @return string|null
     */
    public function getDateDernierCT()
    {
        return $this->DateDernierCT;
    }
    /**
     * Set DateDernierCT value
     * @param string $dateDernierCT
     * @return \StructType\TypeVI
     */
    public function setDateDernierCT($dateDernierCT = null)
    {
        // validation for constraint: string
        if (!is_null($dateDernierCT) && !is_string($dateDernierCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDernierCT, true), gettype($dateDernierCT)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDernierCT) && mb_strlen($dateDernierCT) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDernierCT)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDernierCT) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDernierCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDernierCT, true)), __LINE__);
        }
        $this->DateDernierCT = $dateDernierCT;
        return $this;
    }
    /**
     * Get DateEcheanceCT value
     * @return string|null
     */
    public function getDateEcheanceCT()
    {
        return $this->DateEcheanceCT;
    }
    /**
     * Set DateEcheanceCT value
     * @param string $dateEcheanceCT
     * @return \StructType\TypeVI
     */
    public function setDateEcheanceCT($dateEcheanceCT = null)
    {
        // validation for constraint: string
        if (!is_null($dateEcheanceCT) && !is_string($dateEcheanceCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEcheanceCT, true), gettype($dateEcheanceCT)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateEcheanceCT) && mb_strlen($dateEcheanceCT) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateEcheanceCT)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateEcheanceCT) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateEcheanceCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateEcheanceCT, true)), __LINE__);
        }
        $this->DateEcheanceCT = $dateEcheanceCT;
        return $this;
    }
    /**
     * Get ResultatDernierCT value
     * @return string|null
     */
    public function getResultatDernierCT()
    {
        return $this->ResultatDernierCT;
    }
    /**
     * Set ResultatDernierCT value
     * @uses \EnumType\ResultatDernierCT::valueIsValid()
     * @uses \EnumType\ResultatDernierCT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultatDernierCT
     * @return \StructType\TypeVI
     */
    public function setResultatDernierCT($resultatDernierCT = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResultatDernierCT::valueIsValid($resultatDernierCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ResultatDernierCT', is_array($resultatDernierCT) ? implode(', ', $resultatDernierCT) : var_export($resultatDernierCT, true), implode(', ', \EnumType\ResultatDernierCT::getValidValues())), __LINE__);
        }
        $this->ResultatDernierCT = $resultatDernierCT;
        return $this;
    }
    /**
     * Get NumeroPVCT value
     * @return string|null
     */
    public function getNumeroPVCT()
    {
        return $this->NumeroPVCT;
    }
    /**
     * Set NumeroPVCT value
     * @param string $numeroPVCT
     * @return \StructType\TypeVI
     */
    public function setNumeroPVCT($numeroPVCT = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPVCT) && !is_string($numeroPVCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPVCT, true), gettype($numeroPVCT)), __LINE__);
        }
        $this->NumeroPVCT = $numeroPVCT;
        return $this;
    }
    /**
     * Get AgrementCentreCT value
     * @return string|null
     */
    public function getAgrementCentreCT()
    {
        return $this->AgrementCentreCT;
    }
    /**
     * Set AgrementCentreCT value
     * @param string $agrementCentreCT
     * @return \StructType\TypeVI
     */
    public function setAgrementCentreCT($agrementCentreCT = null)
    {
        // validation for constraint: string
        if (!is_null($agrementCentreCT) && !is_string($agrementCentreCT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agrementCentreCT, true), gettype($agrementCentreCT)), __LINE__);
        }
        $this->AgrementCentreCT = $agrementCentreCT;
        return $this;
    }
    /**
     * Get Z1_Mention1 value
     * @return string|null
     */
    public function getZ1_Mention1()
    {
        return $this->Z1_Mention1;
    }
    /**
     * Set Z1_Mention1 value
     * @uses \EnumType\Z1_Mention1::valueIsValid()
     * @uses \EnumType\Z1_Mention1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $z1_Mention1
     * @return \StructType\TypeVI
     */
    public function setZ1_Mention1($z1_Mention1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Z1_Mention1::valueIsValid($z1_Mention1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Z1_Mention1', is_array($z1_Mention1) ? implode(', ', $z1_Mention1) : var_export($z1_Mention1, true), implode(', ', \EnumType\Z1_Mention1::getValidValues())), __LINE__);
        }
        $this->Z1_Mention1 = $z1_Mention1;
        return $this;
    }
    /**
     * Get Z1_Value value
     * @return string|null
     */
    public function getZ1_Value()
    {
        return $this->Z1_Value;
    }
    /**
     * Set Z1_Value value
     * @param string $z1_Value
     * @return \StructType\TypeVI
     */
    public function setZ1_Value($z1_Value = null)
    {
        // validation for constraint: string
        if (!is_null($z1_Value) && !is_string($z1_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($z1_Value, true), gettype($z1_Value)), __LINE__);
        }
        $this->Z1_Value = $z1_Value;
        return $this;
    }
    /**
     * Get NbMentions value
     * @return int|null
     */
    public function getNbMentions()
    {
        return $this->NbMentions;
    }
    /**
     * Set NbMentions value
     * @param int $nbMentions
     * @return \StructType\TypeVI
     */
    public function setNbMentions($nbMentions = null)
    {
        // validation for constraint: int
        if (!is_null($nbMentions) && !(is_int($nbMentions) || ctype_digit($nbMentions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbMentions, true), gettype($nbMentions)), __LINE__);
        }
        $this->NbMentions = $nbMentions;
        return $this;
    }
    /**
     * Get Mentions value
     * @return \StructType\Mentions|null
     */
    public function getMentions()
    {
        return $this->Mentions;
    }
    /**
     * Set Mentions value
     * @param \StructType\Mentions $mentions
     * @return \StructType\TypeVI
     */
    public function setMentions(\StructType\Mentions $mentions = null)
    {
        $this->Mentions = $mentions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeVI
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
