<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeInfoVehicule StructType
 * @subpackage Structs
 */
class TypeInfoVehicule extends AbstractStructBase
{
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The Carrosserie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Carrosserie;
    /**
     * The CarrosserieCG
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CarrosserieCG;
    /**
     * The CO2
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CO2;
    /**
     * The ConsoExurb
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $ConsoExurb;
    /**
     * The ConsoMixte
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $ConsoMixte;
    /**
     * The ConsoUrb
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $ConsoUrb;
    /**
     * The Cylindree
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $Cylindree;
    /**
     * The Couleur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Couleur;
    /**
     * The NuanceCouleur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NuanceCouleur;
    /**
     * The DateMec
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateMec;
    /**
     * The DateCG
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCG;
    /**
     * The DateCGPR
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateCGPR;
    /**
     * The Depollution
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 6
     * @var float
     */
    public $Depollution;
    /**
     * The Empatement
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 4
     * @var int
     */
    public $Empatement;
    /**
     * The EmpreinteSol
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 4
     * @var int
     */
    public $EmpreinteSol;
    /**
     * The Energie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Energie;
    /**
     * The Genre
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Genre;
    /**
     * The GenreCG
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GenreCG;
    /**
     * The Hauteur
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 4
     * @var int
     */
    public $Hauteur;
    /**
     * The Largeur
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 4
     * @var int
     */
    public $Largeur;
    /**
     * The Longueur
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 4
     * @var int
     */
    public $Longueur;
    /**
     * The Marque
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Marque;
    /**
     * The MarqueCarrosserie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MarqueCarrosserie;
    /**
     * The ModeInjection
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModeInjection;
    /**
     * The Modele
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Modele;
    /**
     * The ModeleEtude
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModeleEtude;
    /**
     * The ModelePRF
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ModelePRF;
    /**
     * The Mouvement
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Mouvement;
    /**
     * The NSerie
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NSerie;
    /**
     * The NbCylind
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbCylind;
    /**
     * The NbDecibels
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbDecibels;
    /**
     * The NbPlacesAss
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbPlacesAss;
    /**
     * The NbMains
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbMains;
    /**
     * The NbPortes
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbPortes;
    /**
     * The NbSoupapes
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbSoupapes;
    /**
     * The NbVitesses
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbVitesses;
    /**
     * The NbVolumes
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $NbVolumes;
    /**
     * The PoidsVide
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $PoidsVide;
    /**
     * The Propulsion
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Propulsion;
    /**
     * The PTR
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $PTR;
    /**
     * The PuissCh
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $PuissCh;
    /**
     * The PuissFisc
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $PuissFisc;
    /**
     * The RegmDecibels
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 5
     * @var int
     */
    public $RegmDecibels;
    /**
     * The StatutImmat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatutImmat;
    /**
     * The TPBoiteVit
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TPBoiteVit;
    /**
     * The TurboCompr
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TurboCompr;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The TypeVinCG
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeVinCG;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Version;
    /**
     * The VoieAr
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $VoieAr;
    /**
     * The VoieAv
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 1
     * - totalDigits: 3
     * @var int
     */
    public $VoieAv;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 7
     * - minOccurs: 0
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The CodeMoteur
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 14
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeMoteur;
    /**
     * The PtrPrf
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var int
     */
    public $PtrPrf;
    /**
     * The TypeVarVersPrf
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeVarVersPrf;
    /**
     * The Prix
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 11
     * @var float
     */
    public $Prix;
    /**
     * The PuissanceKW
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 8
     * @var int
     */
    public $PuissanceKW;
    /**
     * Constructor method for TypeInfoVehicule
     * @uses TypeInfoVehicule::setVIN()
     * @uses TypeInfoVehicule::setCarrosserie()
     * @uses TypeInfoVehicule::setCarrosserieCG()
     * @uses TypeInfoVehicule::setCO2()
     * @uses TypeInfoVehicule::setConsoExurb()
     * @uses TypeInfoVehicule::setConsoMixte()
     * @uses TypeInfoVehicule::setConsoUrb()
     * @uses TypeInfoVehicule::setCylindree()
     * @uses TypeInfoVehicule::setCouleur()
     * @uses TypeInfoVehicule::setNuanceCouleur()
     * @uses TypeInfoVehicule::setDateMec()
     * @uses TypeInfoVehicule::setDateCG()
     * @uses TypeInfoVehicule::setDateCGPR()
     * @uses TypeInfoVehicule::setDepollution()
     * @uses TypeInfoVehicule::setEmpatement()
     * @uses TypeInfoVehicule::setEmpreinteSol()
     * @uses TypeInfoVehicule::setEnergie()
     * @uses TypeInfoVehicule::setGenre()
     * @uses TypeInfoVehicule::setGenreCG()
     * @uses TypeInfoVehicule::setHauteur()
     * @uses TypeInfoVehicule::setLargeur()
     * @uses TypeInfoVehicule::setLongueur()
     * @uses TypeInfoVehicule::setMarque()
     * @uses TypeInfoVehicule::setMarqueCarrosserie()
     * @uses TypeInfoVehicule::setModeInjection()
     * @uses TypeInfoVehicule::setModele()
     * @uses TypeInfoVehicule::setModeleEtude()
     * @uses TypeInfoVehicule::setModelePRF()
     * @uses TypeInfoVehicule::setMouvement()
     * @uses TypeInfoVehicule::setNSerie()
     * @uses TypeInfoVehicule::setNbCylind()
     * @uses TypeInfoVehicule::setNbDecibels()
     * @uses TypeInfoVehicule::setNbPlacesAss()
     * @uses TypeInfoVehicule::setNbMains()
     * @uses TypeInfoVehicule::setNbPortes()
     * @uses TypeInfoVehicule::setNbSoupapes()
     * @uses TypeInfoVehicule::setNbVitesses()
     * @uses TypeInfoVehicule::setNbVolumes()
     * @uses TypeInfoVehicule::setPoidsVide()
     * @uses TypeInfoVehicule::setPropulsion()
     * @uses TypeInfoVehicule::setPTR()
     * @uses TypeInfoVehicule::setPuissCh()
     * @uses TypeInfoVehicule::setPuissFisc()
     * @uses TypeInfoVehicule::setRegmDecibels()
     * @uses TypeInfoVehicule::setStatutImmat()
     * @uses TypeInfoVehicule::setTPBoiteVit()
     * @uses TypeInfoVehicule::setTurboCompr()
     * @uses TypeInfoVehicule::setType()
     * @uses TypeInfoVehicule::setTypeVinCG()
     * @uses TypeInfoVehicule::setVersion()
     * @uses TypeInfoVehicule::setVoieAr()
     * @uses TypeInfoVehicule::setVoieAv()
     * @uses TypeInfoVehicule::setImmatriculation()
     * @uses TypeInfoVehicule::setCodeMoteur()
     * @uses TypeInfoVehicule::setPtrPrf()
     * @uses TypeInfoVehicule::setTypeVarVersPrf()
     * @uses TypeInfoVehicule::setPrix()
     * @uses TypeInfoVehicule::setPuissanceKW()
     * @param string $vIN
     * @param string $carrosserie
     * @param string $carrosserieCG
     * @param string $cO2
     * @param float $consoExurb
     * @param float $consoMixte
     * @param float $consoUrb
     * @param float $cylindree
     * @param string $couleur
     * @param string $nuanceCouleur
     * @param string $dateMec
     * @param string $dateCG
     * @param string $dateCGPR
     * @param float $depollution
     * @param int $empatement
     * @param int $empreinteSol
     * @param string $energie
     * @param string $genre
     * @param string $genreCG
     * @param int $hauteur
     * @param int $largeur
     * @param int $longueur
     * @param string $marque
     * @param string $marqueCarrosserie
     * @param string $modeInjection
     * @param string $modele
     * @param string $modeleEtude
     * @param string $modelePRF
     * @param string $mouvement
     * @param string $nSerie
     * @param int $nbCylind
     * @param int $nbDecibels
     * @param int $nbPlacesAss
     * @param int $nbMains
     * @param int $nbPortes
     * @param int $nbSoupapes
     * @param int $nbVitesses
     * @param int $nbVolumes
     * @param int $poidsVide
     * @param string $propulsion
     * @param int $pTR
     * @param int $puissCh
     * @param int $puissFisc
     * @param int $regmDecibels
     * @param string $statutImmat
     * @param string $tPBoiteVit
     * @param string $turboCompr
     * @param string $type
     * @param string $typeVinCG
     * @param string $version
     * @param int $voieAr
     * @param int $voieAv
     * @param string $immatriculation
     * @param string $codeMoteur
     * @param int $ptrPrf
     * @param string $typeVarVersPrf
     * @param float $prix
     * @param int $puissanceKW
     */
    public function __construct($vIN = null, $carrosserie = null, $carrosserieCG = null, $cO2 = null, $consoExurb = null, $consoMixte = null, $consoUrb = null, $cylindree = null, $couleur = null, $nuanceCouleur = null, $dateMec = null, $dateCG = null, $dateCGPR = null, $depollution = null, $empatement = null, $empreinteSol = null, $energie = null, $genre = null, $genreCG = null, $hauteur = null, $largeur = null, $longueur = null, $marque = null, $marqueCarrosserie = null, $modeInjection = null, $modele = null, $modeleEtude = null, $modelePRF = null, $mouvement = null, $nSerie = null, $nbCylind = null, $nbDecibels = null, $nbPlacesAss = null, $nbMains = null, $nbPortes = null, $nbSoupapes = null, $nbVitesses = null, $nbVolumes = null, $poidsVide = null, $propulsion = null, $pTR = null, $puissCh = null, $puissFisc = null, $regmDecibels = null, $statutImmat = null, $tPBoiteVit = null, $turboCompr = null, $type = null, $typeVinCG = null, $version = null, $voieAr = null, $voieAv = null, $immatriculation = null, $codeMoteur = null, $ptrPrf = null, $typeVarVersPrf = null, $prix = null, $puissanceKW = null)
    {
        $this
            ->setVIN($vIN)
            ->setCarrosserie($carrosserie)
            ->setCarrosserieCG($carrosserieCG)
            ->setCO2($cO2)
            ->setConsoExurb($consoExurb)
            ->setConsoMixte($consoMixte)
            ->setConsoUrb($consoUrb)
            ->setCylindree($cylindree)
            ->setCouleur($couleur)
            ->setNuanceCouleur($nuanceCouleur)
            ->setDateMec($dateMec)
            ->setDateCG($dateCG)
            ->setDateCGPR($dateCGPR)
            ->setDepollution($depollution)
            ->setEmpatement($empatement)
            ->setEmpreinteSol($empreinteSol)
            ->setEnergie($energie)
            ->setGenre($genre)
            ->setGenreCG($genreCG)
            ->setHauteur($hauteur)
            ->setLargeur($largeur)
            ->setLongueur($longueur)
            ->setMarque($marque)
            ->setMarqueCarrosserie($marqueCarrosserie)
            ->setModeInjection($modeInjection)
            ->setModele($modele)
            ->setModeleEtude($modeleEtude)
            ->setModelePRF($modelePRF)
            ->setMouvement($mouvement)
            ->setNSerie($nSerie)
            ->setNbCylind($nbCylind)
            ->setNbDecibels($nbDecibels)
            ->setNbPlacesAss($nbPlacesAss)
            ->setNbMains($nbMains)
            ->setNbPortes($nbPortes)
            ->setNbSoupapes($nbSoupapes)
            ->setNbVitesses($nbVitesses)
            ->setNbVolumes($nbVolumes)
            ->setPoidsVide($poidsVide)
            ->setPropulsion($propulsion)
            ->setPTR($pTR)
            ->setPuissCh($puissCh)
            ->setPuissFisc($puissFisc)
            ->setRegmDecibels($regmDecibels)
            ->setStatutImmat($statutImmat)
            ->setTPBoiteVit($tPBoiteVit)
            ->setTurboCompr($turboCompr)
            ->setType($type)
            ->setTypeVinCG($typeVinCG)
            ->setVersion($version)
            ->setVoieAr($voieAr)
            ->setVoieAv($voieAv)
            ->setImmatriculation($immatriculation)
            ->setCodeMoteur($codeMoteur)
            ->setPtrPrf($ptrPrf)
            ->setTypeVarVersPrf($typeVarVersPrf)
            ->setPrix($prix)
            ->setPuissanceKW($puissanceKW);
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\TypeInfoVehicule
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get Carrosserie value
     * @return string
     */
    public function getCarrosserie()
    {
        return $this->Carrosserie;
    }
    /**
     * Set Carrosserie value
     * @param string $carrosserie
     * @return \StructType\TypeInfoVehicule
     */
    public function setCarrosserie($carrosserie = null)
    {
        // validation for constraint: string
        if (!is_null($carrosserie) && !is_string($carrosserie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrosserie, true), gettype($carrosserie)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($carrosserie) && mb_strlen($carrosserie) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($carrosserie)), __LINE__);
        }
        $this->Carrosserie = $carrosserie;
        return $this;
    }
    /**
     * Get CarrosserieCG value
     * @return string
     */
    public function getCarrosserieCG()
    {
        return $this->CarrosserieCG;
    }
    /**
     * Set CarrosserieCG value
     * @param string $carrosserieCG
     * @return \StructType\TypeInfoVehicule
     */
    public function setCarrosserieCG($carrosserieCG = null)
    {
        // validation for constraint: string
        if (!is_null($carrosserieCG) && !is_string($carrosserieCG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrosserieCG, true), gettype($carrosserieCG)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($carrosserieCG) && mb_strlen($carrosserieCG) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($carrosserieCG)), __LINE__);
        }
        $this->CarrosserieCG = $carrosserieCG;
        return $this;
    }
    /**
     * Get CO2 value
     * @return string
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param string $cO2
     * @return \StructType\TypeInfoVehicule
     */
    public function setCO2($cO2 = null)
    {
        // validation for constraint: string
        if (!is_null($cO2) && !is_string($cO2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cO2, true), gettype($cO2)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($cO2) && mb_strlen($cO2) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($cO2)), __LINE__);
        }
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get ConsoExurb value
     * @return float
     */
    public function getConsoExurb()
    {
        return $this->ConsoExurb;
    }
    /**
     * Set ConsoExurb value
     * @param float $consoExurb
     * @return \StructType\TypeInfoVehicule
     */
    public function setConsoExurb($consoExurb = null)
    {
        // validation for constraint: float
        if (!is_null($consoExurb) && !(is_float($consoExurb) || is_numeric($consoExurb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consoExurb, true), gettype($consoExurb)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($consoExurb) && mb_strlen(mb_substr($consoExurb, mb_strpos($consoExurb, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($consoExurb, true), mb_strlen(mb_substr($consoExurb, mb_strpos($consoExurb, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($consoExurb) && mb_strlen(preg_replace('/(\D)/', '', $consoExurb)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($consoExurb, true), mb_strlen(preg_replace('/(\D)/', '', $consoExurb))), __LINE__);
        }
        $this->ConsoExurb = $consoExurb;
        return $this;
    }
    /**
     * Get ConsoMixte value
     * @return float
     */
    public function getConsoMixte()
    {
        return $this->ConsoMixte;
    }
    /**
     * Set ConsoMixte value
     * @param float $consoMixte
     * @return \StructType\TypeInfoVehicule
     */
    public function setConsoMixte($consoMixte = null)
    {
        // validation for constraint: float
        if (!is_null($consoMixte) && !(is_float($consoMixte) || is_numeric($consoMixte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consoMixte, true), gettype($consoMixte)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($consoMixte) && mb_strlen(mb_substr($consoMixte, mb_strpos($consoMixte, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($consoMixte, true), mb_strlen(mb_substr($consoMixte, mb_strpos($consoMixte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($consoMixte) && mb_strlen(preg_replace('/(\D)/', '', $consoMixte)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($consoMixte, true), mb_strlen(preg_replace('/(\D)/', '', $consoMixte))), __LINE__);
        }
        $this->ConsoMixte = $consoMixte;
        return $this;
    }
    /**
     * Get ConsoUrb value
     * @return float
     */
    public function getConsoUrb()
    {
        return $this->ConsoUrb;
    }
    /**
     * Set ConsoUrb value
     * @param float $consoUrb
     * @return \StructType\TypeInfoVehicule
     */
    public function setConsoUrb($consoUrb = null)
    {
        // validation for constraint: float
        if (!is_null($consoUrb) && !(is_float($consoUrb) || is_numeric($consoUrb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consoUrb, true), gettype($consoUrb)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($consoUrb) && mb_strlen(mb_substr($consoUrb, mb_strpos($consoUrb, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($consoUrb, true), mb_strlen(mb_substr($consoUrb, mb_strpos($consoUrb, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($consoUrb) && mb_strlen(preg_replace('/(\D)/', '', $consoUrb)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($consoUrb, true), mb_strlen(preg_replace('/(\D)/', '', $consoUrb))), __LINE__);
        }
        $this->ConsoUrb = $consoUrb;
        return $this;
    }
    /**
     * Get Cylindree value
     * @return float
     */
    public function getCylindree()
    {
        return $this->Cylindree;
    }
    /**
     * Set Cylindree value
     * @param float $cylindree
     * @return \StructType\TypeInfoVehicule
     */
    public function setCylindree($cylindree = null)
    {
        // validation for constraint: float
        if (!is_null($cylindree) && !(is_float($cylindree) || is_numeric($cylindree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cylindree, true), gettype($cylindree)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($cylindree) && mb_strlen(mb_substr($cylindree, mb_strpos($cylindree, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($cylindree, true), mb_strlen(mb_substr($cylindree, mb_strpos($cylindree, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($cylindree) && mb_strlen(preg_replace('/(\D)/', '', $cylindree)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($cylindree, true), mb_strlen(preg_replace('/(\D)/', '', $cylindree))), __LINE__);
        }
        $this->Cylindree = $cylindree;
        return $this;
    }
    /**
     * Get Couleur value
     * @return string
     */
    public function getCouleur()
    {
        return $this->Couleur;
    }
    /**
     * Set Couleur value
     * @param string $couleur
     * @return \StructType\TypeInfoVehicule
     */
    public function setCouleur($couleur = null)
    {
        // validation for constraint: string
        if (!is_null($couleur) && !is_string($couleur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couleur, true), gettype($couleur)), __LINE__);
        }
        $this->Couleur = $couleur;
        return $this;
    }
    /**
     * Get NuanceCouleur value
     * @return string
     */
    public function getNuanceCouleur()
    {
        return $this->NuanceCouleur;
    }
    /**
     * Set NuanceCouleur value
     * @param string $nuanceCouleur
     * @return \StructType\TypeInfoVehicule
     */
    public function setNuanceCouleur($nuanceCouleur = null)
    {
        // validation for constraint: string
        if (!is_null($nuanceCouleur) && !is_string($nuanceCouleur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nuanceCouleur, true), gettype($nuanceCouleur)), __LINE__);
        }
        $this->NuanceCouleur = $nuanceCouleur;
        return $this;
    }
    /**
     * Get DateMec value
     * @return string
     */
    public function getDateMec()
    {
        return $this->DateMec;
    }
    /**
     * Set DateMec value
     * @param string $dateMec
     * @return \StructType\TypeInfoVehicule
     */
    public function setDateMec($dateMec = null)
    {
        // validation for constraint: string
        if (!is_null($dateMec) && !is_string($dateMec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMec, true), gettype($dateMec)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateMec) && mb_strlen($dateMec) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateMec)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateMec) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateMec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateMec, true)), __LINE__);
        }
        $this->DateMec = $dateMec;
        return $this;
    }
    /**
     * Get DateCG value
     * @return string
     */
    public function getDateCG()
    {
        return $this->DateCG;
    }
    /**
     * Set DateCG value
     * @param string $dateCG
     * @return \StructType\TypeInfoVehicule
     */
    public function setDateCG($dateCG = null)
    {
        // validation for constraint: string
        if (!is_null($dateCG) && !is_string($dateCG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCG, true), gettype($dateCG)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCG) && mb_strlen($dateCG) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCG)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCG) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCG, true)), __LINE__);
        }
        $this->DateCG = $dateCG;
        return $this;
    }
    /**
     * Get DateCGPR value
     * @return string
     */
    public function getDateCGPR()
    {
        return $this->DateCGPR;
    }
    /**
     * Set DateCGPR value
     * @param string $dateCGPR
     * @return \StructType\TypeInfoVehicule
     */
    public function setDateCGPR($dateCGPR = null)
    {
        // validation for constraint: string
        if (!is_null($dateCGPR) && !is_string($dateCGPR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateCGPR, true), gettype($dateCGPR)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateCGPR) && mb_strlen($dateCGPR) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateCGPR)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateCGPR) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateCGPR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateCGPR, true)), __LINE__);
        }
        $this->DateCGPR = $dateCGPR;
        return $this;
    }
    /**
     * Get Depollution value
     * @return float
     */
    public function getDepollution()
    {
        return $this->Depollution;
    }
    /**
     * Set Depollution value
     * @param float $depollution
     * @return \StructType\TypeInfoVehicule
     */
    public function setDepollution($depollution = null)
    {
        // validation for constraint: float
        if (!is_null($depollution) && !(is_float($depollution) || is_numeric($depollution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depollution, true), gettype($depollution)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($depollution) && mb_strlen(mb_substr($depollution, mb_strpos($depollution, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($depollution, true), mb_strlen(mb_substr($depollution, mb_strpos($depollution, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($depollution) && mb_strlen(preg_replace('/(\D)/', '', $depollution)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($depollution, true), mb_strlen(preg_replace('/(\D)/', '', $depollution))), __LINE__);
        }
        $this->Depollution = $depollution;
        return $this;
    }
    /**
     * Get Empatement value
     * @return int
     */
    public function getEmpatement()
    {
        return $this->Empatement;
    }
    /**
     * Set Empatement value
     * @param int $empatement
     * @return \StructType\TypeInfoVehicule
     */
    public function setEmpatement($empatement = null)
    {
        // validation for constraint: int
        if (!is_null($empatement) && !(is_int($empatement) || ctype_digit($empatement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($empatement, true), gettype($empatement)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($empatement) && mb_strlen(preg_replace('/(\D)/', '', $empatement)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($empatement, true), mb_strlen(preg_replace('/(\D)/', '', $empatement))), __LINE__);
        }
        $this->Empatement = $empatement;
        return $this;
    }
    /**
     * Get EmpreinteSol value
     * @return int
     */
    public function getEmpreinteSol()
    {
        return $this->EmpreinteSol;
    }
    /**
     * Set EmpreinteSol value
     * @param int $empreinteSol
     * @return \StructType\TypeInfoVehicule
     */
    public function setEmpreinteSol($empreinteSol = null)
    {
        // validation for constraint: int
        if (!is_null($empreinteSol) && !(is_int($empreinteSol) || ctype_digit($empreinteSol))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($empreinteSol, true), gettype($empreinteSol)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($empreinteSol) && mb_strlen(preg_replace('/(\D)/', '', $empreinteSol)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($empreinteSol, true), mb_strlen(preg_replace('/(\D)/', '', $empreinteSol))), __LINE__);
        }
        $this->EmpreinteSol = $empreinteSol;
        return $this;
    }
    /**
     * Get Energie value
     * @return string
     */
    public function getEnergie()
    {
        return $this->Energie;
    }
    /**
     * Set Energie value
     * @param string $energie
     * @return \StructType\TypeInfoVehicule
     */
    public function setEnergie($energie = null)
    {
        // validation for constraint: string
        if (!is_null($energie) && !is_string($energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($energie, true), gettype($energie)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($energie) && mb_strlen($energie) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($energie)), __LINE__);
        }
        $this->Energie = $energie;
        return $this;
    }
    /**
     * Get Genre value
     * @return string
     */
    public function getGenre()
    {
        return $this->Genre;
    }
    /**
     * Set Genre value
     * @param string $genre
     * @return \StructType\TypeInfoVehicule
     */
    public function setGenre($genre = null)
    {
        // validation for constraint: string
        if (!is_null($genre) && !is_string($genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genre, true), gettype($genre)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($genre) && mb_strlen($genre) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($genre)), __LINE__);
        }
        $this->Genre = $genre;
        return $this;
    }
    /**
     * Get GenreCG value
     * @return string
     */
    public function getGenreCG()
    {
        return $this->GenreCG;
    }
    /**
     * Set GenreCG value
     * @param string $genreCG
     * @return \StructType\TypeInfoVehicule
     */
    public function setGenreCG($genreCG = null)
    {
        // validation for constraint: string
        if (!is_null($genreCG) && !is_string($genreCG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreCG, true), gettype($genreCG)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($genreCG) && mb_strlen($genreCG) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($genreCG)), __LINE__);
        }
        $this->GenreCG = $genreCG;
        return $this;
    }
    /**
     * Get Hauteur value
     * @return int
     */
    public function getHauteur()
    {
        return $this->Hauteur;
    }
    /**
     * Set Hauteur value
     * @param int $hauteur
     * @return \StructType\TypeInfoVehicule
     */
    public function setHauteur($hauteur = null)
    {
        // validation for constraint: int
        if (!is_null($hauteur) && !(is_int($hauteur) || ctype_digit($hauteur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hauteur, true), gettype($hauteur)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($hauteur) && mb_strlen(preg_replace('/(\D)/', '', $hauteur)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($hauteur, true), mb_strlen(preg_replace('/(\D)/', '', $hauteur))), __LINE__);
        }
        $this->Hauteur = $hauteur;
        return $this;
    }
    /**
     * Get Largeur value
     * @return int
     */
    public function getLargeur()
    {
        return $this->Largeur;
    }
    /**
     * Set Largeur value
     * @param int $largeur
     * @return \StructType\TypeInfoVehicule
     */
    public function setLargeur($largeur = null)
    {
        // validation for constraint: int
        if (!is_null($largeur) && !(is_int($largeur) || ctype_digit($largeur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largeur, true), gettype($largeur)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($largeur) && mb_strlen(preg_replace('/(\D)/', '', $largeur)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($largeur, true), mb_strlen(preg_replace('/(\D)/', '', $largeur))), __LINE__);
        }
        $this->Largeur = $largeur;
        return $this;
    }
    /**
     * Get Longueur value
     * @return int
     */
    public function getLongueur()
    {
        return $this->Longueur;
    }
    /**
     * Set Longueur value
     * @param int $longueur
     * @return \StructType\TypeInfoVehicule
     */
    public function setLongueur($longueur = null)
    {
        // validation for constraint: int
        if (!is_null($longueur) && !(is_int($longueur) || ctype_digit($longueur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($longueur, true), gettype($longueur)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($longueur) && mb_strlen(preg_replace('/(\D)/', '', $longueur)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($longueur, true), mb_strlen(preg_replace('/(\D)/', '', $longueur))), __LINE__);
        }
        $this->Longueur = $longueur;
        return $this;
    }
    /**
     * Get Marque value
     * @return string
     */
    public function getMarque()
    {
        return $this->Marque;
    }
    /**
     * Set Marque value
     * @param string $marque
     * @return \StructType\TypeInfoVehicule
     */
    public function setMarque($marque = null)
    {
        // validation for constraint: string
        if (!is_null($marque) && !is_string($marque)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marque, true), gettype($marque)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($marque) && mb_strlen($marque) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($marque)), __LINE__);
        }
        $this->Marque = $marque;
        return $this;
    }
    /**
     * Get MarqueCarrosserie value
     * @return string
     */
    public function getMarqueCarrosserie()
    {
        return $this->MarqueCarrosserie;
    }
    /**
     * Set MarqueCarrosserie value
     * @param string $marqueCarrosserie
     * @return \StructType\TypeInfoVehicule
     */
    public function setMarqueCarrosserie($marqueCarrosserie = null)
    {
        // validation for constraint: string
        if (!is_null($marqueCarrosserie) && !is_string($marqueCarrosserie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marqueCarrosserie, true), gettype($marqueCarrosserie)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($marqueCarrosserie) && mb_strlen($marqueCarrosserie) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($marqueCarrosserie)), __LINE__);
        }
        $this->MarqueCarrosserie = $marqueCarrosserie;
        return $this;
    }
    /**
     * Get ModeInjection value
     * @return string
     */
    public function getModeInjection()
    {
        return $this->ModeInjection;
    }
    /**
     * Set ModeInjection value
     * @param string $modeInjection
     * @return \StructType\TypeInfoVehicule
     */
    public function setModeInjection($modeInjection = null)
    {
        // validation for constraint: string
        if (!is_null($modeInjection) && !is_string($modeInjection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeInjection, true), gettype($modeInjection)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($modeInjection) && mb_strlen($modeInjection) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($modeInjection)), __LINE__);
        }
        $this->ModeInjection = $modeInjection;
        return $this;
    }
    /**
     * Get Modele value
     * @return string
     */
    public function getModele()
    {
        return $this->Modele;
    }
    /**
     * Set Modele value
     * @param string $modele
     * @return \StructType\TypeInfoVehicule
     */
    public function setModele($modele = null)
    {
        // validation for constraint: string
        if (!is_null($modele) && !is_string($modele)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modele, true), gettype($modele)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($modele) && mb_strlen($modele) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($modele)), __LINE__);
        }
        $this->Modele = $modele;
        return $this;
    }
    /**
     * Get ModeleEtude value
     * @return string
     */
    public function getModeleEtude()
    {
        return $this->ModeleEtude;
    }
    /**
     * Set ModeleEtude value
     * @param string $modeleEtude
     * @return \StructType\TypeInfoVehicule
     */
    public function setModeleEtude($modeleEtude = null)
    {
        // validation for constraint: string
        if (!is_null($modeleEtude) && !is_string($modeleEtude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeleEtude, true), gettype($modeleEtude)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($modeleEtude) && mb_strlen($modeleEtude) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($modeleEtude)), __LINE__);
        }
        $this->ModeleEtude = $modeleEtude;
        return $this;
    }
    /**
     * Get ModelePRF value
     * @return string
     */
    public function getModelePRF()
    {
        return $this->ModelePRF;
    }
    /**
     * Set ModelePRF value
     * @param string $modelePRF
     * @return \StructType\TypeInfoVehicule
     */
    public function setModelePRF($modelePRF = null)
    {
        // validation for constraint: string
        if (!is_null($modelePRF) && !is_string($modelePRF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelePRF, true), gettype($modelePRF)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($modelePRF) && mb_strlen($modelePRF) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($modelePRF)), __LINE__);
        }
        $this->ModelePRF = $modelePRF;
        return $this;
    }
    /**
     * Get Mouvement value
     * @return string
     */
    public function getMouvement()
    {
        return $this->Mouvement;
    }
    /**
     * Set Mouvement value
     * @param string $mouvement
     * @return \StructType\TypeInfoVehicule
     */
    public function setMouvement($mouvement = null)
    {
        // validation for constraint: string
        if (!is_null($mouvement) && !is_string($mouvement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mouvement, true), gettype($mouvement)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($mouvement) && mb_strlen($mouvement) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($mouvement)), __LINE__);
        }
        $this->Mouvement = $mouvement;
        return $this;
    }
    /**
     * Get NSerie value
     * @return string
     */
    public function getNSerie()
    {
        return $this->NSerie;
    }
    /**
     * Set NSerie value
     * @param string $nSerie
     * @return \StructType\TypeInfoVehicule
     */
    public function setNSerie($nSerie = null)
    {
        // validation for constraint: string
        if (!is_null($nSerie) && !is_string($nSerie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nSerie, true), gettype($nSerie)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($nSerie) && mb_strlen($nSerie) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($nSerie)), __LINE__);
        }
        $this->NSerie = $nSerie;
        return $this;
    }
    /**
     * Get NbCylind value
     * @return int
     */
    public function getNbCylind()
    {
        return $this->NbCylind;
    }
    /**
     * Set NbCylind value
     * @param int $nbCylind
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbCylind($nbCylind = null)
    {
        // validation for constraint: int
        if (!is_null($nbCylind) && !(is_int($nbCylind) || ctype_digit($nbCylind))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbCylind, true), gettype($nbCylind)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbCylind) && mb_strlen(preg_replace('/(\D)/', '', $nbCylind)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbCylind, true), mb_strlen(preg_replace('/(\D)/', '', $nbCylind))), __LINE__);
        }
        $this->NbCylind = $nbCylind;
        return $this;
    }
    /**
     * Get NbDecibels value
     * @return int
     */
    public function getNbDecibels()
    {
        return $this->NbDecibels;
    }
    /**
     * Set NbDecibels value
     * @param int $nbDecibels
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbDecibels($nbDecibels = null)
    {
        // validation for constraint: int
        if (!is_null($nbDecibels) && !(is_int($nbDecibels) || ctype_digit($nbDecibels))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbDecibels, true), gettype($nbDecibels)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbDecibels) && mb_strlen(preg_replace('/(\D)/', '', $nbDecibels)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbDecibels, true), mb_strlen(preg_replace('/(\D)/', '', $nbDecibels))), __LINE__);
        }
        $this->NbDecibels = $nbDecibels;
        return $this;
    }
    /**
     * Get NbPlacesAss value
     * @return int
     */
    public function getNbPlacesAss()
    {
        return $this->NbPlacesAss;
    }
    /**
     * Set NbPlacesAss value
     * @param int $nbPlacesAss
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbPlacesAss($nbPlacesAss = null)
    {
        // validation for constraint: int
        if (!is_null($nbPlacesAss) && !(is_int($nbPlacesAss) || ctype_digit($nbPlacesAss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPlacesAss, true), gettype($nbPlacesAss)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbPlacesAss) && mb_strlen(preg_replace('/(\D)/', '', $nbPlacesAss)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbPlacesAss, true), mb_strlen(preg_replace('/(\D)/', '', $nbPlacesAss))), __LINE__);
        }
        $this->NbPlacesAss = $nbPlacesAss;
        return $this;
    }
    /**
     * Get NbMains value
     * @return int
     */
    public function getNbMains()
    {
        return $this->NbMains;
    }
    /**
     * Set NbMains value
     * @param int $nbMains
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbMains($nbMains = null)
    {
        // validation for constraint: int
        if (!is_null($nbMains) && !(is_int($nbMains) || ctype_digit($nbMains))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbMains, true), gettype($nbMains)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbMains) && mb_strlen(preg_replace('/(\D)/', '', $nbMains)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbMains, true), mb_strlen(preg_replace('/(\D)/', '', $nbMains))), __LINE__);
        }
        $this->NbMains = $nbMains;
        return $this;
    }
    /**
     * Get NbPortes value
     * @return int
     */
    public function getNbPortes()
    {
        return $this->NbPortes;
    }
    /**
     * Set NbPortes value
     * @param int $nbPortes
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbPortes($nbPortes = null)
    {
        // validation for constraint: int
        if (!is_null($nbPortes) && !(is_int($nbPortes) || ctype_digit($nbPortes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPortes, true), gettype($nbPortes)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbPortes) && mb_strlen(preg_replace('/(\D)/', '', $nbPortes)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbPortes, true), mb_strlen(preg_replace('/(\D)/', '', $nbPortes))), __LINE__);
        }
        $this->NbPortes = $nbPortes;
        return $this;
    }
    /**
     * Get NbSoupapes value
     * @return int
     */
    public function getNbSoupapes()
    {
        return $this->NbSoupapes;
    }
    /**
     * Set NbSoupapes value
     * @param int $nbSoupapes
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbSoupapes($nbSoupapes = null)
    {
        // validation for constraint: int
        if (!is_null($nbSoupapes) && !(is_int($nbSoupapes) || ctype_digit($nbSoupapes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbSoupapes, true), gettype($nbSoupapes)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbSoupapes) && mb_strlen(preg_replace('/(\D)/', '', $nbSoupapes)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbSoupapes, true), mb_strlen(preg_replace('/(\D)/', '', $nbSoupapes))), __LINE__);
        }
        $this->NbSoupapes = $nbSoupapes;
        return $this;
    }
    /**
     * Get NbVitesses value
     * @return int
     */
    public function getNbVitesses()
    {
        return $this->NbVitesses;
    }
    /**
     * Set NbVitesses value
     * @param int $nbVitesses
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbVitesses($nbVitesses = null)
    {
        // validation for constraint: int
        if (!is_null($nbVitesses) && !(is_int($nbVitesses) || ctype_digit($nbVitesses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbVitesses, true), gettype($nbVitesses)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbVitesses) && mb_strlen(preg_replace('/(\D)/', '', $nbVitesses)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbVitesses, true), mb_strlen(preg_replace('/(\D)/', '', $nbVitesses))), __LINE__);
        }
        $this->NbVitesses = $nbVitesses;
        return $this;
    }
    /**
     * Get NbVolumes value
     * @return int
     */
    public function getNbVolumes()
    {
        return $this->NbVolumes;
    }
    /**
     * Set NbVolumes value
     * @param int $nbVolumes
     * @return \StructType\TypeInfoVehicule
     */
    public function setNbVolumes($nbVolumes = null)
    {
        // validation for constraint: int
        if (!is_null($nbVolumes) && !(is_int($nbVolumes) || ctype_digit($nbVolumes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbVolumes, true), gettype($nbVolumes)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($nbVolumes) && mb_strlen(preg_replace('/(\D)/', '', $nbVolumes)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($nbVolumes, true), mb_strlen(preg_replace('/(\D)/', '', $nbVolumes))), __LINE__);
        }
        $this->NbVolumes = $nbVolumes;
        return $this;
    }
    /**
     * Get PoidsVide value
     * @return int
     */
    public function getPoidsVide()
    {
        return $this->PoidsVide;
    }
    /**
     * Set PoidsVide value
     * @param int $poidsVide
     * @return \StructType\TypeInfoVehicule
     */
    public function setPoidsVide($poidsVide = null)
    {
        // validation for constraint: int
        if (!is_null($poidsVide) && !(is_int($poidsVide) || ctype_digit($poidsVide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poidsVide, true), gettype($poidsVide)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($poidsVide) && mb_strlen(preg_replace('/(\D)/', '', $poidsVide)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($poidsVide, true), mb_strlen(preg_replace('/(\D)/', '', $poidsVide))), __LINE__);
        }
        $this->PoidsVide = $poidsVide;
        return $this;
    }
    /**
     * Get Propulsion value
     * @return string
     */
    public function getPropulsion()
    {
        return $this->Propulsion;
    }
    /**
     * Set Propulsion value
     * @param string $propulsion
     * @return \StructType\TypeInfoVehicule
     */
    public function setPropulsion($propulsion = null)
    {
        // validation for constraint: string
        if (!is_null($propulsion) && !is_string($propulsion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propulsion, true), gettype($propulsion)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($propulsion) && mb_strlen($propulsion) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($propulsion)), __LINE__);
        }
        $this->Propulsion = $propulsion;
        return $this;
    }
    /**
     * Get PTR value
     * @return int
     */
    public function getPTR()
    {
        return $this->PTR;
    }
    /**
     * Set PTR value
     * @param int $pTR
     * @return \StructType\TypeInfoVehicule
     */
    public function setPTR($pTR = null)
    {
        // validation for constraint: int
        if (!is_null($pTR) && !(is_int($pTR) || ctype_digit($pTR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pTR, true), gettype($pTR)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($pTR) && mb_strlen(preg_replace('/(\D)/', '', $pTR)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($pTR, true), mb_strlen(preg_replace('/(\D)/', '', $pTR))), __LINE__);
        }
        $this->PTR = $pTR;
        return $this;
    }
    /**
     * Get PuissCh value
     * @return int
     */
    public function getPuissCh()
    {
        return $this->PuissCh;
    }
    /**
     * Set PuissCh value
     * @param int $puissCh
     * @return \StructType\TypeInfoVehicule
     */
    public function setPuissCh($puissCh = null)
    {
        // validation for constraint: int
        if (!is_null($puissCh) && !(is_int($puissCh) || ctype_digit($puissCh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissCh, true), gettype($puissCh)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($puissCh) && mb_strlen(preg_replace('/(\D)/', '', $puissCh)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($puissCh, true), mb_strlen(preg_replace('/(\D)/', '', $puissCh))), __LINE__);
        }
        $this->PuissCh = $puissCh;
        return $this;
    }
    /**
     * Get PuissFisc value
     * @return int
     */
    public function getPuissFisc()
    {
        return $this->PuissFisc;
    }
    /**
     * Set PuissFisc value
     * @param int $puissFisc
     * @return \StructType\TypeInfoVehicule
     */
    public function setPuissFisc($puissFisc = null)
    {
        // validation for constraint: int
        if (!is_null($puissFisc) && !(is_int($puissFisc) || ctype_digit($puissFisc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissFisc, true), gettype($puissFisc)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($puissFisc) && mb_strlen(preg_replace('/(\D)/', '', $puissFisc)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($puissFisc, true), mb_strlen(preg_replace('/(\D)/', '', $puissFisc))), __LINE__);
        }
        $this->PuissFisc = $puissFisc;
        return $this;
    }
    /**
     * Get RegmDecibels value
     * @return int
     */
    public function getRegmDecibels()
    {
        return $this->RegmDecibels;
    }
    /**
     * Set RegmDecibels value
     * @param int $regmDecibels
     * @return \StructType\TypeInfoVehicule
     */
    public function setRegmDecibels($regmDecibels = null)
    {
        // validation for constraint: int
        if (!is_null($regmDecibels) && !(is_int($regmDecibels) || ctype_digit($regmDecibels))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regmDecibels, true), gettype($regmDecibels)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($regmDecibels) && mb_strlen(preg_replace('/(\D)/', '', $regmDecibels)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($regmDecibels, true), mb_strlen(preg_replace('/(\D)/', '', $regmDecibels))), __LINE__);
        }
        $this->RegmDecibels = $regmDecibels;
        return $this;
    }
    /**
     * Get StatutImmat value
     * @return string
     */
    public function getStatutImmat()
    {
        return $this->StatutImmat;
    }
    /**
     * Set StatutImmat value
     * @param string $statutImmat
     * @return \StructType\TypeInfoVehicule
     */
    public function setStatutImmat($statutImmat = null)
    {
        // validation for constraint: string
        if (!is_null($statutImmat) && !is_string($statutImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statutImmat, true), gettype($statutImmat)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($statutImmat) && mb_strlen($statutImmat) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($statutImmat)), __LINE__);
        }
        $this->StatutImmat = $statutImmat;
        return $this;
    }
    /**
     * Get TPBoiteVit value
     * @return string
     */
    public function getTPBoiteVit()
    {
        return $this->TPBoiteVit;
    }
    /**
     * Set TPBoiteVit value
     * @param string $tPBoiteVit
     * @return \StructType\TypeInfoVehicule
     */
    public function setTPBoiteVit($tPBoiteVit = null)
    {
        // validation for constraint: string
        if (!is_null($tPBoiteVit) && !is_string($tPBoiteVit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tPBoiteVit, true), gettype($tPBoiteVit)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tPBoiteVit) && mb_strlen($tPBoiteVit) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tPBoiteVit)), __LINE__);
        }
        $this->TPBoiteVit = $tPBoiteVit;
        return $this;
    }
    /**
     * Get TurboCompr value
     * @return string
     */
    public function getTurboCompr()
    {
        return $this->TurboCompr;
    }
    /**
     * Set TurboCompr value
     * @param string $turboCompr
     * @return \StructType\TypeInfoVehicule
     */
    public function setTurboCompr($turboCompr = null)
    {
        // validation for constraint: string
        if (!is_null($turboCompr) && !is_string($turboCompr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turboCompr, true), gettype($turboCompr)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($turboCompr) && mb_strlen($turboCompr) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($turboCompr)), __LINE__);
        }
        $this->TurboCompr = $turboCompr;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\TypeInfoVehicule
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($type) && mb_strlen($type) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeVinCG value
     * @return string
     */
    public function getTypeVinCG()
    {
        return $this->TypeVinCG;
    }
    /**
     * Set TypeVinCG value
     * @param string $typeVinCG
     * @return \StructType\TypeInfoVehicule
     */
    public function setTypeVinCG($typeVinCG = null)
    {
        // validation for constraint: string
        if (!is_null($typeVinCG) && !is_string($typeVinCG)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeVinCG, true), gettype($typeVinCG)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($typeVinCG) && mb_strlen($typeVinCG) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($typeVinCG)), __LINE__);
        }
        $this->TypeVinCG = $typeVinCG;
        return $this;
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\TypeInfoVehicule
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($version) && mb_strlen($version) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get VoieAr value
     * @return int
     */
    public function getVoieAr()
    {
        return $this->VoieAr;
    }
    /**
     * Set VoieAr value
     * @param int $voieAr
     * @return \StructType\TypeInfoVehicule
     */
    public function setVoieAr($voieAr = null)
    {
        // validation for constraint: int
        if (!is_null($voieAr) && !(is_int($voieAr) || ctype_digit($voieAr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voieAr, true), gettype($voieAr)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($voieAr) && mb_strlen(preg_replace('/(\D)/', '', $voieAr)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($voieAr, true), mb_strlen(preg_replace('/(\D)/', '', $voieAr))), __LINE__);
        }
        $this->VoieAr = $voieAr;
        return $this;
    }
    /**
     * Get VoieAv value
     * @return int
     */
    public function getVoieAv()
    {
        return $this->VoieAv;
    }
    /**
     * Set VoieAv value
     * @param int $voieAv
     * @return \StructType\TypeInfoVehicule
     */
    public function setVoieAv($voieAv = null)
    {
        // validation for constraint: int
        if (!is_null($voieAv) && !(is_int($voieAv) || ctype_digit($voieAv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voieAv, true), gettype($voieAv)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($voieAv) && mb_strlen(preg_replace('/(\D)/', '', $voieAv)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($voieAv, true), mb_strlen(preg_replace('/(\D)/', '', $voieAv))), __LINE__);
        }
        $this->VoieAv = $voieAv;
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string|null
     */
    public function getImmatriculation()
    {
        return $this->Immatriculation;
    }
    /**
     * Set Immatriculation value
     * @param string $immatriculation
     * @return \StructType\TypeInfoVehicule
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        $this->Immatriculation = $immatriculation;
        return $this;
    }
    /**
     * Get CodeMoteur value
     * @return string|null
     */
    public function getCodeMoteur()
    {
        return $this->CodeMoteur;
    }
    /**
     * Set CodeMoteur value
     * @param string $codeMoteur
     * @return \StructType\TypeInfoVehicule
     */
    public function setCodeMoteur($codeMoteur = null)
    {
        // validation for constraint: string
        if (!is_null($codeMoteur) && !is_string($codeMoteur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeMoteur, true), gettype($codeMoteur)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($codeMoteur) && mb_strlen($codeMoteur) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($codeMoteur)), __LINE__);
        }
        $this->CodeMoteur = $codeMoteur;
        return $this;
    }
    /**
     * Get PtrPrf value
     * @return int|null
     */
    public function getPtrPrf()
    {
        return $this->PtrPrf;
    }
    /**
     * Set PtrPrf value
     * @param int $ptrPrf
     * @return \StructType\TypeInfoVehicule
     */
    public function setPtrPrf($ptrPrf = null)
    {
        // validation for constraint: int
        if (!is_null($ptrPrf) && !(is_int($ptrPrf) || ctype_digit($ptrPrf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ptrPrf, true), gettype($ptrPrf)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($ptrPrf) && mb_strlen(preg_replace('/(\D)/', '', $ptrPrf)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($ptrPrf, true), mb_strlen(preg_replace('/(\D)/', '', $ptrPrf))), __LINE__);
        }
        $this->PtrPrf = $ptrPrf;
        return $this;
    }
    /**
     * Get TypeVarVersPrf value
     * @return string|null
     */
    public function getTypeVarVersPrf()
    {
        return $this->TypeVarVersPrf;
    }
    /**
     * Set TypeVarVersPrf value
     * @param string $typeVarVersPrf
     * @return \StructType\TypeInfoVehicule
     */
    public function setTypeVarVersPrf($typeVarVersPrf = null)
    {
        // validation for constraint: string
        if (!is_null($typeVarVersPrf) && !is_string($typeVarVersPrf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeVarVersPrf, true), gettype($typeVarVersPrf)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($typeVarVersPrf) && mb_strlen($typeVarVersPrf) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($typeVarVersPrf)), __LINE__);
        }
        $this->TypeVarVersPrf = $typeVarVersPrf;
        return $this;
    }
    /**
     * Get Prix value
     * @return float|null
     */
    public function getPrix()
    {
        return $this->Prix;
    }
    /**
     * Set Prix value
     * @param float $prix
     * @return \StructType\TypeInfoVehicule
     */
    public function setPrix($prix = null)
    {
        // validation for constraint: float
        if (!is_null($prix) && !(is_float($prix) || is_numeric($prix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prix, true), gettype($prix)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prix) && mb_strlen(mb_substr($prix, mb_strpos($prix, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prix, true), mb_strlen(mb_substr($prix, mb_strpos($prix, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(11)
        if (!is_null($prix) && mb_strlen(preg_replace('/(\D)/', '', $prix)) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 11 digits, "%d" given', var_export($prix, true), mb_strlen(preg_replace('/(\D)/', '', $prix))), __LINE__);
        }
        $this->Prix = $prix;
        return $this;
    }
    /**
     * Get PuissanceKW value
     * @return int|null
     */
    public function getPuissanceKW()
    {
        return $this->PuissanceKW;
    }
    /**
     * Set PuissanceKW value
     * @param int $puissanceKW
     * @return \StructType\TypeInfoVehicule
     */
    public function setPuissanceKW($puissanceKW = null)
    {
        // validation for constraint: int
        if (!is_null($puissanceKW) && !(is_int($puissanceKW) || ctype_digit($puissanceKW))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissanceKW, true), gettype($puissanceKW)), __LINE__);
        }
        // validation for constraint: totalDigits(8)
        if (!is_null($puissanceKW) && mb_strlen(preg_replace('/(\D)/', '', $puissanceKW)) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 8 digits, "%d" given', var_export($puissanceKW, true), mb_strlen(preg_replace('/(\D)/', '', $puissanceKW))), __LINE__);
        }
        $this->PuissanceKW = $puissanceKW;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeInfoVehicule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
