<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Negative StructType
 * @subpackage Structs
 */
class Negative extends AbstractStructBase
{
    /**
     * The Erreur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Erreur;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The CO2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CO2;
    /**
     * The Puissance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Puissance;
    /**
     * The Genre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Genre;
    /**
     * The PTAC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PTAC;
    /**
     * The Energie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Energie;
    /**
     * The DateMEC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateMEC;
    /**
     * Constructor method for Negative
     * @uses Negative::setErreur()
     * @uses Negative::setCode()
     * @uses Negative::setVIN()
     * @uses Negative::setCO2()
     * @uses Negative::setPuissance()
     * @uses Negative::setGenre()
     * @uses Negative::setPTAC()
     * @uses Negative::setEnergie()
     * @uses Negative::setDateMEC()
     * @param string $erreur
     * @param int $code
     * @param string $vIN
     * @param int $cO2
     * @param int $puissance
     * @param string $genre
     * @param string $pTAC
     * @param string $energie
     * @param string $dateMEC
     */
    public function __construct($erreur = null, $code = null, $vIN = null, $cO2 = null, $puissance = null, $genre = null, $pTAC = null, $energie = null, $dateMEC = null)
    {
        $this
            ->setErreur($erreur)
            ->setCode($code)
            ->setVIN($vIN)
            ->setCO2($cO2)
            ->setPuissance($puissance)
            ->setGenre($genre)
            ->setPTAC($pTAC)
            ->setEnergie($energie)
            ->setDateMEC($dateMEC);
    }
    /**
     * Get Erreur value
     * @return string
     */
    public function getErreur()
    {
        return $this->Erreur;
    }
    /**
     * Set Erreur value
     * @param string $erreur
     * @return \StructType\Negative
     */
    public function setErreur($erreur = null)
    {
        // validation for constraint: string
        if (!is_null($erreur) && !is_string($erreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erreur, true), gettype($erreur)), __LINE__);
        }
        $this->Erreur = $erreur;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\Negative
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\Negative
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get CO2 value
     * @return int|null
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param int $cO2
     * @return \StructType\Negative
     */
    public function setCO2($cO2 = null)
    {
        // validation for constraint: int
        if (!is_null($cO2) && !(is_int($cO2) || ctype_digit($cO2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cO2, true), gettype($cO2)), __LINE__);
        }
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get Puissance value
     * @return int|null
     */
    public function getPuissance()
    {
        return $this->Puissance;
    }
    /**
     * Set Puissance value
     * @param int $puissance
     * @return \StructType\Negative
     */
    public function setPuissance($puissance = null)
    {
        // validation for constraint: int
        if (!is_null($puissance) && !(is_int($puissance) || ctype_digit($puissance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissance, true), gettype($puissance)), __LINE__);
        }
        $this->Puissance = $puissance;
        return $this;
    }
    /**
     * Get Genre value
     * @return string|null
     */
    public function getGenre()
    {
        return $this->Genre;
    }
    /**
     * Set Genre value
     * @uses \EnumType\TypeECGGenre::valueIsValid()
     * @uses \EnumType\TypeECGGenre::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $genre
     * @return \StructType\Negative
     */
    public function setGenre($genre = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGGenre::valueIsValid($genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGGenre', is_array($genre) ? implode(', ', $genre) : var_export($genre, true), implode(', ', \EnumType\TypeECGGenre::getValidValues())), __LINE__);
        }
        $this->Genre = $genre;
        return $this;
    }
    /**
     * Get PTAC value
     * @return string|null
     */
    public function getPTAC()
    {
        return $this->PTAC;
    }
    /**
     * Set PTAC value
     * @uses \EnumType\TypeECGPTAC::valueIsValid()
     * @uses \EnumType\TypeECGPTAC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pTAC
     * @return \StructType\Negative
     */
    public function setPTAC($pTAC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGPTAC::valueIsValid($pTAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGPTAC', is_array($pTAC) ? implode(', ', $pTAC) : var_export($pTAC, true), implode(', ', \EnumType\TypeECGPTAC::getValidValues())), __LINE__);
        }
        $this->PTAC = $pTAC;
        return $this;
    }
    /**
     * Get Energie value
     * @return string|null
     */
    public function getEnergie()
    {
        return $this->Energie;
    }
    /**
     * Set Energie value
     * @uses \EnumType\TypeECGEnergie::valueIsValid()
     * @uses \EnumType\TypeECGEnergie::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $energie
     * @return \StructType\Negative
     */
    public function setEnergie($energie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGEnergie::valueIsValid($energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGEnergie', is_array($energie) ? implode(', ', $energie) : var_export($energie, true), implode(', ', \EnumType\TypeECGEnergie::getValidValues())), __LINE__);
        }
        $this->Energie = $energie;
        return $this;
    }
    /**
     * Get DateMEC value
     * @return string|null
     */
    public function getDateMEC()
    {
        return $this->DateMEC;
    }
    /**
     * Set DateMEC value
     * @param string $dateMEC
     * @return \StructType\Negative
     */
    public function setDateMEC($dateMEC = null)
    {
        // validation for constraint: string
        if (!is_null($dateMEC) && !is_string($dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMEC, true), gettype($dateMEC)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateMEC) && mb_strlen($dateMEC) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateMEC)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateMEC) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateMEC, true)), __LINE__);
        }
        $this->DateMEC = $dateMEC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Negative
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
