<?php

namespace EnumType;

/**
 * This class stands for TypeArchivage EnumType
 * @subpackage Enumerations
 */
class TypeArchivage
{
    /**
     * Constant for value 'CFN'
     * @return string 'CFN'
     */
    const VALUE_CFN = 'CFN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CFN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CFN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
