<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeCotitulaire StructType
 * @subpackage Structs
 */
class TypeCotitulaire extends AbstractStructBase
{
    /**
     * The PremierCotitulaire
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PremierCotitulaire;
    /**
     * The PersonneMorale
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonneMorale
     */
    public $PersonneMorale;
    /**
     * The PersonnePhysique
     * Meta information extracted from the WSDL
     * - choice: PersonneMorale | PersonnePhysique
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PersonnePhysique
     */
    public $PersonnePhysique;
    /**
     * Constructor method for TypeCotitulaire
     * @uses TypeCotitulaire::setPremierCotitulaire()
     * @uses TypeCotitulaire::setPersonneMorale()
     * @uses TypeCotitulaire::setPersonnePhysique()
     * @param bool $premierCotitulaire
     * @param \StructType\PersonneMorale $personneMorale
     * @param \StructType\PersonnePhysique $personnePhysique
     */
    public function __construct($premierCotitulaire = null, \StructType\PersonneMorale $personneMorale = null, \StructType\PersonnePhysique $personnePhysique = null)
    {
        $this
            ->setPremierCotitulaire($premierCotitulaire)
            ->setPersonneMorale($personneMorale)
            ->setPersonnePhysique($personnePhysique);
    }
    /**
     * Get PremierCotitulaire value
     * @return bool
     */
    public function getPremierCotitulaire()
    {
        return $this->PremierCotitulaire;
    }
    /**
     * Set PremierCotitulaire value
     * @param bool $premierCotitulaire
     * @return \StructType\TypeCotitulaire
     */
    public function setPremierCotitulaire($premierCotitulaire = null)
    {
        // validation for constraint: boolean
        if (!is_null($premierCotitulaire) && !is_bool($premierCotitulaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($premierCotitulaire, true), gettype($premierCotitulaire)), __LINE__);
        }
        $this->PremierCotitulaire = $premierCotitulaire;
        return $this;
    }
    /**
     * Get PersonneMorale value
     * @return \StructType\PersonneMorale
     */
    public function getPersonneMorale()
    {
        return isset($this->PersonneMorale) ? $this->PersonneMorale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonneMorale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonneMorale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonnePhysique',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonneMorale can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonneMorale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonneMorale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonneMorale $personneMorale
     * @return \StructType\TypeCotitulaire
     */
    public function setPersonneMorale(\StructType\PersonneMorale $personneMorale = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique)
        if ('' !== ($personneMoraleChoiceErrorMessage = self::validatePersonneMoraleForChoiceConstraintsFromSetPersonneMorale($personneMorale))) {
            throw new \InvalidArgumentException($personneMoraleChoiceErrorMessage, __LINE__);
        }
        if (is_null($personneMorale) || (is_array($personneMorale) && empty($personneMorale))) {
            unset($this->PersonneMorale);
        } else {
            $this->PersonneMorale = $personneMorale;
        }
        return $this;
    }
    /**
     * Get PersonnePhysique value
     * @return \StructType\PersonnePhysique
     */
    public function getPersonnePhysique()
    {
        return isset($this->PersonnePhysique) ? $this->PersonnePhysique : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPersonnePhysique method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonnePhysique method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'PersonneMorale',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PersonnePhysique can\'t be set as the property %s is already set. Only one property must be set among these properties: PersonnePhysique, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PersonnePhysique value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonnePhysique $personnePhysique
     * @return \StructType\TypeCotitulaire
     */
    public function setPersonnePhysique(\StructType\PersonnePhysique $personnePhysique = null)
    {
        // validation for constraint: choice(PersonneMorale, PersonnePhysique)
        if ('' !== ($personnePhysiqueChoiceErrorMessage = self::validatePersonnePhysiqueForChoiceConstraintsFromSetPersonnePhysique($personnePhysique))) {
            throw new \InvalidArgumentException($personnePhysiqueChoiceErrorMessage, __LINE__);
        }
        if (is_null($personnePhysique) || (is_array($personnePhysique) && empty($personnePhysique))) {
            unset($this->PersonnePhysique);
        } else {
            $this->PersonnePhysique = $personnePhysique;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeCotitulaire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
