<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeCarrossier StructType
 * @subpackage Structs
 */
class TypeCarrossier extends AbstractStructBase
{
    /**
     * The Agrement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Agrement;
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - choice: RaisonSociale | Nom | Prenom
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RaisonSociale;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - choice: RaisonSociale | Nom | Prenom
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Nom;
    /**
     * The Prenom
     * Meta information extracted from the WSDL
     * - choice: RaisonSociale | Nom | Prenom
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Prenom;
    /**
     * The Justificatifs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Justificatifs;
    /**
     * Constructor method for TypeCarrossier
     * @uses TypeCarrossier::setAgrement()
     * @uses TypeCarrossier::setRaisonSociale()
     * @uses TypeCarrossier::setNom()
     * @uses TypeCarrossier::setPrenom()
     * @uses TypeCarrossier::setJustificatifs()
     * @param string $agrement
     * @param string $raisonSociale
     * @param string $nom
     * @param string $prenom
     * @param bool $justificatifs
     */
    public function __construct($agrement = null, $raisonSociale = null, $nom = null, $prenom = null, $justificatifs = null)
    {
        $this
            ->setAgrement($agrement)
            ->setRaisonSociale($raisonSociale)
            ->setNom($nom)
            ->setPrenom($prenom)
            ->setJustificatifs($justificatifs);
    }
    /**
     * Get Agrement value
     * @return string
     */
    public function getAgrement()
    {
        return $this->Agrement;
    }
    /**
     * Set Agrement value
     * @param string $agrement
     * @return \StructType\TypeCarrossier
     */
    public function setAgrement($agrement = null)
    {
        // validation for constraint: string
        if (!is_null($agrement) && !is_string($agrement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agrement, true), gettype($agrement)), __LINE__);
        }
        $this->Agrement = $agrement;
        return $this;
    }
    /**
     * Get RaisonSociale value
     * @return string
     */
    public function getRaisonSociale()
    {
        return isset($this->RaisonSociale) ? $this->RaisonSociale : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRaisonSociale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRaisonSociale method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRaisonSocialeForChoiceConstraintsFromSetRaisonSociale($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Nom',
            'Prenom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RaisonSociale can\'t be set as the property %s is already set. Only one property must be set among these properties: RaisonSociale, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RaisonSociale value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $raisonSociale
     * @return \StructType\TypeCarrossier
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        // validation for constraint: choice(RaisonSociale, Nom, Prenom)
        if ('' !== ($raisonSocialeChoiceErrorMessage = self::validateRaisonSocialeForChoiceConstraintsFromSetRaisonSociale($raisonSociale))) {
            throw new \InvalidArgumentException($raisonSocialeChoiceErrorMessage, __LINE__);
        }
        if (is_null($raisonSociale) || (is_array($raisonSociale) && empty($raisonSociale))) {
            unset($this->RaisonSociale);
        } else {
            $this->RaisonSociale = $raisonSociale;
        }
        return $this;
    }
    /**
     * Get Nom value
     * @return string
     */
    public function getNom()
    {
        return isset($this->Nom) ? $this->Nom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNomForChoiceConstraintsFromSetNom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RaisonSociale',
            'Prenom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Nom can\'t be set as the property %s is already set. Only one property must be set among these properties: Nom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Nom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nom
     * @return \StructType\TypeCarrossier
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        // validation for constraint: choice(RaisonSociale, Nom, Prenom)
        if ('' !== ($nomChoiceErrorMessage = self::validateNomForChoiceConstraintsFromSetNom($nom))) {
            throw new \InvalidArgumentException($nomChoiceErrorMessage, __LINE__);
        }
        if (is_null($nom) || (is_array($nom) && empty($nom))) {
            unset($this->Nom);
        } else {
            $this->Nom = $nom;
        }
        return $this;
    }
    /**
     * Get Prenom value
     * @return string
     */
    public function getPrenom()
    {
        return isset($this->Prenom) ? $this->Prenom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPrenom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrenom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrenomForChoiceConstraintsFromSetPrenom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RaisonSociale',
            'Nom',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prenom can\'t be set as the property %s is already set. Only one property must be set among these properties: Prenom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Prenom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $prenom
     * @return \StructType\TypeCarrossier
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prenom, true), gettype($prenom)), __LINE__);
        }
        // validation for constraint: choice(RaisonSociale, Nom, Prenom)
        if ('' !== ($prenomChoiceErrorMessage = self::validatePrenomForChoiceConstraintsFromSetPrenom($prenom))) {
            throw new \InvalidArgumentException($prenomChoiceErrorMessage, __LINE__);
        }
        if (is_null($prenom) || (is_array($prenom) && empty($prenom))) {
            unset($this->Prenom);
        } else {
            $this->Prenom = $prenom;
        }
        return $this;
    }
    /**
     * Get Justificatifs value
     * @return bool
     */
    public function getJustificatifs()
    {
        return $this->Justificatifs;
    }
    /**
     * Set Justificatifs value
     * @param bool $justificatifs
     * @return \StructType\TypeCarrossier
     */
    public function setJustificatifs($justificatifs = null)
    {
        // validation for constraint: boolean
        if (!is_null($justificatifs) && !is_bool($justificatifs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($justificatifs, true), gettype($justificatifs)), __LINE__);
        }
        $this->Justificatifs = $justificatifs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeCarrossier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
