<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypeAdresse StructType
 * @subpackage Structs
 */
class TypeAdresse extends AbstractStructBase
{
    /**
     * The TypeVoie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeVoie;
    /**
     * The NomVoie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomVoie;
    /**
     * The CodePostal
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \d{5}
     * @var string
     */
    public $CodePostal;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Ville;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 4
     * @var int
     */
    public $Numero;
    /**
     * The ExtensionIndice
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - length: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtensionIndice;
    /**
     * The LieuDit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LieuDit;
    /**
     * The EtageEscAppt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EtageEscAppt;
    /**
     * The Complement
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Complement;
    /**
     * The BoitePostale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BoitePostale;
    /**
     * The Pays
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Pays;
    /**
     * Constructor method for TypeAdresse
     * @uses TypeAdresse::setTypeVoie()
     * @uses TypeAdresse::setNomVoie()
     * @uses TypeAdresse::setCodePostal()
     * @uses TypeAdresse::setVille()
     * @uses TypeAdresse::setNumero()
     * @uses TypeAdresse::setExtensionIndice()
     * @uses TypeAdresse::setLieuDit()
     * @uses TypeAdresse::setEtageEscAppt()
     * @uses TypeAdresse::setComplement()
     * @uses TypeAdresse::setBoitePostale()
     * @uses TypeAdresse::setPays()
     * @param string $typeVoie
     * @param string $nomVoie
     * @param string $codePostal
     * @param string $ville
     * @param int $numero
     * @param string $extensionIndice
     * @param string $lieuDit
     * @param string $etageEscAppt
     * @param string $complement
     * @param string $boitePostale
     * @param string $pays
     */
    public function __construct($typeVoie = null, $nomVoie = null, $codePostal = null, $ville = null, $numero = null, $extensionIndice = null, $lieuDit = null, $etageEscAppt = null, $complement = null, $boitePostale = null, $pays = null)
    {
        $this
            ->setTypeVoie($typeVoie)
            ->setNomVoie($nomVoie)
            ->setCodePostal($codePostal)
            ->setVille($ville)
            ->setNumero($numero)
            ->setExtensionIndice($extensionIndice)
            ->setLieuDit($lieuDit)
            ->setEtageEscAppt($etageEscAppt)
            ->setComplement($complement)
            ->setBoitePostale($boitePostale)
            ->setPays($pays);
    }
    /**
     * Get TypeVoie value
     * @return string
     */
    public function getTypeVoie()
    {
        return $this->TypeVoie;
    }
    /**
     * Set TypeVoie value
     * @uses \EnumType\TypeVoie::valueIsValid()
     * @uses \EnumType\TypeVoie::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeVoie
     * @return \StructType\TypeAdresse
     */
    public function setTypeVoie($typeVoie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeVoie::valueIsValid($typeVoie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeVoie', is_array($typeVoie) ? implode(', ', $typeVoie) : var_export($typeVoie, true), implode(', ', \EnumType\TypeVoie::getValidValues())), __LINE__);
        }
        $this->TypeVoie = $typeVoie;
        return $this;
    }
    /**
     * Get NomVoie value
     * @return string
     */
    public function getNomVoie()
    {
        return $this->NomVoie;
    }
    /**
     * Set NomVoie value
     * @param string $nomVoie
     * @return \StructType\TypeAdresse
     */
    public function setNomVoie($nomVoie = null)
    {
        // validation for constraint: string
        if (!is_null($nomVoie) && !is_string($nomVoie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomVoie, true), gettype($nomVoie)), __LINE__);
        }
        $this->NomVoie = $nomVoie;
        return $this;
    }
    /**
     * Get CodePostal value
     * @return string
     */
    public function getCodePostal()
    {
        return $this->CodePostal;
    }
    /**
     * Set CodePostal value
     * @param string $codePostal
     * @return \StructType\TypeAdresse
     */
    public function setCodePostal($codePostal = null)
    {
        // validation for constraint: string
        if (!is_null($codePostal) && !is_string($codePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePostal, true), gettype($codePostal)), __LINE__);
        }
        // validation for constraint: pattern(\d{5})
        if (!is_null($codePostal) && !preg_match('/\\d{5}/', $codePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{5}', var_export($codePostal, true)), __LINE__);
        }
        $this->CodePostal = $codePostal;
        return $this;
    }
    /**
     * Get Ville value
     * @return string
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param string $ville
     * @return \StructType\TypeAdresse
     */
    public function setVille($ville = null)
    {
        // validation for constraint: string
        if (!is_null($ville) && !is_string($ville)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ville, true), gettype($ville)), __LINE__);
        }
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get Numero value
     * @return int|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param int $numero
     * @return \StructType\TypeAdresse
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: int
        if (!is_null($numero) && !(is_int($numero) || ctype_digit($numero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($numero) && mb_strlen(preg_replace('/(\D)/', '', $numero)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($numero, true), mb_strlen(preg_replace('/(\D)/', '', $numero))), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get ExtensionIndice value
     * @return string|null
     */
    public function getExtensionIndice()
    {
        return $this->ExtensionIndice;
    }
    /**
     * Set ExtensionIndice value
     * @param string $extensionIndice
     * @return \StructType\TypeAdresse
     */
    public function setExtensionIndice($extensionIndice = null)
    {
        // validation for constraint: string
        if (!is_null($extensionIndice) && !is_string($extensionIndice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extensionIndice, true), gettype($extensionIndice)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($extensionIndice) && mb_strlen($extensionIndice) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($extensionIndice)), __LINE__);
        }
        $this->ExtensionIndice = $extensionIndice;
        return $this;
    }
    /**
     * Get LieuDit value
     * @return string|null
     */
    public function getLieuDit()
    {
        return $this->LieuDit;
    }
    /**
     * Set LieuDit value
     * @param string $lieuDit
     * @return \StructType\TypeAdresse
     */
    public function setLieuDit($lieuDit = null)
    {
        // validation for constraint: string
        if (!is_null($lieuDit) && !is_string($lieuDit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lieuDit, true), gettype($lieuDit)), __LINE__);
        }
        $this->LieuDit = $lieuDit;
        return $this;
    }
    /**
     * Get EtageEscAppt value
     * @return string|null
     */
    public function getEtageEscAppt()
    {
        return $this->EtageEscAppt;
    }
    /**
     * Set EtageEscAppt value
     * @param string $etageEscAppt
     * @return \StructType\TypeAdresse
     */
    public function setEtageEscAppt($etageEscAppt = null)
    {
        // validation for constraint: string
        if (!is_null($etageEscAppt) && !is_string($etageEscAppt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($etageEscAppt, true), gettype($etageEscAppt)), __LINE__);
        }
        $this->EtageEscAppt = $etageEscAppt;
        return $this;
    }
    /**
     * Get Complement value
     * @return string|null
     */
    public function getComplement()
    {
        return $this->Complement;
    }
    /**
     * Set Complement value
     * @param string $complement
     * @return \StructType\TypeAdresse
     */
    public function setComplement($complement = null)
    {
        // validation for constraint: string
        if (!is_null($complement) && !is_string($complement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complement, true), gettype($complement)), __LINE__);
        }
        $this->Complement = $complement;
        return $this;
    }
    /**
     * Get BoitePostale value
     * @return string|null
     */
    public function getBoitePostale()
    {
        return $this->BoitePostale;
    }
    /**
     * Set BoitePostale value
     * @param string $boitePostale
     * @return \StructType\TypeAdresse
     */
    public function setBoitePostale($boitePostale = null)
    {
        // validation for constraint: string
        if (!is_null($boitePostale) && !is_string($boitePostale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boitePostale, true), gettype($boitePostale)), __LINE__);
        }
        $this->BoitePostale = $boitePostale;
        return $this;
    }
    /**
     * Get Pays value
     * @return string|null
     */
    public function getPays()
    {
        return $this->Pays;
    }
    /**
     * Set Pays value
     * @param string $pays
     * @return \StructType\TypeAdresse
     */
    public function setPays($pays = null)
    {
        // validation for constraint: string
        if (!is_null($pays) && !is_string($pays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pays, true), gettype($pays)), __LINE__);
        }
        $this->Pays = $pays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypeAdresse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
