<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Positive StructType
 * @subpackage Structs
 */
class Positive extends AbstractStructBase
{
    /**
     * The NumBO
     * Meta information extracted from the WSDL
     * - choice: NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO |
     * Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation |
     * DateImmat | NumBO | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NumBO;
    /**
     * The Immatriculation
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO |
     * Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation |
     * DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 7
     * - minOccurs: 1
     * - nillable: true
     * - pattern: ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))
     * @var string
     */
    public $Immatriculation;
    /**
     * The DateImmat
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO |
     * Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation |
     * DateImmat | NumBO | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat | NumBO | Immatriculation | DateImmat
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateImmat;
    /**
     * The NomFic
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NomFic;
    /**
     * The TaxeRegionale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeRegionale;
    /**
     * The TaxeParafiscale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeParafiscale;
    /**
     * The TaxeCO2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeCO2;
    /**
     * The TaxeSIV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeSIV;
    /**
     * The TaxeRedevanceSIV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeRedevanceSIV;
    /**
     * The TaxeTotale
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeTotale;
    /**
     * The Gage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Gage;
    /**
     * The Taxe35cv
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Taxe35cv;
    /**
     * The TaxeMalus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TaxeMalus;
    /**
     * The VIN
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - pattern: [0-9A-Z]*
     * @var string
     */
    public $VIN;
    /**
     * The CO2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CO2;
    /**
     * The Puissance
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Puissance;
    /**
     * The Genre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Genre;
    /**
     * The PTAC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PTAC;
    /**
     * The Energie
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Energie;
    /**
     * The DateMEC
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateMEC;
    /**
     * Constructor method for Positive
     * @uses Positive::setNumBO()
     * @uses Positive::setImmatriculation()
     * @uses Positive::setDateImmat()
     * @uses Positive::setNomFic()
     * @uses Positive::setTaxeRegionale()
     * @uses Positive::setTaxeParafiscale()
     * @uses Positive::setTaxeCO2()
     * @uses Positive::setTaxeSIV()
     * @uses Positive::setTaxeRedevanceSIV()
     * @uses Positive::setTaxeTotale()
     * @uses Positive::setGage()
     * @uses Positive::setTaxe35cv()
     * @uses Positive::setTaxeMalus()
     * @uses Positive::setVIN()
     * @uses Positive::setCO2()
     * @uses Positive::setPuissance()
     * @uses Positive::setGenre()
     * @uses Positive::setPTAC()
     * @uses Positive::setEnergie()
     * @uses Positive::setDateMEC()
     * @param string $numBO
     * @param string $immatriculation
     * @param string $dateImmat
     * @param string $nomFic
     * @param float $taxeRegionale
     * @param float $taxeParafiscale
     * @param float $taxeCO2
     * @param float $taxeSIV
     * @param float $taxeRedevanceSIV
     * @param float $taxeTotale
     * @param string $gage
     * @param float $taxe35cv
     * @param float $taxeMalus
     * @param string $vIN
     * @param int $cO2
     * @param int $puissance
     * @param string $genre
     * @param string $pTAC
     * @param string $energie
     * @param string $dateMEC
     */
    public function __construct($numBO = null, $immatriculation = null, $dateImmat = null, $nomFic = null, $taxeRegionale = null, $taxeParafiscale = null, $taxeCO2 = null, $taxeSIV = null, $taxeRedevanceSIV = null, $taxeTotale = null, $gage = null, $taxe35cv = null, $taxeMalus = null, $vIN = null, $cO2 = null, $puissance = null, $genre = null, $pTAC = null, $energie = null, $dateMEC = null)
    {
        $this
            ->setNumBO($numBO)
            ->setImmatriculation($immatriculation)
            ->setDateImmat($dateImmat)
            ->setNomFic($nomFic)
            ->setTaxeRegionale($taxeRegionale)
            ->setTaxeParafiscale($taxeParafiscale)
            ->setTaxeCO2($taxeCO2)
            ->setTaxeSIV($taxeSIV)
            ->setTaxeRedevanceSIV($taxeRedevanceSIV)
            ->setTaxeTotale($taxeTotale)
            ->setGage($gage)
            ->setTaxe35cv($taxe35cv)
            ->setTaxeMalus($taxeMalus)
            ->setVIN($vIN)
            ->setCO2($cO2)
            ->setPuissance($puissance)
            ->setGenre($genre)
            ->setPTAC($pTAC)
            ->setEnergie($energie)
            ->setDateMEC($dateMEC);
    }
    /**
     * Get NumBO value
     * @return string
     */
    public function getNumBO()
    {
        return isset($this->NumBO) ? $this->NumBO : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNumBO method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumBO method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNumBOForChoiceConstraintsFromSetNumBO($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
            'Immatriculation',
            'DateImmat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property NumBO can\'t be set as the property %s is already set. Only one property must be set among these properties: NumBO, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set NumBO value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $numBO
     * @return \StructType\Positive
     */
    public function setNumBO($numBO = null)
    {
        // validation for constraint: string
        if (!is_null($numBO) && !is_string($numBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numBO, true), gettype($numBO)), __LINE__);
        }
        // validation for constraint: choice(NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat)
        if ('' !== ($numBOChoiceErrorMessage = self::validateNumBOForChoiceConstraintsFromSetNumBO($numBO))) {
            throw new \InvalidArgumentException($numBOChoiceErrorMessage, __LINE__);
        }
        if (is_null($numBO) || (is_array($numBO) && empty($numBO))) {
            unset($this->NumBO);
        } else {
            $this->NumBO = $numBO;
        }
        return $this;
    }
    /**
     * Get Immatriculation value
     * @return string
     */
    public function getImmatriculation()
    {
        return isset($this->Immatriculation) ? $this->Immatriculation : null;
    }
    /**
     * This method is responsible for validating the value passed to the setImmatriculation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImmatriculation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateImmatriculationForChoiceConstraintsFromSetImmatriculation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
            'NumBO',
            'DateImmat',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Immatriculation can\'t be set as the property %s is already set. Only one property must be set among these properties: Immatriculation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Immatriculation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $immatriculation
     * @return \StructType\Positive
     */
    public function setImmatriculation($immatriculation = null)
    {
        // validation for constraint: string
        if (!is_null($immatriculation) && !is_string($immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($immatriculation, true), gettype($immatriculation)), __LINE__);
        }
        // validation for constraint: choice(NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat)
        if ('' !== ($immatriculationChoiceErrorMessage = self::validateImmatriculationForChoiceConstraintsFromSetImmatriculation($immatriculation))) {
            throw new \InvalidArgumentException($immatriculationChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: minLength(7)
        if (!is_null($immatriculation) && mb_strlen($immatriculation) < 7) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 7', mb_strlen($immatriculation)), __LINE__);
        }
        // validation for constraint: pattern(([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3})))
        if (!is_null($immatriculation) && !preg_match('/([A-Z]{1,2}(-|\\s)?\\d{2,3}(-|\\s)?[A-Z]{1,2})|(\\d{1,4}\\s?[A-Z]{2,3}\\s?(2[AB]|\\d{1,3}))/', $immatriculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression ([A-Z]{1,2}(-|\s)?\d{2,3}(-|\s)?[A-Z]{1,2})|(\d{1,4}\s?[A-Z]{2,3}\s?(2[AB]|\d{1,3}))', var_export($immatriculation, true)), __LINE__);
        }
        if (is_null($immatriculation) || (is_array($immatriculation) && empty($immatriculation))) {
            unset($this->Immatriculation);
        } else {
            $this->Immatriculation = $immatriculation;
        }
        return $this;
    }
    /**
     * Get DateImmat value
     * @return string
     */
    public function getDateImmat()
    {
        return isset($this->DateImmat) ? $this->DateImmat : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDateImmat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateImmat method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDateImmatForChoiceConstraintsFromSetDateImmat($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
            'NumBO',
            'Immatriculation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DateImmat can\'t be set as the property %s is already set. Only one property must be set among these properties: DateImmat, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DateImmat value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $dateImmat
     * @return \StructType\Positive
     */
    public function setDateImmat($dateImmat = null)
    {
        // validation for constraint: string
        if (!is_null($dateImmat) && !is_string($dateImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateImmat, true), gettype($dateImmat)), __LINE__);
        }
        // validation for constraint: choice(NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat, NumBO, Immatriculation, DateImmat)
        if ('' !== ($dateImmatChoiceErrorMessage = self::validateDateImmatForChoiceConstraintsFromSetDateImmat($dateImmat))) {
            throw new \InvalidArgumentException($dateImmatChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateImmat) && mb_strlen($dateImmat) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateImmat)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateImmat) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateImmat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateImmat, true)), __LINE__);
        }
        if (is_null($dateImmat) || (is_array($dateImmat) && empty($dateImmat))) {
            unset($this->DateImmat);
        } else {
            $this->DateImmat = $dateImmat;
        }
        return $this;
    }
    /**
     * Get NomFic value
     * @return string
     */
    public function getNomFic()
    {
        return $this->NomFic;
    }
    /**
     * Set NomFic value
     * @param string $nomFic
     * @return \StructType\Positive
     */
    public function setNomFic($nomFic = null)
    {
        // validation for constraint: string
        if (!is_null($nomFic) && !is_string($nomFic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomFic, true), gettype($nomFic)), __LINE__);
        }
        $this->NomFic = $nomFic;
        return $this;
    }
    /**
     * Get TaxeRegionale value
     * @return float
     */
    public function getTaxeRegionale()
    {
        return $this->TaxeRegionale;
    }
    /**
     * Set TaxeRegionale value
     * @param float $taxeRegionale
     * @return \StructType\Positive
     */
    public function setTaxeRegionale($taxeRegionale = null)
    {
        // validation for constraint: float
        if (!is_null($taxeRegionale) && !(is_float($taxeRegionale) || is_numeric($taxeRegionale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeRegionale, true), gettype($taxeRegionale)), __LINE__);
        }
        $this->TaxeRegionale = $taxeRegionale;
        return $this;
    }
    /**
     * Get TaxeParafiscale value
     * @return float
     */
    public function getTaxeParafiscale()
    {
        return $this->TaxeParafiscale;
    }
    /**
     * Set TaxeParafiscale value
     * @param float $taxeParafiscale
     * @return \StructType\Positive
     */
    public function setTaxeParafiscale($taxeParafiscale = null)
    {
        // validation for constraint: float
        if (!is_null($taxeParafiscale) && !(is_float($taxeParafiscale) || is_numeric($taxeParafiscale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeParafiscale, true), gettype($taxeParafiscale)), __LINE__);
        }
        $this->TaxeParafiscale = $taxeParafiscale;
        return $this;
    }
    /**
     * Get TaxeCO2 value
     * @return float
     */
    public function getTaxeCO2()
    {
        return $this->TaxeCO2;
    }
    /**
     * Set TaxeCO2 value
     * @param float $taxeCO2
     * @return \StructType\Positive
     */
    public function setTaxeCO2($taxeCO2 = null)
    {
        // validation for constraint: float
        if (!is_null($taxeCO2) && !(is_float($taxeCO2) || is_numeric($taxeCO2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeCO2, true), gettype($taxeCO2)), __LINE__);
        }
        $this->TaxeCO2 = $taxeCO2;
        return $this;
    }
    /**
     * Get TaxeSIV value
     * @return float
     */
    public function getTaxeSIV()
    {
        return $this->TaxeSIV;
    }
    /**
     * Set TaxeSIV value
     * @param float $taxeSIV
     * @return \StructType\Positive
     */
    public function setTaxeSIV($taxeSIV = null)
    {
        // validation for constraint: float
        if (!is_null($taxeSIV) && !(is_float($taxeSIV) || is_numeric($taxeSIV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeSIV, true), gettype($taxeSIV)), __LINE__);
        }
        $this->TaxeSIV = $taxeSIV;
        return $this;
    }
    /**
     * Get TaxeRedevanceSIV value
     * @return float
     */
    public function getTaxeRedevanceSIV()
    {
        return $this->TaxeRedevanceSIV;
    }
    /**
     * Set TaxeRedevanceSIV value
     * @param float $taxeRedevanceSIV
     * @return \StructType\Positive
     */
    public function setTaxeRedevanceSIV($taxeRedevanceSIV = null)
    {
        // validation for constraint: float
        if (!is_null($taxeRedevanceSIV) && !(is_float($taxeRedevanceSIV) || is_numeric($taxeRedevanceSIV))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeRedevanceSIV, true), gettype($taxeRedevanceSIV)), __LINE__);
        }
        $this->TaxeRedevanceSIV = $taxeRedevanceSIV;
        return $this;
    }
    /**
     * Get TaxeTotale value
     * @return float
     */
    public function getTaxeTotale()
    {
        return $this->TaxeTotale;
    }
    /**
     * Set TaxeTotale value
     * @param float $taxeTotale
     * @return \StructType\Positive
     */
    public function setTaxeTotale($taxeTotale = null)
    {
        // validation for constraint: float
        if (!is_null($taxeTotale) && !(is_float($taxeTotale) || is_numeric($taxeTotale))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeTotale, true), gettype($taxeTotale)), __LINE__);
        }
        $this->TaxeTotale = $taxeTotale;
        return $this;
    }
    /**
     * Get Gage value
     * @return string
     */
    public function getGage()
    {
        return $this->Gage;
    }
    /**
     * Set Gage value
     * @param string $gage
     * @return \StructType\Positive
     */
    public function setGage($gage = null)
    {
        // validation for constraint: string
        if (!is_null($gage) && !is_string($gage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gage, true), gettype($gage)), __LINE__);
        }
        $this->Gage = $gage;
        return $this;
    }
    /**
     * Get Taxe35cv value
     * @return float
     */
    public function getTaxe35cv()
    {
        return $this->Taxe35cv;
    }
    /**
     * Set Taxe35cv value
     * @param float $taxe35cv
     * @return \StructType\Positive
     */
    public function setTaxe35cv($taxe35cv = null)
    {
        // validation for constraint: float
        if (!is_null($taxe35cv) && !(is_float($taxe35cv) || is_numeric($taxe35cv))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxe35cv, true), gettype($taxe35cv)), __LINE__);
        }
        $this->Taxe35cv = $taxe35cv;
        return $this;
    }
    /**
     * Get TaxeMalus value
     * @return float
     */
    public function getTaxeMalus()
    {
        return $this->TaxeMalus;
    }
    /**
     * Set TaxeMalus value
     * @param float $taxeMalus
     * @return \StructType\Positive
     */
    public function setTaxeMalus($taxeMalus = null)
    {
        // validation for constraint: float
        if (!is_null($taxeMalus) && !(is_float($taxeMalus) || is_numeric($taxeMalus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxeMalus, true), gettype($taxeMalus)), __LINE__);
        }
        $this->TaxeMalus = $taxeMalus;
        return $this;
    }
    /**
     * Get VIN value
     * @return string
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \StructType\Positive
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vIN, true), gettype($vIN)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($vIN) && mb_strlen($vIN) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vIN) && mb_strlen($vIN) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vIN)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]*)
        if (!is_null($vIN) && !preg_match('/[0-9A-Z]*/', $vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]*', var_export($vIN, true)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get CO2 value
     * @return int
     */
    public function getCO2()
    {
        return $this->CO2;
    }
    /**
     * Set CO2 value
     * @param int $cO2
     * @return \StructType\Positive
     */
    public function setCO2($cO2 = null)
    {
        // validation for constraint: int
        if (!is_null($cO2) && !(is_int($cO2) || ctype_digit($cO2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cO2, true), gettype($cO2)), __LINE__);
        }
        $this->CO2 = $cO2;
        return $this;
    }
    /**
     * Get Puissance value
     * @return int
     */
    public function getPuissance()
    {
        return $this->Puissance;
    }
    /**
     * Set Puissance value
     * @param int $puissance
     * @return \StructType\Positive
     */
    public function setPuissance($puissance = null)
    {
        // validation for constraint: int
        if (!is_null($puissance) && !(is_int($puissance) || ctype_digit($puissance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($puissance, true), gettype($puissance)), __LINE__);
        }
        $this->Puissance = $puissance;
        return $this;
    }
    /**
     * Get Genre value
     * @return string
     */
    public function getGenre()
    {
        return $this->Genre;
    }
    /**
     * Set Genre value
     * @uses \EnumType\TypeECGGenre::valueIsValid()
     * @uses \EnumType\TypeECGGenre::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $genre
     * @return \StructType\Positive
     */
    public function setGenre($genre = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGGenre::valueIsValid($genre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGGenre', is_array($genre) ? implode(', ', $genre) : var_export($genre, true), implode(', ', \EnumType\TypeECGGenre::getValidValues())), __LINE__);
        }
        $this->Genre = $genre;
        return $this;
    }
    /**
     * Get PTAC value
     * @return string
     */
    public function getPTAC()
    {
        return $this->PTAC;
    }
    /**
     * Set PTAC value
     * @uses \EnumType\TypeECGPTAC::valueIsValid()
     * @uses \EnumType\TypeECGPTAC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pTAC
     * @return \StructType\Positive
     */
    public function setPTAC($pTAC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGPTAC::valueIsValid($pTAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGPTAC', is_array($pTAC) ? implode(', ', $pTAC) : var_export($pTAC, true), implode(', ', \EnumType\TypeECGPTAC::getValidValues())), __LINE__);
        }
        $this->PTAC = $pTAC;
        return $this;
    }
    /**
     * Get Energie value
     * @return string
     */
    public function getEnergie()
    {
        return $this->Energie;
    }
    /**
     * Set Energie value
     * @uses \EnumType\TypeECGEnergie::valueIsValid()
     * @uses \EnumType\TypeECGEnergie::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $energie
     * @return \StructType\Positive
     */
    public function setEnergie($energie = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeECGEnergie::valueIsValid($energie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeECGEnergie', is_array($energie) ? implode(', ', $energie) : var_export($energie, true), implode(', ', \EnumType\TypeECGEnergie::getValidValues())), __LINE__);
        }
        $this->Energie = $energie;
        return $this;
    }
    /**
     * Get DateMEC value
     * @return string
     */
    public function getDateMEC()
    {
        return $this->DateMEC;
    }
    /**
     * Set DateMEC value
     * @param string $dateMEC
     * @return \StructType\Positive
     */
    public function setDateMEC($dateMEC = null)
    {
        // validation for constraint: string
        if (!is_null($dateMEC) && !is_string($dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateMEC, true), gettype($dateMEC)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateMEC) && mb_strlen($dateMEC) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateMEC)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateMEC) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateMEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateMEC, true)), __LINE__);
        }
        $this->DateMEC = $dateMEC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Positive
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
