<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TypePIVO StructType
 * @subpackage Structs
 */
class TypePIVO extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ID;
    /**
     * The TypeDemarche
     * Meta information extracted from the WSDL
     * - fixed: PIVO
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeDemarche;
    /**
     * The DateDemarche
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 19
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?
     * @var string
     */
    public $DateDemarche;
    /**
     * The Acquereur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Acquereur
     */
    public $Acquereur;
    /**
     * The NbCotitulaires
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NbCotitulaires;
    /**
     * The Vehicule
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\TypeVI
     */
    public $Vehicule;
    /**
     * The PaiementCBClient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PaiementCBClient;
    /**
     * The NumPortable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumPortable;
    /**
     * The EmissionBO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $EmissionBO;
    /**
     * The Cotitulaires
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cotitulaires
     */
    public $Cotitulaires;
    /**
     * The ExoPickUp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExoPickUp;
    /**
     * The Reponse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Reponse
     */
    public $Reponse;
    /**
     * Constructor method for TypePIVO
     * @uses TypePIVO::setID()
     * @uses TypePIVO::setTypeDemarche()
     * @uses TypePIVO::setDateDemarche()
     * @uses TypePIVO::setAcquereur()
     * @uses TypePIVO::setNbCotitulaires()
     * @uses TypePIVO::setVehicule()
     * @uses TypePIVO::setPaiementCBClient()
     * @uses TypePIVO::setNumPortable()
     * @uses TypePIVO::setEmissionBO()
     * @uses TypePIVO::setCotitulaires()
     * @uses TypePIVO::setExoPickUp()
     * @uses TypePIVO::setReponse()
     * @param int $iD
     * @param string $typeDemarche
     * @param string $dateDemarche
     * @param \StructType\Acquereur $acquereur
     * @param int $nbCotitulaires
     * @param \StructType\TypeVI $vehicule
     * @param bool $paiementCBClient
     * @param string $numPortable
     * @param bool $emissionBO
     * @param \StructType\Cotitulaires $cotitulaires
     * @param bool $exoPickUp
     * @param \StructType\Reponse $reponse
     */
    public function __construct($iD = null, $typeDemarche = null, $dateDemarche = null, \StructType\Acquereur $acquereur = null, $nbCotitulaires = null, \StructType\TypeVI $vehicule = null, $paiementCBClient = null, $numPortable = null, $emissionBO = null, \StructType\Cotitulaires $cotitulaires = null, $exoPickUp = null, \StructType\Reponse $reponse = null)
    {
        $this
            ->setID($iD)
            ->setTypeDemarche($typeDemarche)
            ->setDateDemarche($dateDemarche)
            ->setAcquereur($acquereur)
            ->setNbCotitulaires($nbCotitulaires)
            ->setVehicule($vehicule)
            ->setPaiementCBClient($paiementCBClient)
            ->setNumPortable($numPortable)
            ->setEmissionBO($emissionBO)
            ->setCotitulaires($cotitulaires)
            ->setExoPickUp($exoPickUp)
            ->setReponse($reponse);
    }
    /**
     * Get ID value
     * @return int
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TypePIVO
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TypeDemarche value
     * @return string
     */
    public function getTypeDemarche()
    {
        return $this->TypeDemarche;
    }
    /**
     * Set TypeDemarche value
     * @param string $typeDemarche
     * @return \StructType\TypePIVO
     */
    public function setTypeDemarche($typeDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($typeDemarche) && !is_string($typeDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDemarche, true), gettype($typeDemarche)), __LINE__);
        }
        $this->TypeDemarche = $typeDemarche;
        return $this;
    }
    /**
     * Get DateDemarche value
     * @return string
     */
    public function getDateDemarche()
    {
        return $this->DateDemarche;
    }
    /**
     * Set DateDemarche value
     * @param string $dateDemarche
     * @return \StructType\TypePIVO
     */
    public function setDateDemarche($dateDemarche = null)
    {
        // validation for constraint: string
        if (!is_null($dateDemarche) && !is_string($dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDemarche, true), gettype($dateDemarche)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($dateDemarche) && mb_strlen($dateDemarche) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($dateDemarche)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?)
        if (!is_null($dateDemarche) && !preg_match('/[0-9]{2}\/[0-9]{2}\/[0-9]{4}(\\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?/', $dateDemarche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}/[0-9]{2}/[0-9]{4}(\s([01][0-9]|2[0123])(:[0-5][0-9]){1,2})?', var_export($dateDemarche, true)), __LINE__);
        }
        $this->DateDemarche = $dateDemarche;
        return $this;
    }
    /**
     * Get Acquereur value
     * @return \StructType\Acquereur
     */
    public function getAcquereur()
    {
        return $this->Acquereur;
    }
    /**
     * Set Acquereur value
     * @param \StructType\Acquereur $acquereur
     * @return \StructType\TypePIVO
     */
    public function setAcquereur(\StructType\Acquereur $acquereur = null)
    {
        $this->Acquereur = $acquereur;
        return $this;
    }
    /**
     * Get NbCotitulaires value
     * @return int
     */
    public function getNbCotitulaires()
    {
        return $this->NbCotitulaires;
    }
    /**
     * Set NbCotitulaires value
     * @param int $nbCotitulaires
     * @return \StructType\TypePIVO
     */
    public function setNbCotitulaires($nbCotitulaires = null)
    {
        // validation for constraint: int
        if (!is_null($nbCotitulaires) && !(is_int($nbCotitulaires) || ctype_digit($nbCotitulaires))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbCotitulaires, true), gettype($nbCotitulaires)), __LINE__);
        }
        $this->NbCotitulaires = $nbCotitulaires;
        return $this;
    }
    /**
     * Get Vehicule value
     * @return \StructType\TypeVI
     */
    public function getVehicule()
    {
        return $this->Vehicule;
    }
    /**
     * Set Vehicule value
     * @param \StructType\TypeVI $vehicule
     * @return \StructType\TypePIVO
     */
    public function setVehicule(\StructType\TypeVI $vehicule = null)
    {
        $this->Vehicule = $vehicule;
        return $this;
    }
    /**
     * Get PaiementCBClient value
     * @return bool|null
     */
    public function getPaiementCBClient()
    {
        return $this->PaiementCBClient;
    }
    /**
     * Set PaiementCBClient value
     * @param bool $paiementCBClient
     * @return \StructType\TypePIVO
     */
    public function setPaiementCBClient($paiementCBClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($paiementCBClient) && !is_bool($paiementCBClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paiementCBClient, true), gettype($paiementCBClient)), __LINE__);
        }
        $this->PaiementCBClient = $paiementCBClient;
        return $this;
    }
    /**
     * Get NumPortable value
     * @return string|null
     */
    public function getNumPortable()
    {
        return $this->NumPortable;
    }
    /**
     * Set NumPortable value
     * @param string $numPortable
     * @return \StructType\TypePIVO
     */
    public function setNumPortable($numPortable = null)
    {
        // validation for constraint: string
        if (!is_null($numPortable) && !is_string($numPortable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numPortable, true), gettype($numPortable)), __LINE__);
        }
        $this->NumPortable = $numPortable;
        return $this;
    }
    /**
     * Get EmissionBO value
     * @return bool|null
     */
    public function getEmissionBO()
    {
        return $this->EmissionBO;
    }
    /**
     * Set EmissionBO value
     * @param bool $emissionBO
     * @return \StructType\TypePIVO
     */
    public function setEmissionBO($emissionBO = null)
    {
        // validation for constraint: boolean
        if (!is_null($emissionBO) && !is_bool($emissionBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emissionBO, true), gettype($emissionBO)), __LINE__);
        }
        $this->EmissionBO = $emissionBO;
        return $this;
    }
    /**
     * Get Cotitulaires value
     * @return \StructType\Cotitulaires|null
     */
    public function getCotitulaires()
    {
        return $this->Cotitulaires;
    }
    /**
     * Set Cotitulaires value
     * @param \StructType\Cotitulaires $cotitulaires
     * @return \StructType\TypePIVO
     */
    public function setCotitulaires(\StructType\Cotitulaires $cotitulaires = null)
    {
        $this->Cotitulaires = $cotitulaires;
        return $this;
    }
    /**
     * Get ExoPickUp value
     * @return bool|null
     */
    public function getExoPickUp()
    {
        return $this->ExoPickUp;
    }
    /**
     * Set ExoPickUp value
     * @param bool $exoPickUp
     * @return \StructType\TypePIVO
     */
    public function setExoPickUp($exoPickUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($exoPickUp) && !is_bool($exoPickUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exoPickUp, true), gettype($exoPickUp)), __LINE__);
        }
        $this->ExoPickUp = $exoPickUp;
        return $this;
    }
    /**
     * Get Reponse value
     * @return \StructType\Reponse|null
     */
    public function getReponse()
    {
        return $this->Reponse;
    }
    /**
     * Set Reponse value
     * @param \StructType\Reponse $reponse
     * @return \StructType\TypePIVO
     */
    public function setReponse(\StructType\Reponse $reponse = null)
    {
        $this->Reponse = $reponse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TypePIVO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
