<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Controle ServiceType
 * @subpackage Services
 */
class Controle extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ControleSIV
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ControleSIV_Req $controleSIVRepMsg
     * @return \StructType\ControleSIV_Rep|bool
     */
    public function ControleSIV(\StructType\ControleSIV_Req $controleSIVRepMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ControleSIV($controleSIVRepMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ControleSIV_Rep
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
