<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemDetailsResponse StructType
 * @subpackage Structs
 */
class ItemDetailsResponse extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $StatusCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ErrorCode;
    /**
     * The ItemInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ItemInternalId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Error;
    /**
     * Constructor method for ItemDetailsResponse
     * @uses ItemDetailsResponse::setStatusCode()
     * @uses ItemDetailsResponse::setErrorCode()
     * @uses ItemDetailsResponse::setItemInternalId()
     * @uses ItemDetailsResponse::setStatus()
     * @uses ItemDetailsResponse::setError()
     * @param int $statusCode
     * @param int $errorCode
     * @param string $itemInternalId
     * @param string $status
     * @param string $error
     */
    public function __construct($statusCode = null, $errorCode = null, $itemInternalId = null, $status = null, $error = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setErrorCode($errorCode)
            ->setItemInternalId($itemInternalId)
            ->setStatus($status)
            ->setError($error);
    }
    /**
     * Get StatusCode value
     * @return int
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param int $statusCode
     * @return \eBizCharge\StructType\ItemDetailsResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: int
        if (!is_null($statusCode) && !(is_int($statusCode) || ctype_digit($statusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusCode, true), gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \eBizCharge\StructType\ItemDetailsResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ItemInternalId value
     * @return string|null
     */
    public function getItemInternalId()
    {
        return $this->ItemInternalId;
    }
    /**
     * Set ItemInternalId value
     * @param string $itemInternalId
     * @return \eBizCharge\StructType\ItemDetailsResponse
     */
    public function setItemInternalId($itemInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($itemInternalId) && !is_string($itemInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemInternalId, true), gettype($itemInternalId)), __LINE__);
        }
        $this->ItemInternalId = $itemInternalId;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\ItemDetailsResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \eBizCharge\StructType\ItemDetailsResponse
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
}
