<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionObject StructType
 * @subpackage Structs
 */
class TransactionObject extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The Source
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source;
    /**
     * The ShippingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\GwAddress
     */
    public $ShippingAddress;
    /**
     * The ServerIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServerIP;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\TransactionResponse
     */
    public $Response;
    /**
     * The LineItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfLineItem
     */
    public $LineItems;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\TransactionDetail
     */
    public $Details;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The CustomFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfFieldValue
     */
    public $CustomFields;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerID;
    /**
     * The CreditCardData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CreditCardData
     */
    public $CreditCardData;
    /**
     * The ClientIP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientIP;
    /**
     * The CheckTrace
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CheckTrace
     */
    public $CheckTrace;
    /**
     * The CheckData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\CheckData
     */
    public $CheckData;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\GwAddress
     */
    public $BillingAddress;
    /**
     * The AccountHolder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolder;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TransactionType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * Constructor method for TransactionObject
     * @uses TransactionObject::setDateTime()
     * @uses TransactionObject::setSource()
     * @uses TransactionObject::setShippingAddress()
     * @uses TransactionObject::setServerIP()
     * @uses TransactionObject::setResponse()
     * @uses TransactionObject::setLineItems()
     * @uses TransactionObject::setDetails()
     * @uses TransactionObject::setUser()
     * @uses TransactionObject::setCustomFields()
     * @uses TransactionObject::setCustomerID()
     * @uses TransactionObject::setCreditCardData()
     * @uses TransactionObject::setClientIP()
     * @uses TransactionObject::setCheckTrace()
     * @uses TransactionObject::setCheckData()
     * @uses TransactionObject::setBillingAddress()
     * @uses TransactionObject::setAccountHolder()
     * @uses TransactionObject::setStatus()
     * @uses TransactionObject::setTransactionType()
     * @param string $dateTime
     * @param string $source
     * @param \eBizCharge\StructType\GwAddress $shippingAddress
     * @param string $serverIP
     * @param \eBizCharge\StructType\TransactionResponse $response
     * @param \eBizCharge\ArrayType\ArrayOfLineItem $lineItems
     * @param \eBizCharge\StructType\TransactionDetail $details
     * @param string $user
     * @param \eBizCharge\ArrayType\ArrayOfFieldValue $customFields
     * @param string $customerID
     * @param \eBizCharge\StructType\CreditCardData $creditCardData
     * @param string $clientIP
     * @param \eBizCharge\StructType\CheckTrace $checkTrace
     * @param \eBizCharge\StructType\CheckData $checkData
     * @param \eBizCharge\StructType\GwAddress $billingAddress
     * @param string $accountHolder
     * @param string $status
     * @param string $transactionType
     */
    public function __construct($dateTime = null, $source = null, \eBizCharge\StructType\GwAddress $shippingAddress = null, $serverIP = null, \eBizCharge\StructType\TransactionResponse $response = null, \eBizCharge\ArrayType\ArrayOfLineItem $lineItems = null, \eBizCharge\StructType\TransactionDetail $details = null, $user = null, \eBizCharge\ArrayType\ArrayOfFieldValue $customFields = null, $customerID = null, \eBizCharge\StructType\CreditCardData $creditCardData = null, $clientIP = null, \eBizCharge\StructType\CheckTrace $checkTrace = null, \eBizCharge\StructType\CheckData $checkData = null, \eBizCharge\StructType\GwAddress $billingAddress = null, $accountHolder = null, $status = null, $transactionType = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setSource($source)
            ->setShippingAddress($shippingAddress)
            ->setServerIP($serverIP)
            ->setResponse($response)
            ->setLineItems($lineItems)
            ->setDetails($details)
            ->setUser($user)
            ->setCustomFields($customFields)
            ->setCustomerID($customerID)
            ->setCreditCardData($creditCardData)
            ->setClientIP($clientIP)
            ->setCheckTrace($checkTrace)
            ->setCheckData($checkData)
            ->setBillingAddress($billingAddress)
            ->setAccountHolder($accountHolder)
            ->setStatus($status)
            ->setTransactionType($transactionType);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Get ShippingAddress value
     * @return \eBizCharge\StructType\GwAddress|null
     */
    public function getShippingAddress()
    {
        return $this->ShippingAddress;
    }
    /**
     * Set ShippingAddress value
     * @param \eBizCharge\StructType\GwAddress $shippingAddress
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setShippingAddress(\eBizCharge\StructType\GwAddress $shippingAddress = null)
    {
        $this->ShippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get ServerIP value
     * @return string|null
     */
    public function getServerIP()
    {
        return $this->ServerIP;
    }
    /**
     * Set ServerIP value
     * @param string $serverIP
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setServerIP($serverIP = null)
    {
        // validation for constraint: string
        if (!is_null($serverIP) && !is_string($serverIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverIP, true), gettype($serverIP)), __LINE__);
        }
        $this->ServerIP = $serverIP;
        return $this;
    }
    /**
     * Get Response value
     * @return \eBizCharge\StructType\TransactionResponse|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param \eBizCharge\StructType\TransactionResponse $response
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setResponse(\eBizCharge\StructType\TransactionResponse $response = null)
    {
        $this->Response = $response;
        return $this;
    }
    /**
     * Get LineItems value
     * @return \eBizCharge\ArrayType\ArrayOfLineItem|null
     */
    public function getLineItems()
    {
        return $this->LineItems;
    }
    /**
     * Set LineItems value
     * @param \eBizCharge\ArrayType\ArrayOfLineItem $lineItems
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setLineItems(\eBizCharge\ArrayType\ArrayOfLineItem $lineItems = null)
    {
        $this->LineItems = $lineItems;
        return $this;
    }
    /**
     * Get Details value
     * @return \eBizCharge\StructType\TransactionDetail|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \eBizCharge\StructType\TransactionDetail $details
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setDetails(\eBizCharge\StructType\TransactionDetail $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get CustomFields value
     * @return \eBizCharge\ArrayType\ArrayOfFieldValue|null
     */
    public function getCustomFields()
    {
        return $this->CustomFields;
    }
    /**
     * Set CustomFields value
     * @param \eBizCharge\ArrayType\ArrayOfFieldValue $customFields
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setCustomFields(\eBizCharge\ArrayType\ArrayOfFieldValue $customFields = null)
    {
        $this->CustomFields = $customFields;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return string|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param string $customerID
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get CreditCardData value
     * @return \eBizCharge\StructType\CreditCardData|null
     */
    public function getCreditCardData()
    {
        return $this->CreditCardData;
    }
    /**
     * Set CreditCardData value
     * @param \eBizCharge\StructType\CreditCardData $creditCardData
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setCreditCardData(\eBizCharge\StructType\CreditCardData $creditCardData = null)
    {
        $this->CreditCardData = $creditCardData;
        return $this;
    }
    /**
     * Get ClientIP value
     * @return string|null
     */
    public function getClientIP()
    {
        return $this->ClientIP;
    }
    /**
     * Set ClientIP value
     * @param string $clientIP
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setClientIP($clientIP = null)
    {
        // validation for constraint: string
        if (!is_null($clientIP) && !is_string($clientIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIP, true), gettype($clientIP)), __LINE__);
        }
        $this->ClientIP = $clientIP;
        return $this;
    }
    /**
     * Get CheckTrace value
     * @return \eBizCharge\StructType\CheckTrace|null
     */
    public function getCheckTrace()
    {
        return $this->CheckTrace;
    }
    /**
     * Set CheckTrace value
     * @param \eBizCharge\StructType\CheckTrace $checkTrace
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setCheckTrace(\eBizCharge\StructType\CheckTrace $checkTrace = null)
    {
        $this->CheckTrace = $checkTrace;
        return $this;
    }
    /**
     * Get CheckData value
     * @return \eBizCharge\StructType\CheckData|null
     */
    public function getCheckData()
    {
        return $this->CheckData;
    }
    /**
     * Set CheckData value
     * @param \eBizCharge\StructType\CheckData $checkData
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setCheckData(\eBizCharge\StructType\CheckData $checkData = null)
    {
        $this->CheckData = $checkData;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \eBizCharge\StructType\GwAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \eBizCharge\StructType\GwAddress $billingAddress
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setBillingAddress(\eBizCharge\StructType\GwAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get AccountHolder value
     * @return string|null
     */
    public function getAccountHolder()
    {
        return $this->AccountHolder;
    }
    /**
     * Set AccountHolder value
     * @param string $accountHolder
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setAccountHolder($accountHolder = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolder) && !is_string($accountHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountHolder, true), gettype($accountHolder)), __LINE__);
        }
        $this->AccountHolder = $accountHolder;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param string $transactionType
     * @return \eBizCharge\StructType\TransactionObject
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionType, true), gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
}
