<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReportData StructType
 * @subpackage Structs
 */
class GetReportData extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The filters
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfSearchFilter
     */
    public $filters;
    /**
     * The reportId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reportId;
    /**
     * The reportName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reportName;
    /**
     * The reportFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reportFormat;
    /**
     * Constructor method for GetReportData
     * @uses GetReportData::setSecurityToken()
     * @uses GetReportData::setFilters()
     * @uses GetReportData::setReportId()
     * @uses GetReportData::setReportName()
     * @uses GetReportData::setReportFormat()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @param string $reportId
     * @param string $reportName
     * @param string $reportFormat
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, \eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null, $reportId = null, $reportName = null, $reportFormat = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setFilters($filters)
            ->setReportId($reportId)
            ->setReportName($reportName)
            ->setReportFormat($reportFormat);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\GetReportData
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get filters value
     * @return \eBizCharge\ArrayType\ArrayOfSearchFilter|null
     */
    public function getFilters()
    {
        return $this->filters;
    }
    /**
     * Set filters value
     * @param \eBizCharge\ArrayType\ArrayOfSearchFilter $filters
     * @return \eBizCharge\StructType\GetReportData
     */
    public function setFilters(\eBizCharge\ArrayType\ArrayOfSearchFilter $filters = null)
    {
        $this->filters = $filters;
        return $this;
    }
    /**
     * Get reportId value
     * @return string|null
     */
    public function getReportId()
    {
        return $this->reportId;
    }
    /**
     * Set reportId value
     * @param string $reportId
     * @return \eBizCharge\StructType\GetReportData
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        $this->reportId = $reportId;
        return $this;
    }
    /**
     * Get reportName value
     * @return string|null
     */
    public function getReportName()
    {
        return $this->reportName;
    }
    /**
     * Set reportName value
     * @param string $reportName
     * @return \eBizCharge\StructType\GetReportData
     */
    public function setReportName($reportName = null)
    {
        // validation for constraint: string
        if (!is_null($reportName) && !is_string($reportName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportName, true), gettype($reportName)), __LINE__);
        }
        $this->reportName = $reportName;
        return $this;
    }
    /**
     * Get reportFormat value
     * @return string|null
     */
    public function getReportFormat()
    {
        return $this->reportFormat;
    }
    /**
     * Set reportFormat value
     * @param string $reportFormat
     * @return \eBizCharge\StructType\GetReportData
     */
    public function setReportFormat($reportFormat = null)
    {
        // validation for constraint: string
        if (!is_null($reportFormat) && !is_string($reportFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportFormat, true), gettype($reportFormat)), __LINE__);
        }
        $this->reportFormat = $reportFormat;
        return $this;
    }
}
