<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeviceSettings StructType
 * @subpackage Structs
 */
class DeviceSettings extends AbstractStructBase
{
    /**
     * The ShowDeviceList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $ShowDeviceList;
    /**
     * The DeviceKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeviceKey;
    /**
     * Constructor method for DeviceSettings
     * @uses DeviceSettings::setShowDeviceList()
     * @uses DeviceSettings::setDeviceKey()
     * @param bool $showDeviceList
     * @param string $deviceKey
     */
    public function __construct($showDeviceList = null, $deviceKey = null)
    {
        $this
            ->setShowDeviceList($showDeviceList)
            ->setDeviceKey($deviceKey);
    }
    /**
     * Get ShowDeviceList value
     * @return bool
     */
    public function getShowDeviceList()
    {
        return $this->ShowDeviceList;
    }
    /**
     * Set ShowDeviceList value
     * @param bool $showDeviceList
     * @return \eBizCharge\StructType\DeviceSettings
     */
    public function setShowDeviceList($showDeviceList = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDeviceList) && !is_bool($showDeviceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showDeviceList, true), gettype($showDeviceList)), __LINE__);
        }
        $this->ShowDeviceList = $showDeviceList;
        return $this;
    }
    /**
     * Get DeviceKey value
     * @return string|null
     */
    public function getDeviceKey()
    {
        return $this->DeviceKey;
    }
    /**
     * Set DeviceKey value
     * @param string $deviceKey
     * @return \eBizCharge\StructType\DeviceSettings
     */
    public function setDeviceKey($deviceKey = null)
    {
        // validation for constraint: string
        if (!is_null($deviceKey) && !is_string($deviceKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceKey, true), gettype($deviceKey)), __LINE__);
        }
        $this->DeviceKey = $deviceKey;
        return $this;
    }
}
