<?php

namespace eBizCharge\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfLineItem extends AbstractStructArrayBase
{
    /**
     * The LineItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \eBizCharge\StructType\LineItem[]
     */
    public $LineItem;
    /**
     * Constructor method for ArrayOfLineItem
     * @uses ArrayOfLineItem::setLineItem()
     * @param \eBizCharge\StructType\LineItem[] $lineItem
     */
    public function __construct(array $lineItem = array())
    {
        $this
            ->setLineItem($lineItem);
    }
    /**
     * Get LineItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \eBizCharge\StructType\LineItem[]|null
     */
    public function getLineItem()
    {
        return isset($this->LineItem) ? $this->LineItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemForArrayConstraintsFromSetLineItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLineItemLineItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineItemLineItemItem instanceof \eBizCharge\StructType\LineItem) {
                $invalidValues[] = is_object($arrayOfLineItemLineItemItem) ? get_class($arrayOfLineItemLineItemItem) : sprintf('%s(%s)', gettype($arrayOfLineItemLineItemItem), var_export($arrayOfLineItemLineItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineItem property can only contain items of type \eBizCharge\StructType\LineItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\LineItem[] $lineItem
     * @return \eBizCharge\ArrayType\ArrayOfLineItem
     */
    public function setLineItem(array $lineItem = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemArrayErrorMessage = self::validateLineItemForArrayConstraintsFromSetLineItem($lineItem))) {
            throw new \InvalidArgumentException($lineItemArrayErrorMessage, __LINE__);
        }
        if (is_null($lineItem) || (is_array($lineItem) && empty($lineItem))) {
            unset($this->LineItem);
        } else {
            $this->LineItem = $lineItem;
        }
        return $this;
    }
    /**
     * Add item to LineItem value
     * @throws \InvalidArgumentException
     * @param \eBizCharge\StructType\LineItem $item
     * @return \eBizCharge\ArrayType\ArrayOfLineItem
     */
    public function addToLineItem(\eBizCharge\StructType\LineItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \eBizCharge\StructType\LineItem) {
            throw new \InvalidArgumentException(sprintf('The LineItem property can only contain items of type \eBizCharge\StructType\LineItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \eBizCharge\StructType\LineItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \eBizCharge\StructType\LineItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \eBizCharge\StructType\LineItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \eBizCharge\StructType\LineItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \eBizCharge\StructType\LineItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineItem
     */
    public function getAttributeName()
    {
        return 'LineItem';
    }
}
