<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodProfilesSearchResult StructType
 * @subpackage Structs
 */
class PaymentMethodProfilesSearchResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Start;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Limit;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The PaymentMethodProfileDetailsList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails
     */
    public $PaymentMethodProfileDetailsList;
    /**
     * Constructor method for PaymentMethodProfilesSearchResult
     * @uses PaymentMethodProfilesSearchResult::setStart()
     * @uses PaymentMethodProfilesSearchResult::setLimit()
     * @uses PaymentMethodProfilesSearchResult::setCount()
     * @uses PaymentMethodProfilesSearchResult::setPaymentMethodProfileDetailsList()
     * @param int $start
     * @param int $limit
     * @param int $count
     * @param \eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails $paymentMethodProfileDetailsList
     */
    public function __construct($start = null, $limit = null, $count = null, \eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails $paymentMethodProfileDetailsList = null)
    {
        $this
            ->setStart($start)
            ->setLimit($limit)
            ->setCount($count)
            ->setPaymentMethodProfileDetailsList($paymentMethodProfileDetailsList);
    }
    /**
     * Get Start value
     * @return int
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param int $start
     * @return \eBizCharge\StructType\PaymentMethodProfilesSearchResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: int
        if (!is_null($start) && !(is_int($start) || ctype_digit($start))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \eBizCharge\StructType\PaymentMethodProfilesSearchResult
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !(is_int($limit) || ctype_digit($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \eBizCharge\StructType\PaymentMethodProfilesSearchResult
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get PaymentMethodProfileDetailsList value
     * @return \eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails|null
     */
    public function getPaymentMethodProfileDetailsList()
    {
        return $this->PaymentMethodProfileDetailsList;
    }
    /**
     * Set PaymentMethodProfileDetailsList value
     * @param \eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails $paymentMethodProfileDetailsList
     * @return \eBizCharge\StructType\PaymentMethodProfilesSearchResult
     */
    public function setPaymentMethodProfileDetailsList(\eBizCharge\ArrayType\ArrayOfPaymentMethodProfileDetails $paymentMethodProfileDetailsList = null)
    {
        $this->PaymentMethodProfileDetailsList = $paymentMethodProfileDetailsList;
        return $this;
    }
}
