<?php

namespace eBizCharge\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarkSalesOrderAsSynchronized StructType
 * @subpackage Structs
 */
class MarkSalesOrderAsSynchronized extends AbstractStructBase
{
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \eBizCharge\StructType\SecurityToken
     */
    public $securityToken;
    /**
     * The salesOrderInternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $salesOrderInternalId;
    /**
     * Constructor method for MarkSalesOrderAsSynchronized
     * @uses MarkSalesOrderAsSynchronized::setSecurityToken()
     * @uses MarkSalesOrderAsSynchronized::setSalesOrderInternalId()
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @param string $salesOrderInternalId
     */
    public function __construct(\eBizCharge\StructType\SecurityToken $securityToken = null, $salesOrderInternalId = null)
    {
        $this
            ->setSecurityToken($securityToken)
            ->setSalesOrderInternalId($salesOrderInternalId);
    }
    /**
     * Get securityToken value
     * @return \eBizCharge\StructType\SecurityToken|null
     */
    public function getSecurityToken()
    {
        return $this->securityToken;
    }
    /**
     * Set securityToken value
     * @param \eBizCharge\StructType\SecurityToken $securityToken
     * @return \eBizCharge\StructType\MarkSalesOrderAsSynchronized
     */
    public function setSecurityToken(\eBizCharge\StructType\SecurityToken $securityToken = null)
    {
        $this->securityToken = $securityToken;
        return $this;
    }
    /**
     * Get salesOrderInternalId value
     * @return string|null
     */
    public function getSalesOrderInternalId()
    {
        return $this->salesOrderInternalId;
    }
    /**
     * Set salesOrderInternalId value
     * @param string $salesOrderInternalId
     * @return \eBizCharge\StructType\MarkSalesOrderAsSynchronized
     */
    public function setSalesOrderInternalId($salesOrderInternalId = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderInternalId) && !is_string($salesOrderInternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderInternalId, true), gettype($salesOrderInternalId)), __LINE__);
        }
        $this->salesOrderInternalId = $salesOrderInternalId;
        return $this;
    }
}
